/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model;

import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.bmuschko.gradle.docker.shaded.com.fasterxml.jackson.annotation.JsonValue;
import com.bmuschko.gradle.docker.shaded.com.github.dockerjava.api.model.InternetProtocol;
import java.io.Serializable;

public class ExposedPort
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InternetProtocol protocol;
    private final int port;

    public ExposedPort(int port, InternetProtocol protocol) {
        this.port = port;
        this.protocol = protocol;
    }

    public ExposedPort(int port) {
        this(port, InternetProtocol.DEFAULT);
    }

    @Deprecated
    public ExposedPort(String scheme, int port) {
        this(port, InternetProtocol.valueOf(scheme));
    }

    public InternetProtocol getProtocol() {
        return this.protocol;
    }

    @Deprecated
    public String getScheme() {
        return this.protocol.toString();
    }

    public int getPort() {
        return this.port;
    }

    public static ExposedPort tcp(int port) {
        return new ExposedPort(port, InternetProtocol.TCP);
    }

    public static ExposedPort udp(int port) {
        return new ExposedPort(port, InternetProtocol.UDP);
    }

    public static ExposedPort sctp(int port) {
        return new ExposedPort(port, InternetProtocol.SCTP);
    }

    @JsonCreator
    public static ExposedPort parse(String serialized) throws IllegalArgumentException {
        try {
            String[] parts = serialized.split("/");
            switch (parts.length) {
                case 1: {
                    return new ExposedPort(Integer.parseInt(parts[0]));
                }
                case 2: {
                    return new ExposedPort(Integer.parseInt(parts[0]), InternetProtocol.parse(parts[1]));
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing ExposedPort '" + serialized + "'");
        }
    }

    @JsonValue
    public String toString() {
        return this.port + "/" + this.protocol.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExposedPort)) {
            return false;
        }
        ExposedPort other = (ExposedPort)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        InternetProtocol this$protocol = this.getProtocol();
        InternetProtocol other$protocol = other.getProtocol();
        return !(this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExposedPort;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        InternetProtocol $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        return result;
    }
}

