/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal.services;

import com.bmuschko.gradle.docker.tasks.DockerClientConfiguration;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class DockerClientService
implements BuildService<Params>,
AutoCloseable {
    private final Map<DefaultDockerClientConfig, DockerClient> dockerClients;
    private final ObjectFactory objects;

    @Inject
    public DockerClientService(ObjectFactory objects) {
        this.objects = objects;
        this.dockerClients = new ConcurrentHashMap<DefaultDockerClientConfig, DockerClient>();
    }

    public DockerClient getDockerClient(DockerClientConfiguration dockerClientConfiguration) {
        String dockerUrl = this.getDockerHostUrl(dockerClientConfiguration);
        File dockerCertPath = (File)this.thingOrProperty((Property)this.objects.directoryProperty(), (Object)dockerClientConfiguration.getCertPath(), (Property)((Params)this.getParameters()).getCertPath()).map(Directory::getAsFile).getOrNull();
        String apiVersion = (String)this.thingOrProperty(this.objects.property(String.class), dockerClientConfiguration.getApiVersion(), ((Params)this.getParameters()).getApiVersion()).getOrNull();
        DefaultDockerClientConfig.Builder dockerClientConfigBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        dockerClientConfigBuilder.withDockerHost(dockerUrl);
        if (dockerCertPath != null) {
            String canonicalCertPath;
            try {
                canonicalCertPath = dockerCertPath.getCanonicalPath();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            dockerClientConfigBuilder.withDockerTlsVerify(true);
            dockerClientConfigBuilder.withDockerCertPath(canonicalCertPath);
        } else {
            dockerClientConfigBuilder.withDockerTlsVerify(false);
        }
        if (apiVersion != null) {
            dockerClientConfigBuilder.withApiVersion(apiVersion);
        }
        DefaultDockerClientConfig dockerClientConfig = dockerClientConfigBuilder.build();
        return this.createDefaultDockerClient(dockerClientConfig);
    }

    private DockerClient createDefaultDockerClient(DefaultDockerClientConfig config) {
        return this.dockerClients.computeIfAbsent(config, i -> {
            ApacheDockerHttpClient dockerClient = new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig(config.getSSLConfig()).build();
            return DockerClientImpl.getInstance(config, dockerClient);
        });
    }

    private String getDockerHostUrl(DockerClientConfiguration dockerClientConfiguration) {
        String url = (String)this.thingOrProperty(this.objects.property(String.class), dockerClientConfiguration.getUrl(), ((Params)this.getParameters()).getUrl()).map(String::toLowerCase).get();
        return url.startsWith("http") ? "tcp" + url.substring(url.indexOf(58)) : url;
    }

    private <T> Provider<T> thingOrProperty(Property<T> prop, T t, Property<T> tp) {
        prop.set(t);
        return prop.orElse(tp);
    }

    @Override
    public void close() throws Exception {
        IOException throwable = null;
        for (DockerClient dockerClient : this.dockerClients.values()) {
            try {
                dockerClient.close();
            }
            catch (IOException e) {
                if (throwable == null) {
                    throwable = e;
                    continue;
                }
                throwable.addSuppressed(e);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public static interface Params
    extends BuildServiceParameters {
        public Property<String> getUrl();

        public DirectoryProperty getCertPath();

        public Property<String> getApiVersion();
    }
}

