/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.async;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.HttpRoute;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.async.AsyncExecRuntime;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.auth.CredentialsProvider;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.config.RequestConfig;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.cookie.CookieStore;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Contract;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Internal;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpHost;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.HttpVersion;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.config.Lookup;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.HandlerFactory;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.HttpVersionPolicy;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalHttpAsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalHttpAsyncClient.class);
    private final AsyncClientConnectionManager manager;
    private final HttpRoutePlanner routePlanner;
    private final HttpVersionPolicy versionPolicy;

    InternalHttpAsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, AsyncClientConnectionManager manager, HttpRoutePlanner routePlanner, HttpVersionPolicy versionPolicy, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, defaultConfig, closeables);
        this.manager = manager;
        this.routePlanner = routePlanner;
        this.versionPolicy = versionPolicy;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        return new InternalHttpAsyncExecRuntime(LOG, this.manager, this.getConnectionInitiator(), pushHandlerFactory, this.versionPolicy);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, clientContext);
        ProtocolVersion protocolVersion = clientContext.getProtocolVersion();
        if (route.isTunnelled() && protocolVersion.greaterEquals(HttpVersion.HTTP_2_0)) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

