/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal;

import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.bmuschko.gradle.docker.shaded.org.apache.commons.codec.binary.Base64;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.NameParser;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class RegistryAuthLocator
implements GroovyObject {
    private static final String DOCKER_CONFIG = "DOCKER_CONFIG";
    private static final String USER_HOME = "user.home";
    private static final String DOCKER_DIR = ".docker";
    private static final String CONFIG_JSON = "config.json";
    private static final String AUTH_SECTION = "auths";
    private static final String HELPERS_SECTION = "credHelpers";
    private static final String CREDS_STORE_SECTION = "credsStore";
    private static final String DEFAULT_HELPER_PREFIX = "docker-credential-";
    private Logger logger;
    private final JsonSlurper slurper;
    private final File configFile;
    private final String commandPathPrefix;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public RegistryAuthLocator(File configFile, String commandPathPrefix) {
        String string;
        File file;
        MetaClass metaClass;
        JsonSlurper jsonSlurper;
        Logger logger;
        this.logger = logger = Logging.getLogger(RegistryAuthLocator.class);
        this.slurper = jsonSlurper = new JsonSlurper();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.configFile = file = configFile;
        this.commandPathPrefix = string = commandPathPrefix;
    }

    public RegistryAuthLocator(File configFile) {
        this(configFile, DEFAULT_HELPER_PREFIX);
    }

    public RegistryAuthLocator() {
        this(new File(RegistryAuthLocator.configLocation()), DEFAULT_HELPER_PREFIX);
    }

    AuthConfig lookupAuthConfigWithDefaultAuthConfig(String image) {
        return this.lookupAuthConfigWithAuthConfig(image, new AuthConfig());
    }

    public AuthConfig lookupAuthConfig(String image, DockerRegistryCredentials registryCredentials) {
        AuthConfig defaultConfig = this.createAuthConfig(registryCredentials);
        if (this.isProvidedByBuild(defaultConfig)) {
            return defaultConfig;
        }
        return this.lookupAuthConfigWithAuthConfig(image, defaultConfig);
    }

    private boolean isProvidedByBuild(AuthConfig defaultConfig) {
        return DefaultTypeTransformation.booleanUnbox((Object)defaultConfig.getRegistryAddress()) && DefaultTypeTransformation.booleanUnbox((Object)defaultConfig.getUsername()) && DefaultTypeTransformation.booleanUnbox((Object)defaultConfig.getPassword());
    }

    private AuthConfig lookupAuthConfigWithAuthConfig(String image, AuthConfig defaultAuthConfig) {
        AuthConfig authConfigForRegistry = this.lookupAuthConfigForRegistry(this.getRegistry(image));
        if (authConfigForRegistry != null) {
            return authConfigForRegistry;
        }
        return defaultAuthConfig;
    }

    /*
     * Unable to fully structure code
     */
    private AuthConfig lookupAuthConfigForRegistry(String registry) {
        block8: {
            this.logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{registry}, new String[]{"Looking up auth config for registry: ", ""})));
            this.logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.configFile.getAbsolutePath(), this.configFile.exists() != false ? "exists" : "does not exist", this.commandPathPrefix}, new String[]{"RegistryAuthLocator has configFile: ", " (", ") and commandPathPrefix: ", ""})));
            if (this.configFile.isFile() == false) {
                return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
            }
            config = (Map)ScriptBytecodeAdapter.asType((Object)this.slurper.parse(this.configFile), Map.class);
            existingAuthConfig = this.findExistingAuthConfig(config, registry);
            if (!(existingAuthConfig != null)) ** GOTO lbl18
            var4_4 = RegistryAuthLocator.decodeAuth(existingAuthConfig);
            return var4_4;
lbl18:
            // 1 sources

            helperAuthConfig = this.authConfigUsingHelper(config, registry);
            if (!(helperAuthConfig != null)) ** GOTO lbl26
            var6_6 = RegistryAuthLocator.decodeAuth(helperAuthConfig);
            return var6_6;
lbl26:
            // 1 sources

            storeAuthConfig = this.authConfigUsingStore(config, registry);
            if (!(storeAuthConfig != null)) break block8;
            var8_8 = RegistryAuthLocator.decodeAuth(storeAuthConfig);
            try {
                return var8_8;
            }
            catch (Exception ex) {
                this.logger.error(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Failure when attempting to lookup auth config ", (CharSequence)"(docker registry: {}, configFile: {}). "), (CharSequence)"Falling back to docker-java default behaviour"), new Object[]{registry, this.configFile, ex});
            }
        }
        return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
    }

    public AuthConfigurations lookupAllAuthConfigs() {
        AuthConfigurations authConfigurations = new AuthConfigurations();
        this.logger.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.configFile.getAbsolutePath(), this.configFile.exists() ? "exists" : "does not exist", this.commandPathPrefix}, new String[]{"RegistryAuthLocator has configFile: ", " (", ") and commandPathPrefix: ", ""})));
        if (!this.configFile.isFile()) {
            return authConfigurations;
        }
        try {
            HashSet registryAddresses = new HashSet();
            Map config = (Map)ScriptBytecodeAdapter.asType((Object)this.slurper.parse(this.configFile), Map.class);
            Map authSectionRegistries = (Map)ScriptBytecodeAdapter.asType(config.getOrDefault(AUTH_SECTION, new HashMap()), Map.class);
            this.logger.debug("Found registries in docker auths section: {}", (Object)authSectionRegistries.keySet());
            DefaultGroovyMethods.addAll(registryAddresses, authSectionRegistries.keySet());
            Map credHelperSectionRegistries = (Map)ScriptBytecodeAdapter.asType(config.getOrDefault(HELPERS_SECTION, new HashMap()), Map.class);
            this.logger.debug("Found registries in docker credHelpers section: {}", (Object)credHelperSectionRegistries.keySet());
            DefaultGroovyMethods.addAll(registryAddresses, credHelperSectionRegistries.keySet());
            Object credStoreSection = config.get(CREDS_STORE_SECTION);
            if (credStoreSection != null && credStoreSection instanceof String) {
                String credStoreCommand = StringGroovyMethods.plus((String)this.commandPathPrefix, (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType(credStoreSection, CharSequence.class)));
                this.logger.debug("Executing docker credential helper: {} to locate auth configs", (Object)credStoreCommand);
                String credStoreResponse = this.runCommand(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{credStoreCommand}, new String[]{"", " list"})));
                this.logger.debug("Credential helper response: {}", (Object)credStoreResponse);
                Map helperResponse = (Map)ScriptBytecodeAdapter.asType((Object)this.parseText(credStoreResponse), Map.class);
                if (helperResponse != null) {
                    this.logger.debug("Found registries in docker credential helper: {}", (Object)helperResponse.keySet());
                    DefaultGroovyMethods.addAll(registryAddresses, helperResponse.keySet());
                }
            }
            String registryAddress = null;
            Iterator iterator = registryAddresses.iterator();
            while (iterator.hasNext()) {
                registryAddress = ShortTypeHandling.castToString(iterator.next());
                AuthConfig registryAuthConfig = this.lookupAuthConfigForRegistry(registryAddress);
                if (!(registryAuthConfig != null)) continue;
                authConfigurations.addConfig(registryAuthConfig);
            }
        }
        catch (Exception ex) {
            this.logger.error(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Failure when attempting to lookup auth config ", (CharSequence)"(configFile: {}). "), (CharSequence)"Falling back to docker-java default behaviour"), (Object)this.configFile, (Object)ex);
        }
        return authConfigurations;
    }

    public AuthConfigurations lookupAllAuthConfigs(DockerRegistryCredentials registryCredentials) {
        return this.lookupAllAuthConfigs(this.createAuthConfig(registryCredentials));
    }

    public AuthConfigurations lookupAllAuthConfigs(AuthConfig additionalAuthConfig) {
        AuthConfigurations allAuthConfigs = this.lookupAllAuthConfigs();
        if (allAuthConfigs.getConfigs().isEmpty()) {
            allAuthConfigs.addConfig(additionalAuthConfig);
        }
        return allAuthConfigs;
    }

    private AuthConfig createAuthConfig(DockerRegistryCredentials registryCredentials) {
        AuthConfig authConfig = new AuthConfig();
        authConfig.withRegistryAddress(ShortTypeHandling.castToString((Object)registryCredentials.getUrl().get()));
        if (registryCredentials.getUsername().isPresent()) {
            authConfig.withUsername(ShortTypeHandling.castToString((Object)registryCredentials.getUsername().get()));
        }
        if (registryCredentials.getPassword().isPresent()) {
            authConfig.withPassword(ShortTypeHandling.castToString((Object)registryCredentials.getPassword().get()));
        }
        if (registryCredentials.getEmail().isPresent()) {
            authConfig.withEmail(ShortTypeHandling.castToString((Object)registryCredentials.getEmail().get()));
        }
        return authConfig;
    }

    private static String configLocation() {
        String defaultDir = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)System.getProperty(USER_HOME), (CharSequence)File.separator), (CharSequence)DOCKER_DIR);
        String dir = ShortTypeHandling.castToString((Object)System.getenv().getOrDefault(DOCKER_CONFIG, defaultDir));
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)dir, (CharSequence)File.separator), (CharSequence)CONFIG_JSON);
    }

    public String getRegistry(String image) {
        NameParser.ReposTag tag = NameParser.parseRepositoryTag(image);
        NameParser.HostnameReposName repository = NameParser.resolveRepositoryName(tag.repos);
        return repository.hostname;
    }

    private AuthConfig findExistingAuthConfig(Map<String, Object> config, String repository) {
        Map.Entry<String, Object> entry = RegistryAuthLocator.findAuthNode(config, repository);
        if (entry != null && entry.getValue() != null && entry.getValue() instanceof Map) {
            Map authMap = (Map)ScriptBytecodeAdapter.asType((Object)entry.getValue(), Map.class);
            if (authMap.size() > 0) {
                String authJson = JsonOutput.toJson((Object)entry.getValue());
                AuthConfig authCfg = (AuthConfig)ScriptBytecodeAdapter.asType((Object)this.parseText(authJson), AuthConfig.class);
                if (authCfg == null) {
                    return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
                }
                return authCfg.withRegistryAddress(ShortTypeHandling.castToString((Object)entry.getKey()));
            }
        }
        this.logger.debug("No existing AuthConfig found");
        return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
    }

    private static Map.Entry<String, Object> findAuthNode(Map<String, Object> config, String repository) {
        Map auths = (Map)ScriptBytecodeAdapter.asType((Object)config.get(AUTH_SECTION), Map.class);
        if (auths != null && auths.size() > 0) {
            Map.Entry entry = null;
            Iterator iterator = auths.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                if (!(((String)entry.getKey()).endsWith(StringGroovyMethods.plus((String)"://", (CharSequence)repository)) || ScriptBytecodeAdapter.compareEqual(entry.getKey(), (Object)repository))) continue;
                return entry;
            }
        }
        return (Map.Entry)ScriptBytecodeAdapter.castToType(null, Map.Entry.class);
    }

    private AuthConfig authConfigUsingHelper(Map<String, Object> config, String repository) {
        Map credHelpers = (Map)ScriptBytecodeAdapter.asType((Object)config.get(HELPERS_SECTION), Map.class);
        if (credHelpers != null && credHelpers.size() > 0) {
            Object helperNode = credHelpers.get(repository);
            if (helperNode != null && helperNode instanceof String) {
                String helper = (String)ScriptBytecodeAdapter.asType(helperNode, String.class);
                return this.runCredentialProvider(repository, helper);
            }
        }
        this.logger.debug("No helper found in the {} section", (Object)HELPERS_SECTION);
        return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
    }

    private AuthConfig runCredentialProvider(String hostName, String credHelper) {
        Reference hostName2 = new Reference((Object)hostName);
        String credentialHelperName = StringGroovyMethods.plus((String)this.commandPathPrefix, (CharSequence)credHelper);
        this.logger.debug("Executing docker credential helper: {} to locate auth config for: {}", (Object)credentialHelperName, (Object)((String)hostName2.get()));
        public final class _runCredentialProvider_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference hostName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _runCredentialProvider_closure1(Object _outerInstance, Object _thisObject, Reference hostName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.hostName = reference = hostName;
            }

            public Writer doCall(Writer writer) {
                return IOGroovyMethods.leftShift((Writer)writer, (Object)this.hostName.get());
            }

            @Generated
            public Writer call(Writer writer) {
                return this.doCall(writer);
            }

            @Generated
            public String getHostName() {
                return ShortTypeHandling.castToString((Object)this.hostName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _runCredentialProvider_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        String data = this.runCommand(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{credentialHelperName}, new String[]{"", " get"})), (Action<Writer>)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _runCredentialProvider_closure1(this, this, hostName2)), Action.class)));
        this.logger.debug("Credential helper response: {}", (Object)data);
        Map helperResponse = (Map)ScriptBytecodeAdapter.asType((Object)this.parseText(data), Map.class);
        if (helperResponse == null) {
            return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
        }
        this.logger.debug("Credential helper provided auth config for: {}", (Object)((String)hostName2.get()));
        Object v = helperResponse.get("ServerURL");
        String string = ShortTypeHandling.castToString(v);
        String registryAddress = DefaultTypeTransformation.booleanUnbox(v) ? string : (String)hostName2.get();
        return new AuthConfig().withRegistryAddress(registryAddress).withUsername(ShortTypeHandling.castToString(helperResponse.get("Username"))).withPassword(ShortTypeHandling.castToString(helperResponse.get("Secret")));
    }

    private AuthConfig authConfigUsingStore(Map<String, Object> config, String repository) {
        Object credsStoreNode = config.get(CREDS_STORE_SECTION);
        if (credsStoreNode != null && credsStoreNode instanceof String) {
            String credsStore = (String)ScriptBytecodeAdapter.asType((Object)credsStoreNode, String.class);
            return this.runCredentialProvider(repository, credsStore);
        }
        this.logger.debug("No helper found in the {} section", (Object)CREDS_STORE_SECTION);
        return (AuthConfig)ScriptBytecodeAdapter.castToType(null, AuthConfig.class);
    }

    private String runCommand(String command) {
        return this.runCommand(command, null);
    }

    private String runCommand(String command, Action<Writer> writerAction) {
        Reference writerAction2 = new Reference(writerAction);
        StringBuilder sOut = new StringBuilder();
        StringBuilder sErr = new StringBuilder();
        Process proc = ProcessGroovyMethods.execute((String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{command}, new String[]{"", ""})));
        if ((Action)writerAction2.get() != null) {
            public final class _runCommand_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference writerAction;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _runCommand_closure2(Object _outerInstance, Object _thisObject, Reference writerAction) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.writerAction = reference = writerAction;
                }

                public Object doCall(Writer writer) {
                    ((Action)this.writerAction.get()).execute((Object)writer);
                    return null;
                }

                @Generated
                public Object call(Writer writer) {
                    return this.doCall(writer);
                }

                @Generated
                public Action getWriterAction() {
                    return (Action)ScriptBytecodeAdapter.castToType((Object)this.writerAction.get(), Action.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _runCommand_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ProcessGroovyMethods.withWriter((Process)proc, (Closure)new _runCommand_closure2(this, this, writerAction2));
        }
        proc.waitFor();
        ProcessGroovyMethods.waitForProcessOutput((Process)proc, (Appendable)sOut, (Appendable)sErr);
        if (sErr.length() > 0) {
            this.logger.error("{}: {}", (Object)command, (Object)sErr.toString());
        }
        String string = sOut.toString();
        try {
            return string;
        }
        catch (Exception e) {
            this.logger.error("Failure running command ({})", (Object)command);
            throw (Throwable)e;
        }
    }

    private static AuthConfig decodeAuth(AuthConfig config) {
        if (config.getAuth() == null) {
            return config;
        }
        String str = new String(Base64.decodeBase64(config.getAuth()), StandardCharsets.UTF_8);
        Object[] parts = str.split(":", 2);
        if (parts.length != 2) {
            throw (Throwable)new IOException("Invalid auth configuration file");
        }
        config.withUsername(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)0)));
        config.withPassword(ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)1)));
        config.withAuth(null);
        return config;
    }

    private Object parseText(String data) {
        Object object = this.slurper.parseText(data);
        try {
            return object;
        }
        catch (Exception e) {
            this.logger.debug("Failure parsing the json response {}", (Object)data, (Object)e);
            Object var4_4 = null;
            return var4_4;
        }
    }

    void setLogger(Logger logger) {
        Logger logger2;
        this.logger = logger2 = logger;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RegistryAuthLocator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }
}

