/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.bmuschko.gradle.docker.shaded.com.google.common.base.Preconditions;
import com.bmuschko.gradle.docker.shaded.javax.annotation.Nonnull;
import com.github.dockerjava.api.command.SearchImagesCmd;
import com.github.dockerjava.api.model.SearchItem;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import java.util.List;

public class SearchImagesCmdImpl
extends AbstrDockerCmd<SearchImagesCmd, List<SearchItem>>
implements SearchImagesCmd {
    private static final int MIN_LIMIT = 1;
    private static final int MAX_LIMIT = 100;
    private String term;
    private Integer limit;

    public SearchImagesCmdImpl(SearchImagesCmd.Exec exec, String term) {
        super(exec);
        this.withTerm(term);
    }

    @Override
    public String getTerm() {
        return this.term;
    }

    @Override
    public SearchImagesCmd withTerm(String term) {
        Preconditions.checkNotNull(term, "term was not specified");
        this.term = term;
        return this;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public SearchImagesCmd withLimit(@Nonnull Integer limit) {
        String errorMessage = String.format("Limit %s is outside the range of [%s, %s]", limit, 1, 100);
        Preconditions.checkArgument(limit <= 100, errorMessage);
        Preconditions.checkArgument(limit >= 1, errorMessage);
        this.limit = limit;
        return this;
    }
}

