/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.cookie;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.cookie.MalformedCookieException;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.cookie.SetCookie;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.utils.DateUtils;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Contract;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.Args;
import java.util.Date;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

