/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;

public class DockerExtension
implements GroovyObject {
    private final Project project;
    private final ConfigurableFileCollection classpath;
    private final Property<String> url;
    private final DirectoryProperty certPath;
    private final Property<String> apiVersion;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public DockerExtension(Project project) {
        Property property;
        DirectoryProperty directoryProperty;
        Property property2;
        ConfigurableFileCollection configurableFileCollection;
        Project project2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.project = project2 = project;
        this.classpath = configurableFileCollection = project.getLayout().configurableFiles(new Object[0]);
        this.url = property2 = project.getObjects().property(String.class);
        this.url.set((Object)this.getDefaultDockerUrl());
        this.certPath = directoryProperty = project.getLayout().directoryProperty();
        File defaultDockerCert = this.getDefaultDockerCert();
        if (DefaultTypeTransformation.booleanUnbox((Object)defaultDockerCert)) {
            this.certPath.set(defaultDockerCert);
        }
        this.apiVersion = property = project.getObjects().property(String.class);
    }

    public String getDefaultDockerUrl() {
        String dockerUrl = System.getenv("DOCKER_HOST");
        if (!DefaultTypeTransformation.booleanUnbox((Object)dockerUrl)) {
            String string;
            String string2;
            String string3;
            boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
            dockerUrl = !isWindows && new File("/var/run/docker.sock").exists() ? (string3 = "unix:///var/run/docker.sock") : (isWindows && new File("\\\\.\\pipe\\docker_engine").exists() ? (string2 = "tcp://127.0.0.1:2375") : (string = "tcp://127.0.0.1:2375"));
        }
        this.project.getLogger().info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dockerUrl}, new String[]{"Default docker.url set to ", ""})));
        return dockerUrl;
    }

    public File getDefaultDockerCert() {
        String dockerCertPath = System.getenv("DOCKER_CERT_PATH");
        if (DefaultTypeTransformation.booleanUnbox((Object)dockerCertPath)) {
            File certFile = new File(dockerCertPath);
            if (certFile.exists()) {
                return certFile;
            }
        }
        return (File)ScriptBytecodeAdapter.castToType(null, File.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DockerExtension.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public final ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    public final Property<String> getUrl() {
        return this.url;
    }

    public final DirectoryProperty getCertPath() {
        return this.certPath;
    }

    public final Property<String> getApiVersion() {
        return this.apiVersion;
    }
}

