/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.generators;

import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.CryptoServicePurpose;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.constraints.ConstraintUtils;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECConstants;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECMultiplier;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.ECPoint;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.math.ec.WNafUtil;
import com.bmuschko.gradle.docker.shaded.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    private final String name;
    ECDomainParameters params;
    SecureRandom random;

    public ECKeyPairGenerator() {
        this("ECKeyGen");
    }

    protected ECKeyPairGenerator(String string) {
        this.name = string;
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        ECKeyGenerationParameters eCKeyGenerationParameters = (ECKeyGenerationParameters)keyGenerationParameters;
        this.random = eCKeyGenerationParameters.getRandom();
        this.params = eCKeyGenerationParameters.getDomainParameters();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.name, ConstraintUtils.bitsOfSecurityFor(this.params.getCurve()), eCKeyGenerationParameters.getDomainParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getN();
        int n = bigInteger2.bitLength();
        int n2 = n >>> 2;
        while (this.isOutOfRangeD(bigInteger = BigIntegers.createRandomBigInteger(n, this.random), bigInteger2) || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        ECPoint eCPoint = this.createBasePointMultiplier().multiply(this.params.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(eCPoint, this.params), new ECPrivateKeyParameters(bigInteger, this.params));
    }

    protected boolean isOutOfRangeD(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger2) >= 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

