/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker;

import com.bmuschko.gradle.docker.shaded.javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class DockerRegistryCredentials {
    public static final String DEFAULT_URL = "https://index.docker.io/v1/";
    private final Property<String> url;
    private final Property<String> username;
    private final Property<String> password;
    private final Property<String> email;

    @Input
    public final Property<String> getUrl() {
        return this.url;
    }

    @Input
    @Optional
    public final Property<String> getUsername() {
        return this.username;
    }

    @Input
    @Optional
    public final Property<String> getPassword() {
        return this.password;
    }

    @Input
    @Optional
    public final Property<String> getEmail() {
        return this.email;
    }

    @Inject
    public DockerRegistryCredentials(ObjectFactory objectFactory) {
        this.url = objectFactory.property(String.class);
        this.url.convention((Object)DEFAULT_URL);
        this.username = objectFactory.property(String.class);
        this.password = objectFactory.property(String.class);
        this.email = objectFactory.property(String.class);
    }

    public PasswordCredentials asPasswordCredentials() {
        return new PasswordCredentials(){

            public String getUsername() {
                return (String)DockerRegistryCredentials.this.getUsername().get();
            }

            public void setUsername(@Nullable String userName) {
                DockerRegistryCredentials.this.getUsername().set((Object)userName);
            }

            public String getPassword() {
                return (String)DockerRegistryCredentials.this.getPassword().get();
            }

            public void setPassword(@Nullable String password) {
                DockerRegistryCredentials.this.getPassword().set((Object)password);
            }
        };
    }
}

