/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.clover.internal;

import groovy.util.Node;
import groovy.util.NodeList;
import groovy.util.XmlParser;
import java.io.Closeable;
import java.io.InputStream;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;

public class AntResourceWorkaround {
    private final DynamicObject builder;
    private final ClassLoader antlibClassLoader;

    public AntResourceWorkaround(Object builder) {
        this.builder = this.asDynamicObject(builder);
        this.antlibClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void taskdef(String resource) {
        InputStream instr = this.antlibClassLoader.getResourceAsStream(resource);
        try {
            String className;
            String name;
            Node xml = new XmlParser().parse(instr);
            for (Object taskdefObject : (NodeList)xml.get("taskdef")) {
                Node taskdef = (Node)taskdefObject;
                name = (String)taskdef.get("@name");
                className = (String)taskdef.get("@classname");
                this.addTaskDefinition(name, className);
            }
            for (Object typedefObject : (NodeList)xml.get("typedef")) {
                Node typedef = (Node)typedefObject;
                name = (String)typedef.get("@name");
                className = (String)typedef.get("@classname");
                this.addDataTypeDefinition(name, className);
            }
        }
        catch (Exception ex) {
            throw UncheckedException.throwAsUncheckedException((Throwable)ex);
        }
        finally {
            IoActions.closeQuietly((Closeable)instr);
        }
    }

    private void addTaskDefinition(String name, String className) throws ClassNotFoundException {
        DynamicObject project = this.asDynamicObject(this.builder.getProperty("project"));
        project.invokeMethod("addTaskDefinition", new Object[]{name, this.antlibClassLoader.loadClass(className)});
    }

    private void addDataTypeDefinition(String name, String className) throws ClassNotFoundException {
        DynamicObject project = this.asDynamicObject(this.builder.getProperty("project"));
        project.invokeMethod("addDataTypeDefinition", new Object[]{name, this.antlibClassLoader.loadClass(className)});
    }

    private DynamicObject asDynamicObject(Object object) {
        if (object instanceof DynamicObject) {
            return (DynamicObject)object;
        }
        if (object instanceof DynamicObjectAware) {
            return ((DynamicObjectAware)object).getAsDynamicObject();
        }
        return new BeanDynamicObject(object);
    }
}

