/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import com.bmc.ims.ExceptionType;
import com.bmc.ims.ReportTableModel;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.Palette;
import edu.hm.hafner.echarts.PieChartModel;
import edu.hm.hafner.echarts.PieData;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.datatables.DefaultAsyncTableContentProvider;
import io.jenkins.plugins.datatables.TableModel;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportViewModel
extends DefaultAsyncTableContentProvider
implements ModelObject {
    JSONArray ja;
    Run owner;
    String rptType;
    ArrayList<ExceptionType> exceptions = new ArrayList();

    public ReportViewModel(Run owner, JSONArray ja, String reportType) {
        this.ja = ja;
        this.owner = owner;
        this.rptType = reportType;
    }

    public TableModel getTableModel(String s) {
        return new ReportTableModel(this.ja, this.rptType);
    }

    public String getDisplayName() {
        if (this.rptType.equals("IMS")) {
            return "Application Checkpoint";
        }
        return "Commit";
    }

    public String getCommitModel() {
        return this.create();
    }

    public Run getOwner() {
        return this.owner;
    }

    public String getRptType() {
        return this.rptType;
    }

    public String create() {
        boolean moreThen5 = false;
        boolean lessThen60 = false;
        boolean others = false;
        for (int i = 1; i < this.ja.length(); ++i) {
            Object end;
            int num;
            JSONObject obj = (JSONObject)this.ja.get(i);
            String exceptionText = obj.get("exceptions").toString();
            String[] tmpArr = exceptionText.split("than");
            String start = tmpArr[0].replace("***", "") + " than";
            if (tmpArr.length > 1) {
                String[] arr2 = this.rptType.equals("IMS") || this.rptType.equals("DLI") ? tmpArr[1].split("chkp") : tmpArr[1].split("commits");
                num = Integer.parseInt(arr2[0].trim());
                end = this.rptType.equals("IMS") || this.rptType.equals("DLI") ? "chkp " + arr2[1] : "commits " + arr2[1];
            } else {
                num = 0;
                end = "Others";
            }
            if (this.exceptions.size() == 0) {
                this.exceptions.add(new ExceptionType(start, num, (String)end));
            }
            for (int j = 0; j < this.exceptions.size(); ++j) {
                ExceptionType ex = this.exceptions.get(j);
                if (ex.start.equals(start) && ex.end.equals(end) && ex.num == num) {
                    ++ex.count;
                    continue;
                }
                ExceptionType ex1 = new ExceptionType(start, num, (String)end);
                this.exceptions.add(ex1);
            }
        }
        PieChartModel model = new PieChartModel("Commit Dist");
        for (int j = 0; j < this.exceptions.size(); ++j) {
            ExceptionType ex = this.exceptions.get(j);
            if (ex.end == "Others") {
                model.add(new PieData("Others", ex.count), Palette.color((int)j));
                continue;
            }
            model.add(new PieData(ex.start + " " + ex.num + " " + ex.end, ex.count), Palette.color((int)j));
        }
        String json = new JacksonFacade().toJson((Object)model);
        return json;
    }
}

