/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportTableModel
extends TableModel {
    private JSONArray ja;
    String rptType;

    public ReportTableModel(JSONArray ja, String rptType) {
        this.ja = ja;
        this.rptType = rptType;
    }

    public String getId() {
        return "cfa";
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        columns.add(new TableColumn("Job name", "jobName"));
        if (this.rptType.equals("IMS")) {
            columns.add(new TableColumn("PSB Name", "psbName"));
        } else {
            columns.add(new TableColumn("Plan Name", "planName"));
        }
        columns.add(new TableColumn("Start time", "startTime"));
        if (this.rptType.equals("IMS")) {
            columns.add(new TableColumn("#Checkpoints", "chkpt#"));
        } else {
            columns.add(new TableColumn("#Commits", "commits#"));
        }
        if (this.rptType.equals("IMS")) {
            columns.add(new TableColumn("Checkpoint Type", "chkptType"));
        }
        columns.add(new TableColumn("Job Duration", "jobDuration"));
        columns.add(new TableColumn("Commit per min", "freqPerMin"));
        columns.add(new TableColumn("Commit per sec", "freqPerSec"));
        columns.add(new TableColumn("Exceptions", "exceptions"));
        return columns;
    }

    public List<Object> getRows() {
        ArrayList<Object> rows = new ArrayList<Object>();
        for (int i = 1; i < this.ja.length(); ++i) {
            JSONObject obj = (JSONObject)this.ja.get(i);
            HashMap<String, String> rowsMap = new HashMap<String, String>();
            rowsMap.put("jobName", obj.getString("jobName"));
            if (this.rptType.equals("IMS")) {
                rowsMap.put("psbName", obj.getString("psbName"));
            } else {
                rowsMap.put("planName", obj.getString("planName"));
            }
            rowsMap.put("startTime", obj.getString("startTime"));
            if (this.rptType.equals("IMS")) {
                rowsMap.put("chkpt#", obj.getString("chkpt#"));
                rowsMap.put("chkptType", obj.getString("chkptType"));
            } else {
                rowsMap.put("commits#", obj.getString("commits#"));
            }
            rowsMap.put("jobDuration", obj.getString("jobDuration"));
            rowsMap.put("freqPerMin", obj.getString("freqPerMin"));
            rowsMap.put("freqPerSec", obj.getString("freqPerSec"));
            rowsMap.put("exceptions", obj.getString("exceptions"));
            rows.add(rowsMap);
        }
        return rows;
    }
}

