/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.json.JSONArray;
import org.json.JSONObject;

public class CsvFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray readCsvFile(String csvFilePath) {
        BufferedReader br = null;
        File file = new File(csvFilePath);
        JSONArray reportJsonArrayObj = new JSONArray();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] values = line.split(",");
                reportJsonArrayObj.put((Object)CsvFile.createJsonModel(values, file.getName()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return reportJsonArrayObj;
    }

    private static JSONObject createJsonModel(String[] values, String rptType) {
        JSONObject obj = new JSONObject();
        obj.put("jobName", (Object)values[0]);
        if (rptType.contains("DB2")) {
            obj.put("planName", (Object)values[1]);
            obj.put("startTime", (Object)values[2]);
            obj.put("commits#", (Object)values[3]);
            obj.put("jobDuration", (Object)values[5]);
            obj.put("freqPerMin", (Object)values[6]);
            obj.put("freqPerSec", (Object)values[7]);
            obj.put("exceptions", (Object)values[8]);
        } else if (rptType.contains("IMS") || rptType.contains("DLI")) {
            obj.put("psbName", (Object)values[1]);
            obj.put("startTime", (Object)values[2]);
            obj.put("chkpt#", (Object)values[3]);
            obj.put("chkptType", (Object)values[4]);
            obj.put("jobDuration", (Object)values[5]);
            obj.put("freqPerMin", (Object)values[6]);
            obj.put("freqPerSec", (Object)values[7]);
            obj.put("exceptions", (Object)values[8]);
        }
        return obj;
    }
}

