/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ims;

import com.bmc.ims.BmcCfaAction;
import com.bmc.ims.CfaDliLib;
import com.bmc.ims.CfaImsid;
import com.bmc.ims.CfaJobname;
import com.bmc.ims.CfaLoadLib;
import com.bmc.ims.CfaReconSet;
import com.bmc.ims.CfaSldsLib;
import com.bmc.ims.JCLService;
import com.bmc.ims.ResponseObject;
import com.bmc.ims.Start;
import com.bmc.ims.Stop;
import com.bmc.ims.Timezone;
import groovy.lang.Binding;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;

@Extension
public class BmcCfaBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private String server;
    private String port;
    private String user;
    private String jclContent;
    private String jobCard;
    private String acctno;
    private String goodRC;
    private String db2log;
    private String db2bsds;
    private String limit;
    private String skip;
    private String maxlogs;
    private String prilog;
    private String thresh;
    private String sortby;
    private String maxlogsRc;
    private String maxlogsAbend;
    private String jobInclude;
    private String jobExclude;
    private String psbInclude;
    private String psbExclude;
    private String chkfreqval;
    private String planInclude;
    private String planExclude;
    private String chkfreq;
    private boolean bmcSlds;
    private boolean bmcDb2log;
    private boolean bmcDb2bsds;
    private boolean bmcLimit;
    private boolean bmcSkip;
    private boolean bmcActiveOlds;
    private boolean bmcImsid;
    private boolean bmcDlilog;
    private boolean bmcMaxlogs;
    private boolean bmcJobname;
    private boolean bmcRecon;
    private boolean bmcTimezone;
    private boolean bmcStartInterval;
    private boolean bmcStopInterval;
    private boolean bmcJobInc;
    private boolean bmcJobExc;
    private boolean bmcPsbInc;
    private boolean bmcPsbExc;
    private boolean bmcThresh;
    private boolean bmcChkfreq;
    private boolean bmcAppcheck;
    private boolean bmcAll;
    private boolean bmcLsec;
    private boolean bmcPlanInc;
    private boolean bmcPlanExc;
    private boolean bmcSortby;
    private boolean bmcCsv;
    private boolean bmcFullreport;
    private boolean bmcPrilog;
    private List<CfaLoadLib> cfaLoadLibs = new ArrayList<CfaLoadLib>();
    private List<CfaSldsLib> cfaSldsLibs = new ArrayList<CfaSldsLib>();
    private List<CfaDliLib> cfaDliLibs = new ArrayList<CfaDliLib>();
    private List<CfaImsid> cfaImsids = new ArrayList<CfaImsid>();
    private List<CfaJobname> cfaJobnames = new ArrayList<CfaJobname>();
    private List<CfaReconSet> cfaReconSets = new ArrayList<CfaReconSet>();
    private Start start = new Start("start", "", "");
    private Stop stop = new Stop("stop", "", "");
    private Timezone tz = new Timezone("local", "");
    private String groovyScript;
    private SecureGroovyScript script;
    private Secret pswd;

    public BmcCfaBuilder() {
    }

    @DataBoundConstructor
    public BmcCfaBuilder(String server, String port, String user, String jclContent, String chkfreq, String jobCard, String acctno, String thresh, String sortby, String pswd, String prilog, List<CfaLoadLib> cfaLoadLibs, List<CfaSldsLib> cfaSldsLibs, List<CfaDliLib> cfaDliLibs, List<CfaJobname> cfaJobnames, List<CfaReconSet> cfaReconSets, String goodRC, boolean bmcSlds, boolean bmcDb2log, String db2log, String db2bsds, String limit, String skip, String maxlogs, boolean bmcDb2bsds, boolean bmcLimit, boolean bmcSkip, boolean bmcActiveOlds, boolean bmcImsid, boolean bmcDlilog, boolean bmcMaxlogs, boolean bmcJobname, List<CfaImsid> cfaImsids, boolean bmcRecon, boolean bmcTimezone, boolean bmcStartInterval, boolean bmcStopInterval, Start start, Stop stop, Timezone tz, String jobInclude, String jobExclude, String psbInclude, String psbExclude, String maxlogsRc, String maxlogsAbend, boolean bmcJobInc, boolean bmcJobExc, boolean bmcPsbInc, boolean bmcPsbExc, boolean bmcChkfreq, boolean bmcThresh, boolean bmcPrilog, boolean bmcAppcheck, boolean bmcAll, boolean bmcLsec, String chkfreqval, boolean bmcPlanInc, String planInclude, boolean bmcPlanExc, String planExclude, boolean bmcSortby, boolean bmcCsv, boolean bmcFullreport) {
        this.pswd = Secret.fromString((String)pswd);
        this.bmcSlds = bmcSlds;
        this.bmcDb2log = bmcDb2log;
        this.cfaLoadLibs = cfaLoadLibs;
        this.cfaSldsLibs = cfaSldsLibs;
        this.cfaReconSets = cfaReconSets;
        this.cfaDliLibs = cfaDliLibs;
        this.cfaImsids = cfaImsids;
        this.cfaJobnames = cfaJobnames;
        this.bmcJobname = bmcJobname;
        this.bmcRecon = bmcRecon;
        this.bmcImsid = bmcImsid;
        this.server = server;
        this.port = port;
        this.user = user;
        this.jclContent = jclContent;
        this.jobCard = jobCard;
        this.acctno = acctno;
        this.goodRC = goodRC;
        this.db2bsds = db2bsds;
        this.limit = limit;
        this.skip = skip;
        this.bmcSkip = bmcSkip;
        this.maxlogs = maxlogs;
        this.db2log = db2log;
        this.bmcLimit = bmcLimit;
        this.bmcDb2bsds = bmcDb2bsds;
        this.bmcMaxlogs = bmcMaxlogs;
        this.bmcDlilog = bmcDlilog;
        this.bmcActiveOlds = bmcActiveOlds;
        this.prilog = prilog;
        this.bmcPrilog = bmcPrilog;
        this.thresh = thresh;
        this.bmcThresh = bmcThresh;
        this.sortby = sortby;
        this.bmcTimezone = bmcTimezone;
        this.tz = tz;
        this.bmcStartInterval = bmcStartInterval;
        this.bmcStopInterval = bmcStopInterval;
        this.start = start;
        this.stop = stop;
        this.bmcAppcheck = bmcAppcheck;
        this.bmcAll = bmcAll;
        this.jobExclude = jobExclude;
        this.jobInclude = jobInclude;
        this.psbExclude = psbExclude;
        this.psbInclude = psbInclude;
        this.bmcJobExc = bmcJobExc;
        this.bmcJobInc = bmcJobInc;
        this.bmcPsbExc = bmcPsbExc;
        this.bmcPsbInc = bmcPsbInc;
        this.chkfreqval = chkfreqval;
        this.bmcChkfreq = bmcChkfreq;
        this.chkfreq = chkfreq;
        this.bmcLsec = bmcLsec;
        this.bmcPlanInc = bmcPlanInc;
        this.planInclude = planInclude;
        this.bmcPlanExc = bmcPlanExc;
        this.planExclude = planExclude;
        this.bmcSortby = bmcSortby;
        this.bmcCsv = bmcCsv;
        this.bmcFullreport = bmcFullreport;
        this.maxlogsRc = maxlogsRc;
        this.maxlogsAbend = maxlogsAbend;
    }

    public Secret getPswd() {
        return this.pswd;
    }

    public String getMaxlogsAbend() {
        return this.maxlogsAbend;
    }

    public void setMaxlogsAbend(String maxlogsAbend) {
        this.maxlogsAbend = maxlogsAbend;
    }

    public String getMaxlogsRc() {
        return this.maxlogsRc;
    }

    public void setMaxlogsRc(String maxlogsRc) {
        this.maxlogsRc = maxlogsRc;
    }

    public String getChkfreq() {
        return this.chkfreq;
    }

    public void setChkfreq(String chkfreq) {
        this.chkfreq = chkfreq;
    }

    public boolean isBmcActiveOlds() {
        return this.bmcActiveOlds;
    }

    public void setBmcActiveOlds(boolean bmcActiveOlds) {
        this.bmcActiveOlds = bmcActiveOlds;
    }

    public String getPlanInclude() {
        return this.planInclude;
    }

    public void setPlanInclude(String planInclude) {
        this.planInclude = planInclude;
    }

    public boolean isBmcPlanInc() {
        return this.bmcPlanInc;
    }

    public void setBmcPlanInc(boolean bmcPlanInc) {
        this.bmcPlanInc = bmcPlanInc;
    }

    public String getPlanExclude() {
        return this.planExclude;
    }

    public boolean isBmcPlanExc() {
        return this.bmcPlanExc;
    }

    public void setBmcPlanExc(boolean bmcPlanExc) {
        this.bmcPlanExc = bmcPlanExc;
    }

    public void setPlanExclude(String planExclude) {
        this.planExclude = planExclude;
    }

    public boolean isBmcSortby() {
        return this.bmcSortby;
    }

    public void setBmcSortby(boolean bmcSortby) {
        this.bmcSortby = bmcSortby;
    }

    public boolean isBmcCsv() {
        return this.bmcCsv;
    }

    public void setBmcCsv(boolean bmcCsv) {
        this.bmcCsv = bmcCsv;
    }

    public boolean isBmcFullreport() {
        return this.bmcFullreport;
    }

    public void setBmcFullreport(boolean bmcFullreport) {
        this.bmcFullreport = bmcFullreport;
    }

    public boolean isBmcLsec() {
        return this.bmcLsec;
    }

    public void setBmcLsec(boolean bmcLsec) {
        this.bmcLsec = bmcLsec;
    }

    public boolean isBmcAll() {
        return this.bmcAll;
    }

    public void setBmcAll(boolean bmcAll) {
        this.bmcAll = bmcAll;
    }

    public boolean isBmcAppcheck() {
        return this.bmcAppcheck;
    }

    public void setBmcAppcheck(boolean bmcAppcheck) {
        this.bmcAppcheck = bmcAppcheck;
    }

    public String getChkfreqval() {
        return this.chkfreqval;
    }

    public void setChkfreqval(String chkfreqval) {
        this.chkfreqval = chkfreqval;
    }

    public boolean isBmcChkfreq() {
        return this.bmcChkfreq;
    }

    public void setBmcChkfreq(boolean bmcChkfreq) {
        this.bmcChkfreq = bmcChkfreq;
    }

    public String getPsbExclude() {
        return this.psbExclude;
    }

    public void setPsbExclude(String psbExclude) {
        this.psbExclude = psbExclude;
    }

    public boolean isBmcPsbExc() {
        return this.bmcPsbExc;
    }

    public void setBmcPsbExc(boolean bmcPsbExc) {
        this.bmcPsbExc = bmcPsbExc;
    }

    public String getPsbInclude() {
        return this.psbInclude;
    }

    public void setPsbInclude(String psbInclude) {
        this.psbInclude = psbInclude;
    }

    public void setBmcPsbInc(boolean bmcPsbInc) {
        this.bmcPsbInc = bmcPsbInc;
    }

    public boolean isBmcPsbInc() {
        return this.bmcPsbInc;
    }

    public String getJobInclude() {
        return this.jobInclude;
    }

    public void setJobInclude(String jobInclude) {
        this.jobInclude = jobInclude;
    }

    public boolean isBmcJobInc() {
        return this.bmcJobInc;
    }

    public void setBmcJobInc(boolean bmcJobInc) {
        this.bmcJobInc = bmcJobInc;
    }

    public String getJobExclude() {
        return this.jobExclude;
    }

    public void setJobExclude(String jobExclude) {
        this.jobExclude = jobExclude;
    }

    public boolean isBmcJobExc() {
        return this.bmcJobExc;
    }

    public void setBmcJobExc(boolean bmcJobExc) {
        this.bmcJobExc = bmcJobExc;
    }

    public void setBmcStartInterval(boolean bmcStartInterval) {
        this.bmcStartInterval = bmcStartInterval;
    }

    public void setBmcStopInterval(boolean bmcStopInterval) {
        this.bmcStopInterval = bmcStopInterval;
    }

    public boolean isBmcStartInterval() {
        return this.bmcStartInterval;
    }

    public boolean isBmcStopInterval() {
        return this.bmcStopInterval;
    }

    public Start getStart() {
        return this.start;
    }

    public void setStart(Start start) {
        this.start = start;
    }

    public void setStop(Stop stop) {
        this.stop = stop;
    }

    public Stop getStop() {
        return this.stop;
    }

    public void setSortby(String sortby) {
        this.sortby = sortby;
    }

    public String getSortby() {
        return this.sortby;
    }

    public String getPrilog() {
        return this.prilog;
    }

    public void setPrilog(String prilog) {
        this.prilog = prilog;
    }

    public boolean isBmcPrilog() {
        return this.bmcPrilog;
    }

    public void setBmcPrilog(boolean bmcPrilog) {
        this.bmcPrilog = bmcPrilog;
    }

    public void setThresh(String thresh) {
        this.thresh = thresh;
    }

    public String getThresh() {
        return this.thresh;
    }

    public boolean isBmcThresh() {
        return this.bmcThresh;
    }

    public void setBmcThresh(boolean bmcThresh) {
        this.bmcThresh = bmcThresh;
    }

    public void setBmcRecon(boolean bmcRecon) {
        this.bmcRecon = bmcRecon;
    }

    public boolean isBmcRecon() {
        return this.bmcRecon;
    }

    public void setBmcJobname(boolean bmcJobname) {
        this.bmcJobname = bmcJobname;
    }

    public boolean isBmcJobname() {
        return this.bmcJobname;
    }

    public void setBmcDlilog(boolean bmcDlilog) {
        this.bmcDlilog = bmcDlilog;
    }

    public boolean isBmcDlilog() {
        return this.bmcDlilog;
    }

    public void setBmcImsid(boolean bmcImsid) {
        this.bmcImsid = bmcImsid;
    }

    public boolean isBmcImsid() {
        return this.bmcImsid;
    }

    public List<CfaJobname> getCfaJobnames() {
        return this.cfaJobnames;
    }

    public void setCfaJobnames(List<CfaJobname> cfaJobnames) {
        this.cfaJobnames = cfaJobnames;
    }

    public String getMaxlogs() {
        return this.maxlogs;
    }

    public void setMaxlogs(String maxlogs) {
        this.maxlogs = maxlogs;
    }

    public void setBmcMaxlogs(boolean bmcMaxlogs) {
        this.bmcMaxlogs = bmcMaxlogs;
    }

    public boolean isBmcMaxlogs() {
        return this.bmcMaxlogs;
    }

    public void setBmcTimezone(boolean bmcTimezone) {
        this.bmcTimezone = bmcTimezone;
    }

    public boolean isBmcTimezone() {
        return this.bmcTimezone;
    }

    public void setBmcDb2bsds(boolean bmcDb2bsds) {
        this.bmcDb2bsds = bmcDb2bsds;
    }

    public boolean isBmcDb2bsds() {
        return this.bmcDb2bsds;
    }

    public void setBmcLimit(boolean bmcLimit) {
        this.bmcLimit = bmcLimit;
    }

    public boolean isBmcLimit() {
        return this.bmcLimit;
    }

    public Timezone getTz() {
        return this.tz;
    }

    public void setTz(Timezone tz) {
        this.tz = tz;
    }

    public void setBmcSkip(boolean bmcSkip) {
        this.bmcSkip = bmcSkip;
    }

    public boolean isBmcSkip() {
        return this.bmcSkip;
    }

    public String getDb2log() {
        return this.db2log;
    }

    public void setDb2log(String db2log) {
        this.db2log = db2log;
    }

    public String getDb2bsds() {
        return this.db2bsds;
    }

    public void setDb2bsds(String db2bsds) {
        this.db2bsds = db2bsds;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getSkip() {
        return this.skip;
    }

    public void setSkip(String skip) {
        this.skip = skip;
    }

    public List<CfaLoadLib> getCfaLoadLibs() {
        return this.cfaLoadLibs;
    }

    public void setCfaLoadLibs(List<CfaLoadLib> cfaLoadLibs) {
        this.cfaLoadLibs = cfaLoadLibs;
    }

    public List<CfaSldsLib> getCfaSldsLibs() {
        return this.cfaSldsLibs;
    }

    public void setCfaSldsLibs(List<CfaSldsLib> cfaSldsLibs) {
        this.cfaSldsLibs = cfaSldsLibs;
    }

    public List<CfaReconSet> getCfaReconSets() {
        return this.cfaReconSets;
    }

    public void setCfaReconSets(List<CfaReconSet> cfaReconSets) {
        this.cfaReconSets = cfaReconSets;
    }

    public List<CfaDliLib> getCfaDliLibs() {
        return this.cfaDliLibs;
    }

    public void setCfaDliLibs(List<CfaDliLib> cfaDliLibs) {
        this.cfaDliLibs = cfaDliLibs;
    }

    public List<CfaImsid> getCfaImsids() {
        return this.cfaImsids;
    }

    public void setCfaImsids(List<CfaImsid> cfaImsids) {
        this.cfaImsids = cfaImsids;
    }

    public void setBmcDb2log(boolean bmcDb2log) {
        this.bmcDb2log = bmcDb2log;
    }

    public boolean isBmcDb2log() {
        return this.bmcDb2log;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setJclContent(String jclContent) {
        this.jclContent = jclContent;
    }

    public String getJclContent() {
        return this.jclContent;
    }

    public String getJobCard() {
        return this.jobCard;
    }

    public void setJobCard(String jobCard) {
        this.jobCard = jobCard;
    }

    public String getAcctno() {
        return this.acctno;
    }

    public void setAcctno(String acctno) {
        this.acctno = acctno;
    }

    public String getGoodRC() {
        return this.goodRC;
    }

    public void setGoodRC(String goodRC) {
        this.goodRC = goodRC;
    }

    public boolean isBmcSlds() {
        return this.bmcSlds;
    }

    public void setBmcSlds(boolean bmcSlds) {
        this.bmcSlds = bmcSlds;
    }

    private String inspectFailureInLogs(String log) {
        if (log.contains("$HASP395")) {
            if (log.indexOf("RC") != -1) {
                String actRC = log.substring(log.indexOf("RC") + 3, log.indexOf("RC") + 7);
                if (!actRC.equals("0000")) {
                    int goodRc = Integer.parseInt(this.goodRC);
                    int actualRc = Integer.parseInt(actRC);
                    if (actualRc > goodRc) {
                        return "RC=" + actRC;
                    }
                }
            } else if (log.indexOf("ABEND") != -1) {
                return "ABEND=" + log.substring(log.indexOf("ABEND") + 6, log.indexOf("ABEND") + 10);
            }
        } else {
            if (log.contains("IEF453I")) {
                return "JOB FAILED - JCL ERROR";
            }
            if (log.contains("IEFC452I")) {
                return "JOB NOT RUN - JCL ERROR";
            }
            if (log.contains("HASP106")) {
                return "JOB DELETED BY JES2 OR CANCELLED BY OPERATOR BEFORE EXECUTION ";
            }
        }
        return null;
    }

    private String adjustBodyTo72Chars(String body) {
        String processedBody = "";
        block0: while (body.length() > 0) {
            if (body.indexOf("\n") > 73) {
                for (int charsPerLine = 72; charsPerLine > 0; --charsPerLine) {
                    String delimiter = body.substring(charsPerLine, charsPerLine + 1);
                    if (!delimiter.equals(" ") && !delimiter.equals(",")) continue;
                    processedBody = processedBody.concat(body.substring(0, charsPerLine) + "\n");
                    body = body.substring(charsPerLine);
                    continue block0;
                }
                continue;
            }
            if (body.indexOf("\n") == -1) {
                processedBody = processedBody.concat(body);
                body = body.substring(0, 0);
                continue;
            }
            if (body.indexOf("\n") > 73) continue;
            processedBody = processedBody.concat(body.substring(0, body.indexOf("\n") + 1));
            body = body.substring(body.indexOf("\n") + 1);
        }
        return processedBody;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        ResponseObject resp = null;
        String url = "https://" + this.server + ":" + this.port + "/zosmf/restjobs/jobs";
        Properties headers = new Properties();
        String body = null;
        String jc = null;
        String jobname = null;
        String jobid = null;
        Object jobowner = null;
        Object jobstatus = null;
        Object jobtype = null;
        Object jobretcode = null;
        long starttime = 0L;
        long endtime = 0L;
        long waittime = 0L;
        Object jobCompletion = null;
        String compareRC = "0001";
        listener.getLogger().println("user: " + this.user);
        listener.getLogger().println("server: " + this.server);
        listener.getLogger().println("port: " + this.port);
        JCLService zosmf = new JCLService(true);
        zosmf.login(this.server, this.port, this.user, this.pswd.getPlainText(), listener);
        Binding binding = new Binding();
        binding.setVariable("ACCTNO", (Object)this.acctno.toUpperCase());
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            this.groovyScript = "\"\"\"" + this.jobCard + "\"\"\"";
            this.script = new SecureGroovyScript(this.groovyScript, false, null).configuringWithKeyItem();
            jc = this.script.evaluate(cl, binding).toString();
            binding.setVariable("JOB_CARD", (Object)jc.toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Failed to evaluate groovy script."));
        }
        List<CfaLoadLib> LoadList = this.getCfaLoadLibs();
        int indx1 = 0;
        for (CfaLoadLib cfaLoadLib : LoadList) {
            binding.setVariable("CFA_LOAD" + String.valueOf(indx1), (Object)cfaLoadLib.getLib().toUpperCase());
            ++indx1;
        }
        List<CfaSldsLib> SldsList = this.getCfaSldsLibs();
        indx1 = 0;
        for (CfaSldsLib cfaSldsLib : SldsList) {
            binding.setVariable("SLDS_NAME" + String.valueOf(indx1), (Object)cfaSldsLib.getSldsname().toUpperCase());
            binding.setVariable("SLDS_VER" + String.valueOf(indx1), (Object)cfaSldsLib.getSldsver().toUpperCase());
            binding.setVariable("SLDS_UNIT" + String.valueOf(indx1), (Object)cfaSldsLib.getSldsunit().toUpperCase());
            binding.setVariable("SLDS_VOLSER" + String.valueOf(indx1), (Object)cfaSldsLib.getSldsvolser().toUpperCase());
            ++indx1;
        }
        List<CfaReconSet> list = this.getCfaReconSets();
        indx1 = 0;
        for (CfaReconSet cfaReconSet : list) {
            binding.setVariable("RECON1" + String.valueOf(indx1), (Object)cfaReconSet.getRecon1().toUpperCase());
            binding.setVariable("RECON2" + String.valueOf(indx1), (Object)cfaReconSet.getRecon2().toUpperCase());
            binding.setVariable("RECON3" + String.valueOf(indx1), (Object)cfaReconSet.getRecon3().toUpperCase());
            ++indx1;
        }
        List<CfaDliLib> list2 = this.getCfaDliLibs();
        indx1 = 0;
        for (CfaDliLib cfaDliLib : list2) {
            binding.setVariable("DLI_NAME" + String.valueOf(indx1), (Object)cfaDliLib.getDliname().toUpperCase());
            binding.setVariable("DLI_VERSION" + String.valueOf(indx1), (Object)cfaDliLib.getDliver().toUpperCase());
            binding.setVariable("DLI_UNIT" + String.valueOf(indx1), (Object)cfaDliLib.getDliunit().toUpperCase());
            binding.setVariable("DLI_VOLSER" + String.valueOf(indx1), (Object)cfaDliLib.getDlivolser().toUpperCase());
            ++indx1;
        }
        List<CfaImsid> list3 = this.getCfaImsids();
        indx1 = 0;
        for (CfaImsid cfaImsid : list3) {
            binding.setVariable("IMSID" + String.valueOf(indx1), (Object)cfaImsid.getImsid().toUpperCase());
        }
        List<CfaJobname> list4 = this.getCfaJobnames();
        indx1 = 0;
        for (CfaJobname i : list4) {
            binding.setVariable("JOBNAME" + String.valueOf(indx1), (Object)i.getJobname().toUpperCase());
        }
        binding.setVariable("LIMIT", (Object)this.limit.toUpperCase());
        binding.setVariable("SKIP", (Object)this.skip.toUpperCase());
        binding.setVariable("DB2BSDS_DATA_SET", (Object)this.db2bsds.toUpperCase());
        binding.setVariable("DB2LOG_DATA_SET", (Object)this.db2log.toUpperCase());
        binding.setVariable("MAXLOGS", (Object)this.maxlogs);
        binding.setVariable("ABEND", (Object)this.maxlogsAbend);
        binding.setVariable("RC", (Object)this.maxlogsRc);
        binding.setVariable("PRILOG", (Object)this.prilog);
        if (this.tz != null) {
            if (this.tz.getValue().equals("offset")) {
                binding.setVariable("TIMEZONE", (Object)this.tz.getTimezoneoffset());
            } else {
                binding.setVariable("TIMEZONE", (Object)this.tz.getValue().toUpperCase());
            }
        }
        if (this.start != null) {
            if (this.start.getValue().equals("logseq")) {
                binding.setVariable("START", (Object)this.start.getStartlogSeq());
            } else if (this.start.getValue().equals("date")) {
                binding.setVariable("START", (Object)this.start.getStartDate());
            } else {
                binding.setVariable("START", (Object)"FIRST");
            }
        }
        if (this.stop != null) {
            if (this.stop.getValue().equals("logseq")) {
                binding.setVariable("STOP", (Object)this.stop.getStoplogSeq());
            } else if (this.stop.getValue().equals("date")) {
                binding.setVariable("STOP", (Object)this.stop.getStopDate());
            } else {
                binding.setVariable("STOP", (Object)"LAST");
            }
        }
        binding.setVariable("INCLUDE_JOBS", (Object)this.jobInclude.toUpperCase());
        binding.setVariable("EXCLUDE_JOBS", (Object)this.jobExclude.toUpperCase());
        binding.setVariable("EXCLUDE_PSBS", (Object)this.psbExclude.toUpperCase());
        binding.setVariable("INCLUDE_PSBS", (Object)this.psbInclude.toUpperCase());
        binding.setVariable("EXCLUDE_PLANS", (Object)this.planExclude.toUpperCase());
        binding.setVariable("INCLUDE_PLANS", (Object)this.planInclude.toUpperCase());
        binding.setVariable("THRESH", (Object)this.thresh.toUpperCase());
        binding.setVariable("CHKFREQ", (Object)this.chkfreqval.toUpperCase());
        binding.setVariable("SORTBY", (Object)this.sortby.toUpperCase());
        try {
            this.groovyScript = "\"\"\"" + this.jclContent + "\"\"\"";
            this.script = new SecureGroovyScript(this.groovyScript, false, null).configuring(ApprovalContext.create());
            body = this.script.evaluate(cl, binding).toString().replace(",,", "");
            body = body.replace("(,", "(");
            body = body.replace(",)", ")");
            body = this.adjustBodyTo72Chars(body);
            listener.getLogger().println("body:\n" + body);
        }
        catch (Exception exception) {
            exception.printStackTrace(listener.error("Failed to evaluate groovy script."));
        }
        headers.put("Content-Type", "text/plain");
        headers.put("X-IBM-Intrdr-Class", "A");
        headers.put("X-IBM-Intrdr-Recfm", "F");
        headers.put("X-IBM-Intrdr-Lrecl", "80");
        headers.put("X-IBM-Intrdr-Mode", "TEXT");
        resp = zosmf.doRequest(url, "PUT", body, headers, listener);
        listener.getLogger().println("Server returned response code: " + resp.status + " " + resp.jobId);
        if (resp.status < 200 || resp.status > 299) {
            listener.getLogger().println("Error during job submission");
            run.setResult(Result.FAILURE);
            return;
        }
        jobname = resp.jobName;
        jobid = resp.jobId;
        listener.getLogger().println("Job " + jobid + " submitted successfully to " + this.server);
        boolean bl = false;
        int retcount = 1;
        try {
            boolean bl2;
            url = "https://" + this.server + ":" + this.port + "/zosmf/restjobs/jobs/" + jobname + "/" + jobid;
            listener.getLogger().println("Waiting to retrieve job status...");
            headers = new Properties();
            headers.put("Content-Type", "application/json");
            body = "Obtain Job Status";
            while (!bl2) {
                resp = zosmf.doRequest(url, "GET", body, headers, listener);
                if (resp.status == 400) {
                    run.setResult(Result.FAILURE);
                    return;
                }
                if (resp.jobStatus != null) {
                    listener.getLogger().println("Job Output Retrieval Attempt No= " + retcount + " status: " + resp.jobStatus);
                    if (resp.jobStatus.equals("OUTPUT") || resp.jobStatus.equals("PRINT")) {
                        bl2 = true;
                    }
                }
                ++retcount;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            listener.getLogger().println("Job status could not be retrieved");
            listener.getLogger().println(ex);
        }
        try {
            url = "https://" + this.server + ":" + this.port + "/zosmf/restjobs/jobs/" + jobname + "/" + jobid + "/files";
            listener.getLogger().println("HTTPS URL path to list the spool files: " + url);
            headers = new Properties();
            headers.put("Content-Type", "application/json");
            listener.getLogger().println("Waiting to retrieve list of job spool files...");
            body = "List spool files";
            resp = zosmf.doRequest(url, "GET", body, headers, listener);
            listener.getLogger().println("Server returned response code: " + resp.status);
            String message = "Additional diagnostic response messages:\n" + resp.statAndHeaders.toString();
            listener.getLogger().println(message);
        }
        catch (Exception ex) {
            listener.getLogger().println("List of job spool files could not be retrieved");
            ex.printStackTrace();
            listener.getLogger().println(ex);
        }
        StringBuffer append_data = new StringBuffer();
        String ACM_Security_temp = "";
        OutputStreamWriter w = null;
        PrintWriter pw = null;
        String logfilename = "";
        String logfileFolderPath = "";
        try {
            int i;
            int size = resp.idvalarr.size();
            ArrayList<String> idvalarr = new ArrayList<String>();
            ArrayList<String> ddnamevalarr = new ArrayList<String>();
            for (i = 0; i < size; ++i) {
                listener.getLogger().println("ID number of the job spool files= " + resp.idvalarr.get(i));
                idvalarr.add(resp.idvalarr.get(i));
                ddnamevalarr.add(resp.ddnamevalarr.get(i));
            }
            listener.getLogger().println("Before Job Log retrieval...");
            for (i = 0; i < size; ++i) {
                BufferedReader in;
                url = "https://" + this.server + ":" + this.port + "/zosmf/restjobs/jobs/" + jobname + "/" + jobid + "/files/" + (String)idvalarr.get(i) + "/records";
                listener.getLogger().println("HTTPS URL path to retrieve content of spool files: " + url);
                headers = new Properties();
                headers.put("Content-Type", "plain/text");
                body = "Retrieve spool files content";
                resp = zosmf.doRequest(url, "GET", body, headers, listener);
                listener.getLogger().println("Server returned response code for job spool file-" + (String)idvalarr.get(i) + ": " + resp.status);
                String message = "Additional diagnostic response messages:\n" + resp.statAndHeaders.toString();
                listener.getLogger().println(message);
                if (resp.ret_code == 8) {
                    listener.getLogger().println(resp.resp_details);
                    throw new Exception();
                }
                if (resp.status >= 200 && resp.status <= 299) {
                    String inputLine;
                    listener.getLogger().println("Writing the Job Log to workspace");
                    logfilename = (String)ddnamevalarr.get(i);
                    logfileFolderPath = String.valueOf(run.getNumber());
                    File logfileFolder = new File(workspace + File.separator + logfileFolderPath + File.separator + jobid);
                    if (!logfileFolder.exists() && logfileFolder.mkdirs()) {
                        System.out.println("directory " + logfileFolder + " created");
                    }
                    w = new OutputStreamWriter((OutputStream)new FileOutputStream(workspace + File.separator + logfileFolderPath + File.separator + jobid + File.separator + logfilename), "UTF-8");
                    pw = new PrintWriter(w);
                    in = null;
                    in = new BufferedReader(new InputStreamReader(resp.istream, "utf-8"));
                    while ((inputLine = in.readLine()) != null) {
                        pw.println(inputLine);
                        String errormsg = this.inspectFailureInLogs(inputLine);
                        if (errormsg == null) continue;
                        listener.getLogger().println(errormsg);
                        run.setResult(Result.FAILURE);
                        break;
                    }
                } else {
                    if (resp.status == 401) {
                        throw new Exception();
                    }
                    if (resp.status == 503) {
                        throw new Exception();
                    }
                    throw new Exception();
                }
                in.close();
                resp.istream.close();
                pw.close();
                listener.getLogger().println("Spool file #" + i + " was successfully written to workspace");
                listener.getLogger().println("Job Output Path= " + workspace + File.separator + logfilename);
            }
            for (String i2 : ddnamevalarr) {
                if (!i2.contains("CSV")) continue;
                run.addAction((Action)new BmcCfaAction(run, run.getNumber(), workspace.getRemote(), resp, jobid, i2));
            }
        }
        catch (IOException ioex) {
            listener.getLogger().println("Job log STARTS here...");
            listener.getLogger().println();
            listener.getLogger().println(append_data.toString());
            listener.getLogger().println();
            listener.getLogger().println("Retrieved job log ends here...");
            listener.getLogger().println("Job Output Path= " + workspace + File.separator + logfilename);
            listener.getLogger().println(ioex);
            ioex.printStackTrace();
        }
        catch (Exception ex) {
            listener.getLogger().println("Error while retrieving the job log");
            listener.getLogger().println(ex);
            ex.printStackTrace();
            run.setResult(Result.FAILURE);
        }
    }

    @Extension
    @Symbol(value={"BMC DevOps for CFA Plugin"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private int lastEditorId = 0;

        public DescriptorImpl() {
            super(BmcCfaBuilder.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "BMC AMI DevOps for Application Checkpoint Analysis";
        }

        @JavaScriptMethod
        public synchronized String createUniqueId() {
            return String.valueOf(this.lastEditorId++);
        }

        public String getId() {
            return super.getId();
        }

        @POST
        public FormValidation doCheckBmcRecon(@QueryParameter boolean value, @QueryParameter boolean bmcStartInterval, @QueryParameter boolean bmcStopInterval) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value) {
                if (!bmcStartInterval && !bmcStopInterval) {
                    result = FormValidation.warning((String)"INTERVAL START and STOP keywords are required for RECON");
                } else if (!bmcStopInterval) {
                    result = FormValidation.warning((String)"INTERVAL STOP keyword is required for RECON");
                } else if (!bmcStartInterval) {
                    result = FormValidation.warning((String)"INTERVAL START keyword is required for RECON");
                }
            }
            return result;
        }

        @POST
        public FormValidation doCheckBmcImsid(@QueryParameter boolean value, @QueryParameter boolean bmcSlds) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value && bmcSlds) {
                result = FormValidation.warning((String)"IMSID and SLDS are mutually exclusive");
            }
            return result;
        }

        @POST
        public FormValidation doCheckJobname(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value.length() > 8) {
                result = FormValidation.warning((String)"JOBNAME should be 1-8 characters");
            }
            return result;
        }

        @POST
        public FormValidation doCheckBmcSlds(@QueryParameter boolean value, @QueryParameter boolean bmcImsid) {
            FormValidation result = null;
            if (value && bmcImsid) {
                result = FormValidation.warning((String)"SLDS and IMSID are mutually exclusive");
            }
            return result;
        }

        @POST
        public FormValidation doCheckPort(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"z/OSMF Port number is required!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckUser(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"User name is required!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckPswd(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"Password is required!");
            }
            return result;
        }

        @POST
        public FormValidation doCheckLib(@QueryParameter String value) {
            FormValidation result = null;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String tempValue = StringUtils.trimToEmpty((String)value);
            if (tempValue.isEmpty()) {
                result = FormValidation.error((String)"STEPLIB is required!");
            }
            return result;
        }

        public ListBoxModel doFillPrilogItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("SLDS", "SLDS");
            items.add("DLI", "DLI");
            items.add("BOTH", "BOTH");
            return items;
        }

        public ListBoxModel doFillThreshItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("MIN", "MIN");
            items.add("SEC", "SEC");
            return items;
        }

        public ListBoxModel doFillSortbyItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("FREQUENCY", "FREQ");
            items.add("START TIME", "STIME");
            return items;
        }
    }
}

