/*
 * Decompiled with CFR 0.152.
 */
package com.blunderer.easyanimatedvectordrawable;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.util.Log;
import android.widget.ImageView;
import com.blunderer.easyanimatedvectordrawable.AnimatedVectorDrawableConfig;
import com.blunderer.easyanimatedvectordrawable.R;
import com.wnafee.vector.compat.ResourcesCompat;
import java.util.List;
import java.util.Map;

public class EasyAnimatedVectorDrawable {
    private static final String TAG = EasyAnimatedVectorDrawable.class.getSimpleName();
    private static EasyAnimatedVectorDrawable instance;
    private AnimatedVectorDrawableConfig config;

    public static void setConfig(AnimatedVectorDrawableConfig config) {
        EasyAnimatedVectorDrawable.initialize();
        EasyAnimatedVectorDrawable.instance.config = config;
    }

    public static void setImageType(@NonNull ImageView imageView, @NonNull Enum<?> type) {
        EasyAnimatedVectorDrawable.setImageType(imageView, type, 0);
    }

    public static void setImageType(@NonNull ImageView imageView, @NonNull Enum<?> type, @ColorInt int tintColor) {
        EasyAnimatedVectorDrawable.initialize();
        if (imageView.getTag(R.id.eavd_current_type) == null || !(imageView.getTag(R.id.eavd_current_type) instanceof Enum)) {
            EasyAnimatedVectorDrawable.setImageDrawable(imageView, EasyAnimatedVectorDrawable.getDefaultDrawableResId(type), type, tintColor);
            return;
        }
        Enum currentType = (Enum)imageView.getTag(R.id.eavd_current_type);
        if (currentType == type) {
            return;
        }
        try {
            int animatedVectorDrawable = EasyAnimatedVectorDrawable.getAnimatedVectorDrawable(currentType, type);
            if (animatedVectorDrawable != 0) {
                EasyAnimatedVectorDrawable.setImageDrawable(imageView, animatedVectorDrawable, type, tintColor);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        EasyAnimatedVectorDrawable.setImageDrawable(imageView, EasyAnimatedVectorDrawable.getDefaultDrawableResId(type), type, tintColor);
    }

    private static void setImageDrawable(@NonNull ImageView imageView, @DrawableRes int drawableResId, @NonNull Enum<?> type, @ColorInt int tintColor) {
        if (drawableResId == 0) {
            Log.e((String)TAG, (String)("The drawable for the " + type.name() + " type is not valid"));
            return;
        }
        Drawable drawable2 = ResourcesCompat.getDrawable((Context)imageView.getContext(), (int)drawableResId);
        if (Build.VERSION.SDK_INT != 23) {
            drawable2 = drawable2.mutate();
        }
        if (tintColor != 0) {
            drawable2.setColorFilter(tintColor, PorterDuff.Mode.SRC_IN);
        }
        imageView.setImageDrawable(drawable2);
        imageView.setTag(R.id.eavd_current_type, type);
        if (drawable2 instanceof Animatable) {
            Animatable animatable = (Animatable)drawable2;
            if (animatable.isRunning()) {
                animatable.stop();
            }
            animatable.start();
        }
    }

    @DrawableRes
    private static int getDefaultDrawableResId(Enum<?> type) {
        Map<Enum<?>, Integer> defaultDrawables;
        if (EasyAnimatedVectorDrawable.instance.config == null) {
            EasyAnimatedVectorDrawable.instance.config = EasyAnimatedVectorDrawable.generateDefaultConfig();
        }
        if ((defaultDrawables = EasyAnimatedVectorDrawable.instance.config.getDefaultDrawables()).containsKey(type)) {
            return defaultDrawables.get(type);
        }
        return 0;
    }

    @DrawableRes
    private static int getAnimatedVectorDrawable(Enum<?> currentType, Enum<?> newType) {
        List<Object[]> animatedVectorDrawables = EasyAnimatedVectorDrawable.getAnimatedVectorDrawables();
        for (Object[] animatedVectorDrawable : animatedVectorDrawables) {
            if (animatedVectorDrawable[0] != currentType || animatedVectorDrawable[1] != newType) continue;
            return (Integer)animatedVectorDrawable[2];
        }
        throw new IllegalArgumentException("Unknown combination between " + currentType.name() + " and " + newType.name());
    }

    @NonNull
    private static List<Object[]> getAnimatedVectorDrawables() {
        if (EasyAnimatedVectorDrawable.instance.config == null) {
            EasyAnimatedVectorDrawable.instance.config = EasyAnimatedVectorDrawable.generateDefaultConfig();
        }
        return EasyAnimatedVectorDrawable.instance.config.getAnimatedVectorDrawables();
    }

    private static AnimatedVectorDrawableConfig generateDefaultConfig() {
        AnimatedVectorDrawableConfig.DrawableType playDrawableType = new AnimatedVectorDrawableConfig.DrawableType(Type.PLAY, R.drawable.eavd_vd_play);
        AnimatedVectorDrawableConfig.DrawableType pauseDrawableType = new AnimatedVectorDrawableConfig.DrawableType(Type.PAUSE, R.drawable.eavd_vd_pause);
        AnimatedVectorDrawableConfig.DrawableType stopDrawableType = new AnimatedVectorDrawableConfig.DrawableType(Type.STOP, R.drawable.eavd_vd_stop);
        return new AnimatedVectorDrawableConfig.Builder().addAnimatedVectorDrawable(playDrawableType, pauseDrawableType, R.drawable.avd_play_to_pause).addAnimatedVectorDrawable(playDrawableType, stopDrawableType, R.drawable.avd_play_to_stop).addAnimatedVectorDrawable(pauseDrawableType, playDrawableType, R.drawable.avd_pause_to_play).addAnimatedVectorDrawable(pauseDrawableType, stopDrawableType, R.drawable.avd_pause_to_stop).addAnimatedVectorDrawable(stopDrawableType, playDrawableType, R.drawable.avd_stop_to_play).addAnimatedVectorDrawable(stopDrawableType, pauseDrawableType, R.drawable.avd_stop_to_pause).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initialize() {
        if (instance != null) return;
        Class<EasyAnimatedVectorDrawable> clazz = EasyAnimatedVectorDrawable.class;
        synchronized (EasyAnimatedVectorDrawable.class) {
            if (instance != null) return;
            instance = new EasyAnimatedVectorDrawable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static enum Type {
        PLAY,
        PAUSE,
        STOP;

    }
}

