/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;

public abstract class ParameterizedType<T> {
    public final Class rawType;
    public final List<ParameterizedType> typeParameters;

    public ParameterizedType() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("ParameterizedType objects must be instantiated with a type parameter. Ex: new ParameterizedType<MyModel<MyOtherModel>>() { }");
        }
        Type type = ((java.lang.reflect.ParameterizedType)superclass).getActualTypeArguments()[0];
        this.rawType = this.getRawType(type);
        this.typeParameters = new ArrayList<ParameterizedType>();
        this.addTypeParameters(type);
    }

    private ParameterizedType(Type type) {
        this.rawType = this.getRawType(type);
        this.typeParameters = new ArrayList<ParameterizedType>();
        this.addTypeParameters(type);
    }

    private void addTypeParameters(Type type) {
        Type[] actualTypeArguments;
        if (type instanceof java.lang.reflect.ParameterizedType && (actualTypeArguments = ((java.lang.reflect.ParameterizedType)type).getActualTypeArguments()) != null) {
            for (Type typeArgument : actualTypeArguments) {
                this.typeParameters.add(new ConcreteParameterizedType(typeArgument));
            }
        }
    }

    private Class getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof java.lang.reflect.ParameterizedType) {
            return (Class)((java.lang.reflect.ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return this.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(this.getRawType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw new RuntimeException("Invalid type passed: " + type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedType that = (ParameterizedType)o;
        if (!this.rawType.equals(that.rawType)) {
            return false;
        }
        return this.typeParameters.equals(that.typeParameters);
    }

    public int hashCode() {
        int result = this.rawType.hashCode();
        result = 31 * result + this.typeParameters.hashCode();
        return result;
    }

    static class ConcreteParameterizedType<T>
    extends ParameterizedType<T> {
        public ConcreteParameterizedType(Type type) {
            super(type);
        }
    }
}

