/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.internal;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewParent;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;
import androidx.savedstate.ViewTreeSavedStateRegistryOwner;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.ControllerChangeType;
import com.bluelinelabs.conductor.R;
import com.bluelinelabs.conductor.internal.GlobalChangeStartListener;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J(\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!*\u00020\u0004H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/bluelinelabs/conductor/internal/OwnViewTreeLifecycleAndRegistry;", "Landroidx/lifecycle/LifecycleOwner;", "Landroidx/savedstate/SavedStateRegistryOwner;", "controller", "Lcom/bluelinelabs/conductor/Controller;", "(Lcom/bluelinelabs/conductor/Controller;)V", "hasSavedState", "", "lifecycle", "Landroidx/lifecycle/LifecycleRegistry;", "getLifecycle", "()Landroidx/lifecycle/LifecycleRegistry;", "lifecycleRegistry", "savedRegistryState", "Landroid/os/Bundle;", "kotlin.jvm.PlatformType", "savedStateRegistry", "Landroidx/savedstate/SavedStateRegistry;", "getSavedStateRegistry", "()Landroidx/savedstate/SavedStateRegistry;", "savedStateRegistryController", "Landroidx/savedstate/SavedStateRegistryController;", "listenForAncestorChangeStart", "", "pauseOnChangeStart", "targetController", "changeController", "changeHandler", "Lcom/bluelinelabs/conductor/ControllerChangeHandler;", "changeType", "Lcom/bluelinelabs/conductor/ControllerChangeType;", "stopListeningForAncestorChangeStart", "ancestors", "", "", "Companion", "conductor_release"})
public final class OwnViewTreeLifecycleAndRegistry
implements LifecycleOwner,
SavedStateRegistryOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private LifecycleRegistry lifecycleRegistry;
    private SavedStateRegistryController savedStateRegistryController;
    private boolean hasSavedState;
    private Bundle savedRegistryState = Bundle.EMPTY;
    @NotNull
    private static final String KEY_SAVED_STATE = "Registry.savedState";

    private OwnViewTreeLifecycleAndRegistry(final Controller controller) {
        controller.addLifecycleListener(new Controller.LifecycleListener(){

            @Override
            public void preCreateView(@NotNull Controller controller2) {
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                hasSavedState = false;
                lifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
                savedStateRegistryController = SavedStateRegistryController.Companion.create((SavedStateRegistryOwner)this);
                SavedStateRegistryController savedStateRegistryController = savedStateRegistryController;
                if (savedStateRegistryController == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"savedStateRegistryController");
                    savedStateRegistryController = null;
                }
                savedStateRegistryController.performRestore(savedRegistryState);
                LifecycleRegistry lifecycleRegistry = lifecycleRegistry;
                if (lifecycleRegistry == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                    lifecycleRegistry = null;
                }
                lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
            }

            @Override
            public void postCreateView(@NotNull Controller controller2, @NotNull View view) {
                LifecycleRegistry lifecycleRegistry;
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                if (view.getTag(R.id.view_tree_lifecycle_owner) == null && view.getTag(R.id.view_tree_saved_state_registry_owner) == null) {
                    ViewTreeLifecycleOwner.set((View)view, (LifecycleOwner)this);
                    ViewTreeSavedStateRegistryOwner.set((View)view, (SavedStateRegistryOwner)this);
                }
                if ((lifecycleRegistry = lifecycleRegistry) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                    lifecycleRegistry = null;
                }
                lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_START);
            }

            @Override
            public void postAttach(@NotNull Controller controller2, @NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                LifecycleRegistry lifecycleRegistry = lifecycleRegistry;
                if (lifecycleRegistry == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                    lifecycleRegistry = null;
                }
                lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
            }

            @Override
            public void onChangeEnd(@NotNull Controller changeController, @NotNull ControllerChangeHandler changeHandler, @NotNull ControllerChangeType changeType) {
                Intrinsics.checkNotNullParameter((Object)changeController, (String)"changeController");
                Intrinsics.checkNotNullParameter((Object)changeHandler, (String)"changeHandler");
                Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
                if (controller == changeController && changeType.isEnter && changeHandler.getRemovesFromViewOnPush()) {
                    View view = changeController.getView();
                    if ((view != null ? view.getWindowToken() : null) != null) {
                        LifecycleRegistry lifecycleRegistry = lifecycleRegistry;
                        if (lifecycleRegistry == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                            lifecycleRegistry = null;
                        }
                        if (lifecycleRegistry.getCurrentState() == Lifecycle.State.STARTED) {
                            LifecycleRegistry lifecycleRegistry2 = lifecycleRegistry;
                            if (lifecycleRegistry2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                                lifecycleRegistry2 = null;
                            }
                            lifecycleRegistry2.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
                        }
                    }
                }
            }

            @Override
            public void onChangeStart(@NotNull Controller changeController, @NotNull ControllerChangeHandler changeHandler, @NotNull ControllerChangeType changeType) {
                Intrinsics.checkNotNullParameter((Object)changeController, (String)"changeController");
                Intrinsics.checkNotNullParameter((Object)changeHandler, (String)"changeHandler");
                Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
                this.pauseOnChangeStart(controller, changeController, changeHandler, changeType);
                GlobalChangeStartListener.INSTANCE.onChangeStart(changeController, changeHandler, changeType);
            }

            @Override
            public void preDetach(@NotNull Controller controller2, @NotNull View view) {
                LifecycleRegistry lifecycleRegistry;
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                LifecycleRegistry lifecycleRegistry2 = lifecycleRegistry;
                if (lifecycleRegistry2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                    lifecycleRegistry2 = null;
                }
                if (lifecycleRegistry2.getCurrentState() == Lifecycle.State.RESUMED) {
                    LifecycleRegistry lifecycleRegistry3 = lifecycleRegistry;
                    if (lifecycleRegistry3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                        lifecycleRegistry3 = null;
                    }
                    lifecycleRegistry3.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
                }
                if ((lifecycleRegistry = lifecycleRegistry) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                    lifecycleRegistry = null;
                }
                lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
            }

            @Override
            public void onSaveInstanceState(@NotNull Controller controller2, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                outState.putBundle(OwnViewTreeLifecycleAndRegistry.KEY_SAVED_STATE, savedRegistryState);
            }

            @Override
            public void onSaveViewState(@NotNull Controller controller2, @NotNull Bundle outState) {
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
                if (!hasSavedState) {
                    savedRegistryState = new Bundle();
                    SavedStateRegistryController savedStateRegistryController = savedStateRegistryController;
                    if (savedStateRegistryController == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"savedStateRegistryController");
                        savedStateRegistryController = null;
                    }
                    Bundle bundle = savedRegistryState;
                    Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"savedRegistryState");
                    savedStateRegistryController.performSave(bundle);
                }
            }

            @Override
            public void onRestoreInstanceState(@NotNull Controller controller2, @NotNull Bundle savedInstanceState) {
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)savedInstanceState, (String)"savedInstanceState");
                savedRegistryState = savedInstanceState.getBundle(OwnViewTreeLifecycleAndRegistry.KEY_SAVED_STATE);
            }

            @Override
            public void preDestroyView(@NotNull Controller controller2, @NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                if (controller2.isBeingDestroyed() && controller2.getRouter().getBackstackSize() == 0) {
                    View parent;
                    ViewParent viewParent = view.getParent();
                    View view2 = parent = viewParent instanceof View ? (View)viewParent : null;
                    if (view2 != null) {
                        view2.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(parent, this){
                            final /* synthetic */ View $parent;
                            final /* synthetic */ OwnViewTreeLifecycleAndRegistry this$0;
                            {
                                this.$parent = $parent;
                                this.this$0 = $receiver;
                            }

                            public void onViewAttachedToWindow(@NotNull View v) {
                                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                            }

                            public void onViewDetachedFromWindow(@NotNull View v) {
                                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                                this.$parent.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                                LifecycleRegistry lifecycleRegistry = OwnViewTreeLifecycleAndRegistry.access$getLifecycleRegistry$p(this.this$0);
                                if (lifecycleRegistry == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                                    lifecycleRegistry = null;
                                }
                                lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
                            }
                        });
                    }
                } else {
                    LifecycleRegistry lifecycleRegistry = lifecycleRegistry;
                    if (lifecycleRegistry == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                        lifecycleRegistry = null;
                    }
                    lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
                }
            }

            @Override
            public void postContextAvailable(@NotNull Controller controller2, @NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.listenForAncestorChangeStart(controller2);
            }

            @Override
            public void preContextUnavailable(@NotNull Controller controller2, @NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)controller2, (String)"controller");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.stopListeningForAncestorChangeStart(controller2);
            }
        });
    }

    @NotNull
    public LifecycleRegistry getLifecycle() {
        LifecycleRegistry lifecycleRegistry = this.lifecycleRegistry;
        if (lifecycleRegistry == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
            lifecycleRegistry = null;
        }
        return lifecycleRegistry;
    }

    @NotNull
    public SavedStateRegistry getSavedStateRegistry() {
        SavedStateRegistryController savedStateRegistryController = this.savedStateRegistryController;
        if (savedStateRegistryController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"savedStateRegistryController");
            savedStateRegistryController = null;
        }
        return savedStateRegistryController.getSavedStateRegistry();
    }

    private final void listenForAncestorChangeStart(Controller controller) {
        GlobalChangeStartListener.INSTANCE.subscribe(controller, this.ancestors(controller), (Function3<? super Controller, ? super ControllerChangeHandler, ? super ControllerChangeType, Unit>)((Function3)new Function3<Controller, ControllerChangeHandler, ControllerChangeType, Unit>(this){
            final /* synthetic */ OwnViewTreeLifecycleAndRegistry this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull Controller ancestor, @NotNull ControllerChangeHandler changeHandler, @NotNull ControllerChangeType changeType) {
                Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
                Intrinsics.checkNotNullParameter((Object)changeHandler, (String)"changeHandler");
                Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
                if (OwnViewTreeLifecycleAndRegistry.access$getLifecycleRegistry$p(this.this$0) != null) {
                    OwnViewTreeLifecycleAndRegistry.access$pauseOnChangeStart(this.this$0, ancestor, ancestor, changeHandler, changeType);
                }
            }
        }));
    }

    private final void stopListeningForAncestorChangeStart(Controller controller) {
        GlobalChangeStartListener.INSTANCE.unsubscribe(controller);
    }

    private final void pauseOnChangeStart(Controller targetController, Controller changeController, ControllerChangeHandler changeHandler, ControllerChangeType changeType) {
        if (targetController == changeController && !changeType.isEnter && changeHandler.getRemovesFromViewOnPush() && changeController.getView() != null) {
            LifecycleRegistry lifecycleRegistry = this.lifecycleRegistry;
            if (lifecycleRegistry == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                lifecycleRegistry = null;
            }
            if (lifecycleRegistry.getCurrentState() == Lifecycle.State.RESUMED) {
                LifecycleRegistry lifecycleRegistry2 = this.lifecycleRegistry;
                if (lifecycleRegistry2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lifecycleRegistry");
                    lifecycleRegistry2 = null;
                }
                lifecycleRegistry2.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
                this.savedRegistryState = new Bundle();
                SavedStateRegistryController savedStateRegistryController = this.savedStateRegistryController;
                if (savedStateRegistryController == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"savedStateRegistryController");
                    savedStateRegistryController = null;
                }
                Bundle bundle = this.savedRegistryState;
                Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"savedRegistryState");
                savedStateRegistryController.performSave(bundle);
                this.hasSavedState = true;
            }
        }
    }

    private final Collection<String> ancestors(Controller $this$ancestors) {
        List list;
        List $this$ancestors_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Controller ancestor = $this$ancestors.getParentController(); ancestor != null; ancestor = ancestor.getParentController()) {
            String string = ancestor.getInstanceId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ancestor.instanceId");
            $this$ancestors_u24lambda_u240.add(string);
        }
        return CollectionsKt.build((List)list);
    }

    public /* synthetic */ OwnViewTreeLifecycleAndRegistry(Controller controller, DefaultConstructorMarker $constructor_marker) {
        this(controller);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/bluelinelabs/conductor/internal/OwnViewTreeLifecycleAndRegistry$Companion;", "", "()V", "KEY_SAVED_STATE", "", "own", "Lcom/bluelinelabs/conductor/internal/OwnViewTreeLifecycleAndRegistry;", "target", "Lcom/bluelinelabs/conductor/Controller;", "conductor_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OwnViewTreeLifecycleAndRegistry own(@NotNull Controller target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new OwnViewTreeLifecycleAndRegistry(target, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

