/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.bluelinelabs.conductor.Backstack;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.ControllerChangeType;
import com.bluelinelabs.conductor.RouterTransaction;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.NoOpControllerChangeHandler;
import com.bluelinelabs.conductor.internal.ThreadUtils;
import com.bluelinelabs.conductor.internal.TransactionIndexer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class Router {
    private static final String KEY_BACKSTACK = "Router.backstack";
    private static final String KEY_POP_ROOT_CONTROLLER_MODE = "Router.popRootControllerMode";
    final Backstack backstack = new Backstack();
    private final List<ControllerChangeHandler.ControllerChangeListener> changeListeners = new ArrayList<ControllerChangeHandler.ControllerChangeListener>();
    private final List<ControllerChangeHandler.ChangeTransaction> pendingControllerChanges = new ArrayList<ControllerChangeHandler.ChangeTransaction>();
    final List<Controller> destroyingControllers = new ArrayList<Controller>();
    private PopRootControllerMode popRootControllerMode = PopRootControllerMode.POP_ROOT_CONTROLLER_BUT_NOT_VIEW;
    boolean containerFullyAttached = false;
    boolean isActivityStopped = false;
    ViewGroup container;

    @Nullable
    public abstract Activity getActivity();

    public abstract void onActivityResult(int var1, int var2, @Nullable Intent var3);

    public void onRequestPermissionsResult(@NonNull String instanceId, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.requestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @UiThread
    public boolean handleBack() {
        ThreadUtils.ensureMainThread();
        if (!this.backstack.isEmpty()) {
            if (this.backstack.peek().controller().handleBack()) {
                return true;
            }
            if ((this.backstack.getSize() > 1 || this.popRootControllerMode != PopRootControllerMode.NEVER) && this.popCurrentController()) {
                return true;
            }
        }
        return false;
    }

    @UiThread
    public boolean popCurrentController() {
        ThreadUtils.ensureMainThread();
        RouterTransaction transaction = this.backstack.peek();
        if (transaction == null) {
            throw new IllegalStateException("Trying to pop the current controller when there are none on the backstack.");
        }
        return this.popController(transaction.controller());
    }

    @UiThread
    public boolean popController(@NonNull Controller controller) {
        boolean poppingTopController;
        ThreadUtils.ensureMainThread();
        RouterTransaction topTransaction = this.backstack.peek();
        boolean bl = poppingTopController = topTransaction != null && topTransaction.controller() == controller;
        if (poppingTopController) {
            this.trackDestroyingController(this.backstack.pop());
            this.performControllerChange(this.backstack.peek(), topTransaction, false);
        } else {
            boolean needsNextTransactionAttach;
            ControllerChangeHandler topPushHandler;
            RouterTransaction removedTransaction = null;
            RouterTransaction nextTransaction = null;
            Iterator<RouterTransaction> iterator = this.backstack.iterator();
            ControllerChangeHandler controllerChangeHandler = topPushHandler = topTransaction != null ? topTransaction.pushChangeHandler() : null;
            boolean bl2 = topPushHandler != null ? !topPushHandler.removesFromViewOnPush() : (needsNextTransactionAttach = false);
            while (iterator.hasNext()) {
                RouterTransaction transaction = iterator.next();
                if (transaction.controller() == controller) {
                    this.trackDestroyingController(transaction);
                    iterator.remove();
                    removedTransaction = transaction;
                    continue;
                }
                if (removedTransaction == null) continue;
                if (!needsNextTransactionAttach || transaction.controller().isAttached()) break;
                nextTransaction = transaction;
                break;
            }
            if (removedTransaction != null) {
                this.performControllerChange(nextTransaction, removedTransaction, false);
            }
        }
        if (this.popRootControllerMode == PopRootControllerMode.POP_ROOT_CONTROLLER_AND_VIEW) {
            return topTransaction != null;
        }
        return !this.backstack.isEmpty();
    }

    @UiThread
    public void pushController(@NonNull RouterTransaction transaction) {
        ThreadUtils.ensureMainThread();
        RouterTransaction from = this.backstack.peek();
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, from, true);
    }

    @UiThread
    public void replaceTopController(@NonNull RouterTransaction transaction) {
        ThreadUtils.ensureMainThread();
        RouterTransaction topTransaction = this.backstack.peek();
        if (!this.backstack.isEmpty()) {
            this.trackDestroyingController(this.backstack.pop());
        }
        ControllerChangeHandler handler = transaction.pushChangeHandler();
        if (topTransaction != null) {
            boolean newHandlerRemovesViews;
            boolean oldHandlerRemovedViews = topTransaction.pushChangeHandler() == null || topTransaction.pushChangeHandler().removesFromViewOnPush();
            boolean bl = newHandlerRemovesViews = handler == null || handler.removesFromViewOnPush();
            if (!oldHandlerRemovedViews && newHandlerRemovesViews) {
                for (RouterTransaction visibleTransaction : this.getVisibleTransactions(this.backstack.iterator(), true)) {
                    this.performControllerChange(null, visibleTransaction, true, handler);
                }
            }
        }
        this.pushToBackstack(transaction);
        if (handler != null) {
            handler.setForceRemoveViewOnPush(true);
        }
        this.performControllerChange(transaction.pushChangeHandler(handler), topTransaction, true);
    }

    void destroy(boolean popViews) {
        this.popRootControllerMode = PopRootControllerMode.POP_ROOT_CONTROLLER_AND_VIEW;
        final List<RouterTransaction> poppedControllers = this.backstack.popAll();
        this.trackDestroyingControllers(poppedControllers);
        if (popViews && poppedControllers.size() > 0) {
            RouterTransaction topTransaction = poppedControllers.get(0);
            topTransaction.controller().addLifecycleListener(new Controller.LifecycleListener(){

                @Override
                public void onChangeEnd(@NonNull Controller controller, @NonNull ControllerChangeHandler changeHandler, @NonNull ControllerChangeType changeType) {
                    if (changeType == ControllerChangeType.POP_EXIT) {
                        for (int i = poppedControllers.size() - 1; i > 0; --i) {
                            RouterTransaction transaction = (RouterTransaction)poppedControllers.get(i);
                            Router.this.performControllerChange(null, transaction, true, new SimpleSwapChangeHandler());
                        }
                    }
                }
            });
            this.performControllerChange(null, topTransaction, false, topTransaction.popChangeHandler());
        }
    }

    public int getContainerId() {
        return this.container != null ? this.container.getId() : 0;
    }

    @Deprecated
    @NonNull
    public Router setPopsLastView(boolean popsLastView) {
        this.popRootControllerMode = popsLastView ? PopRootControllerMode.POP_ROOT_CONTROLLER_AND_VIEW : PopRootControllerMode.POP_ROOT_CONTROLLER_BUT_NOT_VIEW;
        return this;
    }

    @NonNull
    public Router setPopRootControllerMode(@NonNull PopRootControllerMode popRootControllerMode) {
        this.popRootControllerMode = popRootControllerMode;
        return this;
    }

    @UiThread
    public boolean popToRoot() {
        ThreadUtils.ensureMainThread();
        return this.popToRoot(null);
    }

    @UiThread
    public boolean popToRoot(@Nullable ControllerChangeHandler changeHandler) {
        ThreadUtils.ensureMainThread();
        if (this.backstack.getSize() > 1) {
            this.popToTransaction(this.backstack.root(), changeHandler);
            return true;
        }
        return false;
    }

    @UiThread
    public boolean popToTag(@NonNull String tag) {
        ThreadUtils.ensureMainThread();
        return this.popToTag(tag, null);
    }

    @UiThread
    public boolean popToTag(@NonNull String tag, @Nullable ControllerChangeHandler changeHandler) {
        ThreadUtils.ensureMainThread();
        for (RouterTransaction transaction : this.backstack) {
            if (!tag.equals(transaction.tag())) continue;
            this.popToTransaction(transaction, changeHandler);
            return true;
        }
        return false;
    }

    @UiThread
    public void setRoot(@NonNull RouterTransaction transaction) {
        ThreadUtils.ensureMainThread();
        List<RouterTransaction> transactions = Collections.singletonList(transaction);
        this.setBackstack(transactions, transaction.pushChangeHandler());
    }

    @Nullable
    public Controller getControllerWithInstanceId(@NonNull String instanceId) {
        for (RouterTransaction transaction : this.backstack) {
            Controller controllerWithId = transaction.controller().findController(instanceId);
            if (controllerWithId == null) continue;
            return controllerWithId;
        }
        return null;
    }

    @Nullable
    public Controller getControllerWithTag(@NonNull String tag) {
        for (RouterTransaction transaction : this.backstack) {
            if (!tag.equals(transaction.tag())) continue;
            return transaction.controller();
        }
        return null;
    }

    public int getBackstackSize() {
        return this.backstack.getSize();
    }

    @NonNull
    public List<RouterTransaction> getBackstack() {
        ArrayList<RouterTransaction> list = new ArrayList<RouterTransaction>(this.backstack.getSize());
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            list.add(backstackIterator.next());
        }
        return list;
    }

    @UiThread
    public void setBackstack(@NonNull List<RouterTransaction> newBackstack, @Nullable ControllerChangeHandler changeHandler) {
        ThreadUtils.ensureMainThread();
        List<RouterTransaction> oldTransactions = this.getBackstack();
        List<RouterTransaction> oldVisibleTransactions = this.getVisibleTransactions(this.backstack.iterator(), false);
        this.removeAllExceptVisibleAndUnowned();
        this.ensureOrderedTransactionIndices(newBackstack);
        this.ensureNoDuplicateControllers(newBackstack);
        this.backstack.setBackstack(newBackstack);
        ArrayList<RouterTransaction> transactionsToBeRemoved = new ArrayList<RouterTransaction>();
        for (RouterTransaction oldTransaction : oldTransactions) {
            boolean contains = false;
            for (RouterTransaction newTransaction : newBackstack) {
                if (oldTransaction.controller() != newTransaction.controller()) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            oldTransaction.controller().isBeingDestroyed = true;
            transactionsToBeRemoved.add(oldTransaction);
        }
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            RouterTransaction transaction = backstackIterator.next();
            transaction.onAttachedToRouter();
            this.setRouterOnController(transaction.controller());
        }
        if (newBackstack.size() > 0) {
            boolean visibleTransactionsChanged;
            ArrayList<RouterTransaction> reverseNewBackstack = new ArrayList<RouterTransaction>(newBackstack);
            Collections.reverse(reverseNewBackstack);
            List<RouterTransaction> newVisibleTransactions = this.getVisibleTransactions(reverseNewBackstack.iterator(), false);
            boolean newRootRequiresPush = newVisibleTransactions.size() <= 0 || !oldTransactions.contains(newVisibleTransactions.get(0));
            boolean bl = visibleTransactionsChanged = !this.backstacksAreEqual(newVisibleTransactions, oldVisibleTransactions);
            if (visibleTransactionsChanged) {
                RouterTransaction transaction;
                int i;
                RouterTransaction oldRootTransaction = oldVisibleTransactions.size() > 0 ? oldVisibleTransactions.get(0) : null;
                RouterTransaction newRootTransaction = newVisibleTransactions.get(0);
                if (oldRootTransaction == null || oldRootTransaction.controller() != newRootTransaction.controller()) {
                    if (oldRootTransaction != null) {
                        ControllerChangeHandler.completeHandlerImmediately(oldRootTransaction.controller().getInstanceId());
                    }
                    this.performControllerChange(newRootTransaction, oldRootTransaction, newRootRequiresPush, changeHandler);
                }
                for (i = oldVisibleTransactions.size() - 1; i > 0; --i) {
                    transaction = oldVisibleTransactions.get(i);
                    if (newVisibleTransactions.contains(transaction)) continue;
                    ControllerChangeHandler localHandler = changeHandler != null ? changeHandler.copy() : new SimpleSwapChangeHandler();
                    localHandler.setForceRemoveViewOnPush(true);
                    ControllerChangeHandler.completeHandlerImmediately(transaction.controller().getInstanceId());
                    if (transaction.controller().view == null) continue;
                    this.performControllerChange(null, transaction, newRootRequiresPush, localHandler);
                }
                for (i = 1; i < newVisibleTransactions.size(); ++i) {
                    transaction = newVisibleTransactions.get(i);
                    if (oldVisibleTransactions.contains(transaction)) continue;
                    this.performControllerChange(transaction, newVisibleTransactions.get(i - 1), true, transaction.pushChangeHandler());
                }
            }
        } else {
            for (int i = oldVisibleTransactions.size() - 1; i >= 0; --i) {
                RouterTransaction transaction = oldVisibleTransactions.get(i);
                ControllerChangeHandler localHandler = changeHandler != null ? changeHandler.copy() : new SimpleSwapChangeHandler();
                ControllerChangeHandler.completeHandlerImmediately(transaction.controller().getInstanceId());
                this.performControllerChange(null, transaction, false, localHandler);
            }
        }
        for (RouterTransaction removedTransaction : transactionsToBeRemoved) {
            boolean willBeRemoved = false;
            for (ControllerChangeHandler.ChangeTransaction pendingTransaction : this.pendingControllerChanges) {
                if (pendingTransaction.from != removedTransaction.controller()) continue;
                willBeRemoved = true;
            }
            if (willBeRemoved) continue;
            removedTransaction.controller().destroy();
        }
    }

    public boolean hasRootController() {
        return this.getBackstackSize() > 0;
    }

    public void addChangeListener(@NonNull ControllerChangeHandler.ControllerChangeListener changeListener2) {
        if (!this.changeListeners.contains(changeListener2)) {
            this.changeListeners.add(changeListener2);
        }
    }

    public void removeChangeListener(@NonNull ControllerChangeHandler.ControllerChangeListener changeListener2) {
        this.changeListeners.remove(changeListener2);
    }

    @UiThread
    public void rebindIfNeeded() {
        ThreadUtils.ensureMainThread();
        for (RouterTransaction transaction : this.getTransactions()) {
            if (transaction.controller().getNeedsAttach()) {
                this.performControllerChange(transaction, null, true, (ControllerChangeHandler)new SimpleSwapChangeHandler(false));
                continue;
            }
            this.setRouterOnController(transaction.controller());
        }
    }

    public final void onActivityResult(@NonNull String instanceId, int requestCode, int resultCode, @Nullable Intent data) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.onActivityResult(requestCode, resultCode, data);
        }
    }

    public final void onActivityStarted(@NonNull Activity activity) {
        this.isActivityStopped = false;
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().activityStarted(activity);
            for (Router childRouter : transaction.controller().getChildRouters()) {
                childRouter.onActivityStarted(activity);
            }
        }
    }

    public final void onActivityResumed(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().activityResumed(activity);
            for (Router childRouter : transaction.controller().getChildRouters()) {
                childRouter.onActivityResumed(activity);
            }
        }
    }

    public final void onActivityPaused(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().activityPaused(activity);
            for (Router childRouter : transaction.controller().getChildRouters()) {
                childRouter.onActivityPaused(activity);
            }
        }
    }

    public final void onActivityStopped(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().activityStopped(activity);
            for (Router childRouter : transaction.controller().getChildRouters()) {
                childRouter.onActivityStopped(activity);
            }
        }
        this.isActivityStopped = true;
    }

    public void onActivityDestroyed(@NonNull Activity activity, boolean isConfigurationChange) {
        this.prepareForContainerRemoval();
        this.changeListeners.clear();
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().activityDestroyed(activity);
            for (Router childRouter : transaction.controller().getChildRouters()) {
                childRouter.onActivityDestroyed(activity, isConfigurationChange);
            }
        }
        for (int index = this.destroyingControllers.size() - 1; index >= 0; --index) {
            Controller controller = this.destroyingControllers.get(index);
            controller.activityDestroyed(activity);
            for (Router childRouter : controller.getChildRouters()) {
                childRouter.onActivityDestroyed(activity, isConfigurationChange);
            }
        }
        this.container = null;
    }

    public void prepareForHostDetach() {
        this.pendingControllerChanges.clear();
        for (RouterTransaction transaction : this.backstack) {
            if (ControllerChangeHandler.completeHandlerImmediately(transaction.controller().getInstanceId())) {
                transaction.controller().setNeedsAttach(true);
            }
            transaction.controller().prepareForHostDetach();
        }
    }

    public void saveInstanceState(@NonNull Bundle outState) {
        Bundle backstackState = new Bundle();
        this.backstack.saveInstanceState(backstackState);
        outState.putParcelable(KEY_BACKSTACK, (Parcelable)backstackState);
        outState.putInt(KEY_POP_ROOT_CONTROLLER_MODE, this.popRootControllerMode.ordinal());
    }

    public void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        Bundle backstackBundle = (Bundle)savedInstanceState.getParcelable(KEY_BACKSTACK);
        this.backstack.restoreInstanceState(backstackBundle);
        this.popRootControllerMode = PopRootControllerMode.values()[savedInstanceState.getInt(KEY_POP_ROOT_CONTROLLER_MODE)];
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            this.setRouterOnController(backstackIterator.next().controller());
        }
    }

    public final void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().createOptionsMenu(menu, inflater);
            for (Router childRouter : transaction.controller().getChildRouters()) {
                childRouter.onCreateOptionsMenu(menu, inflater);
            }
        }
    }

    public final void onPrepareOptionsMenu(@NonNull Menu menu) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().prepareOptionsMenu(menu);
            for (Router childRouter : transaction.controller().getChildRouters()) {
                childRouter.onPrepareOptionsMenu(menu);
            }
        }
    }

    public final boolean onOptionsItemSelected(@NonNull MenuItem item) {
        for (RouterTransaction transaction : this.backstack) {
            if (transaction.controller().optionsItemSelected(item)) {
                return true;
            }
            for (Router childRouter : transaction.controller().getChildRouters()) {
                if (!childRouter.onOptionsItemSelected(item)) continue;
                return true;
            }
        }
        return false;
    }

    private void popToTransaction(@NonNull RouterTransaction transaction, @Nullable ControllerChangeHandler changeHandler) {
        if (this.backstack.getSize() > 0) {
            RouterTransaction topTransaction = this.backstack.peek();
            ArrayList<RouterTransaction> updatedBackstack = new ArrayList<RouterTransaction>();
            Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
            while (backstackIterator.hasNext()) {
                RouterTransaction existingTransaction = backstackIterator.next();
                updatedBackstack.add(existingTransaction);
                if (existingTransaction != transaction) continue;
                break;
            }
            if (changeHandler == null) {
                changeHandler = topTransaction.popChangeHandler();
            }
            this.setBackstack(updatedBackstack, changeHandler);
        }
    }

    void watchContainerAttach() {
        this.container.post(new Runnable(){

            @Override
            public void run() {
                Router.this.containerFullyAttached = true;
                Router.this.performPendingControllerChanges();
            }
        });
    }

    void prepareForContainerRemoval() {
        this.containerFullyAttached = false;
        if (this.container != null) {
            this.container.setOnHierarchyChangeListener(null);
        }
    }

    void onContextAvailable() {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().onContextAvailable();
        }
    }

    void onContextUnavailable(@NonNull Context context) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().onContextUnavailable(context);
        }
        for (Controller controller : this.destroyingControllers) {
            controller.onContextUnavailable(context);
        }
    }

    @NonNull
    final List<Controller> getControllers() {
        ArrayList<Controller> controllers = new ArrayList<Controller>(this.backstack.getSize());
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            controllers.add(backstackIterator.next().controller());
        }
        return controllers;
    }

    @NonNull
    final List<RouterTransaction> getTransactions() {
        ArrayList<RouterTransaction> transactions = new ArrayList<RouterTransaction>(this.backstack.getSize());
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            transactions.add(backstackIterator.next());
        }
        return transactions;
    }

    @Nullable
    public final Boolean handleRequestedPermission(@NonNull String permission) {
        for (RouterTransaction transaction : this.backstack) {
            if (!transaction.controller().didRequestPermission(permission)) continue;
            return transaction.controller().shouldShowRequestPermissionRationale(permission);
        }
        return null;
    }

    void performControllerChange(@Nullable RouterTransaction to, @Nullable RouterTransaction from, boolean isPush) {
        if (isPush && to != null) {
            to.onAttachedToRouter();
        }
        ControllerChangeHandler changeHandler = isPush ? to.pushChangeHandler() : (from != null ? from.popChangeHandler() : null);
        this.performControllerChange(to, from, isPush, changeHandler);
    }

    private void performControllerChange(@Nullable RouterTransaction to, @Nullable RouterTransaction from, boolean isPush, @Nullable ControllerChangeHandler changeHandler) {
        Controller toController = to != null ? to.controller() : null;
        Controller fromController = from != null ? from.controller() : null;
        boolean forceDetachDestroy = false;
        if (to != null) {
            to.ensureValidIndex(this.getTransactionIndexer());
            this.setRouterOnController(toController);
        } else if (this.backstack.getSize() == 0 && this.popRootControllerMode == PopRootControllerMode.POP_ROOT_CONTROLLER_BUT_NOT_VIEW) {
            changeHandler = new NoOpControllerChangeHandler();
            forceDetachDestroy = true;
        } else if (!isPush && fromController != null && !fromController.isAttached()) {
            forceDetachDestroy = true;
        }
        this.performControllerChange(toController, fromController, isPush, changeHandler);
        if (forceDetachDestroy && fromController != null) {
            if (fromController.getView() != null) {
                fromController.detach(fromController.getView(), true, false);
            } else {
                fromController.destroy();
            }
        }
    }

    private void performControllerChange(@Nullable Controller to, @Nullable Controller from, boolean isPush, @Nullable ControllerChangeHandler changeHandler) {
        if (isPush && to != null && to.isDestroyed()) {
            throw new IllegalStateException("Trying to push a controller that has already been destroyed. (" + to.getClass().getSimpleName() + ")");
        }
        ControllerChangeHandler.ChangeTransaction transaction = new ControllerChangeHandler.ChangeTransaction(to, from, isPush, this.container, changeHandler, new ArrayList<ControllerChangeHandler.ControllerChangeListener>(this.changeListeners));
        if (this.pendingControllerChanges.size() > 0) {
            if (to != null) {
                to.setNeedsAttach(true);
            }
            this.pendingControllerChanges.add(transaction);
        } else if (from != null && (changeHandler == null || changeHandler.removesFromViewOnPush()) && !this.containerFullyAttached) {
            if (to != null) {
                to.setNeedsAttach(true);
            }
            this.pendingControllerChanges.add(transaction);
            if (this.container != null) {
                this.container.post(new Runnable(){

                    @Override
                    public void run() {
                        Router.this.performPendingControllerChanges();
                    }
                });
            }
        } else {
            ControllerChangeHandler.executeChange(transaction);
        }
    }

    void performPendingControllerChanges() {
        for (int i = 0; i < this.pendingControllerChanges.size(); ++i) {
            ControllerChangeHandler.executeChange(this.pendingControllerChanges.get(i));
        }
        this.pendingControllerChanges.clear();
    }

    protected void pushToBackstack(@NonNull RouterTransaction entry) {
        if (this.backstack.contains(entry.controller())) {
            throw new IllegalStateException("Trying to push a controller that already exists on the backstack.");
        }
        this.backstack.push(entry);
    }

    private void trackDestroyingController(@NonNull RouterTransaction transaction) {
        if (!transaction.controller().isDestroyed()) {
            this.destroyingControllers.add(transaction.controller());
            transaction.controller().addLifecycleListener(new Controller.LifecycleListener(){

                @Override
                public void postDestroy(@NonNull Controller controller) {
                    Router.this.destroyingControllers.remove(controller);
                }
            });
        }
    }

    private void trackDestroyingControllers(@NonNull List<RouterTransaction> transactions) {
        for (RouterTransaction transaction : transactions) {
            this.trackDestroyingController(transaction);
        }
    }

    private void removeAllExceptVisibleAndUnowned() {
        ArrayList<View> views = new ArrayList<View>();
        for (RouterTransaction transaction : this.getVisibleTransactions(this.backstack.iterator(), false)) {
            if (transaction.controller().getView() == null) continue;
            views.add(transaction.controller().getView());
        }
        for (Router router : this.getSiblingRouters()) {
            if (router.container != this.container) continue;
            this.addRouterViewsToList(router, views);
        }
        int childCount = this.container.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = this.container.getChildAt(i);
            if (views.contains(child)) continue;
            this.container.removeView(child);
        }
    }

    private void ensureOrderedTransactionIndices(List<RouterTransaction> backstack) {
        ArrayList<Integer> indices = new ArrayList<Integer>(backstack.size());
        for (RouterTransaction transaction : backstack) {
            transaction.ensureValidIndex(this.getTransactionIndexer());
            indices.add(transaction.getTransactionIndex());
        }
        Collections.sort(indices);
        for (int i = 0; i < backstack.size(); ++i) {
            backstack.get(i).setTransactionIndex((Integer)indices.get(i));
        }
    }

    private void ensureNoDuplicateControllers(List<RouterTransaction> backstack) {
        for (int i = 0; i < backstack.size(); ++i) {
            Controller controller = backstack.get(i).controller();
            for (int j = i + 1; j < backstack.size(); ++j) {
                if (backstack.get(j).controller() != controller) continue;
                throw new IllegalStateException("Trying to push the same controller to the backstack more than once.");
            }
        }
    }

    private void addRouterViewsToList(@NonNull Router router, @NonNull List<View> list) {
        for (Controller controller : router.getControllers()) {
            if (controller.getView() != null) {
                list.add(controller.getView());
            }
            for (Router child : controller.getChildRouters()) {
                this.addRouterViewsToList(child, list);
            }
        }
    }

    private List<RouterTransaction> getVisibleTransactions(@NonNull Iterator<RouterTransaction> backstackIterator, boolean onlyTop) {
        boolean visible = true;
        ArrayList<RouterTransaction> transactions = new ArrayList<RouterTransaction>();
        while (backstackIterator.hasNext()) {
            RouterTransaction transaction = backstackIterator.next();
            if (visible) {
                transactions.add(transaction);
            }
            boolean bl = visible = transaction.pushChangeHandler() != null && !transaction.pushChangeHandler().removesFromViewOnPush();
            if (!onlyTop || visible) continue;
            break;
        }
        Collections.reverse(transactions);
        return transactions;
    }

    private boolean backstacksAreEqual(List<RouterTransaction> lhs, List<RouterTransaction> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (int i = 0; i < rhs.size(); ++i) {
            if (rhs.get(i).controller() == lhs.get(i).controller()) continue;
            return false;
        }
        return true;
    }

    void setRouterOnController(@NonNull Controller controller) {
        controller.setRouter(this);
        controller.onContextAvailable();
    }

    abstract void invalidateOptionsMenu();

    abstract void startActivity(@NonNull Intent var1);

    abstract void startActivityForResult(@NonNull String var1, @NonNull Intent var2, int var3);

    abstract void startActivityForResult(@NonNull String var1, @NonNull Intent var2, int var3, @Nullable Bundle var4);

    abstract void startIntentSenderForResult(@NonNull String var1, @NonNull IntentSender var2, int var3, @Nullable Intent var4, int var5, int var6, int var7, @Nullable Bundle var8) throws IntentSender.SendIntentException;

    abstract void registerForActivityResult(@NonNull String var1, int var2);

    abstract void unregisterForActivityResults(@NonNull String var1);

    abstract void requestPermissions(@NonNull String var1, @NonNull String[] var2, int var3);

    abstract boolean hasHost();

    @NonNull
    abstract List<Router> getSiblingRouters();

    @NonNull
    abstract Router getRootRouter();

    @NonNull
    abstract TransactionIndexer getTransactionIndexer();

    public static enum PopRootControllerMode {
        NEVER,
        POP_ROOT_CONTROLLER_BUT_NOT_VIEW,
        POP_ROOT_CONTROLLER_AND_VIEW;

    }
}

