/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.lint;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTypeReferenceExpression;

public final class ControllerChangeHandlerIssueDetector
extends Detector
implements Detector.UastScanner {
    static final Issue ISSUE = Issue.create((String)"ValidControllerChangeHandler", (String)"ControllerChangeHandler not instantiatable", (String)"Non-abstract ControllerChangeHandler instances must have a default constructor for the system to re-create them in the case of the process being killed.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(ControllerChangeHandlerIssueDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String CLASS_NAME = "com.bluelinelabs.conductor.ControllerChangeHandler";

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UClass.class);
    }

    public UElementHandler createUastHandler(final JavaContext context) {
        final JavaEvaluator evaluator = context.getEvaluator();
        return new UElementHandler(){

            public void visitClass(@NotNull UClass node) {
                String message;
                if (evaluator.isAbstract((PsiModifierListOwner)node)) {
                    return;
                }
                boolean hasSuperType = false;
                for (UTypeReferenceExpression superType : node.getUastSuperTypes()) {
                    if (!ControllerChangeHandlerIssueDetector.CLASS_NAME.equals(superType.asRenderString())) continue;
                    hasSuperType = true;
                    break;
                }
                if (!hasSuperType) {
                    return;
                }
                if (!evaluator.isPublic((PsiModifierListOwner)node)) {
                    message = String.format("This ControllerChangeHandler class should be public (%1$s)", node.getQualifiedName());
                    context.report(ISSUE, node, context.getLocation((UElement)node), message);
                    return;
                }
                if (node.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)node)) {
                    message = String.format("This ControllerChangeHandler inner class should be static (%1$s)", node.getQualifiedName());
                    context.report(ISSUE, node, context.getLocation((UElement)node), message);
                    return;
                }
                boolean hasConstructor = false;
                boolean hasDefaultConstructor = false;
                for (UMethod method : node.getMethods()) {
                    if (!method.isConstructor()) continue;
                    hasConstructor = true;
                    if (!evaluator.isPublic((PsiModifierListOwner)method) || method.getUastParameters().size() != 0) continue;
                    hasDefaultConstructor = true;
                    break;
                }
                if (hasConstructor && !hasDefaultConstructor) {
                    String message2 = String.format("This ControllerChangeHandler needs to have a public default constructor (`%1$s`)", node.getQualifiedName());
                    context.report(ISSUE, node, context.getLocation((UElement)node), message2);
                }
            }
        };
    }
}

