/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.internal;

import android.view.View;
import android.view.ViewGroup;

public class ViewAttachHandler
implements View.OnAttachStateChangeListener {
    private boolean rootAttached = false;
    boolean childrenAttached = false;
    private boolean activityStopped = false;
    private ReportedState reportedState = ReportedState.VIEW_DETACHED;
    private ViewAttachListener attachListener;
    View.OnAttachStateChangeListener childOnAttachStateChangeListener;

    public ViewAttachHandler(ViewAttachListener attachListener) {
        this.attachListener = attachListener;
    }

    public void onViewAttachedToWindow(View v) {
        if (this.rootAttached) {
            return;
        }
        this.rootAttached = true;
        this.listenForDeepestChildAttach(v, () -> {
            this.childrenAttached = true;
            this.reportAttached();
        });
    }

    public void onViewDetachedFromWindow(View v) {
        this.rootAttached = false;
        if (this.childrenAttached) {
            this.childrenAttached = false;
            this.reportDetached(false);
        }
    }

    public void listenForAttach(View view) {
        view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }

    public void unregisterAttachListener(View view) {
        view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        if (this.childOnAttachStateChangeListener != null && view instanceof ViewGroup) {
            this.findDeepestChild((ViewGroup)view).removeOnAttachStateChangeListener(this.childOnAttachStateChangeListener);
        }
    }

    public void onActivityStarted() {
        this.activityStopped = false;
        this.reportAttached();
    }

    public void onActivityStopped() {
        this.activityStopped = true;
        this.reportDetached(true);
    }

    void reportAttached() {
        if (this.rootAttached && this.childrenAttached && !this.activityStopped && this.reportedState != ReportedState.ATTACHED) {
            this.reportedState = ReportedState.ATTACHED;
            this.attachListener.onAttached();
        }
    }

    private void reportDetached(boolean detachedForActivity) {
        boolean wasDetachedForActivity = this.reportedState == ReportedState.ACTIVITY_STOPPED;
        this.reportedState = detachedForActivity ? ReportedState.ACTIVITY_STOPPED : ReportedState.VIEW_DETACHED;
        if (wasDetachedForActivity && !detachedForActivity) {
            this.attachListener.onViewDetachAfterStop();
        } else {
            this.attachListener.onDetached(detachedForActivity);
        }
    }

    private void listenForDeepestChildAttach(View view, final ChildAttachListener attachListener) {
        if (!(view instanceof ViewGroup)) {
            attachListener.onAttached();
            return;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        if (viewGroup.getChildCount() == 0) {
            attachListener.onAttached();
            return;
        }
        this.childOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){
            boolean attached = false;

            public void onViewAttachedToWindow(View v) {
                if (!this.attached) {
                    this.attached = true;
                    attachListener.onAttached();
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewAttachHandler.this.childOnAttachStateChangeListener = null;
                }
            }

            public void onViewDetachedFromWindow(View v) {
            }
        };
        this.findDeepestChild(viewGroup).addOnAttachStateChangeListener(this.childOnAttachStateChangeListener);
    }

    private View findDeepestChild(ViewGroup viewGroup) {
        if (viewGroup.getChildCount() == 0) {
            return viewGroup;
        }
        View lastChild = viewGroup.getChildAt(viewGroup.getChildCount() - 1);
        if (lastChild instanceof ViewGroup) {
            return this.findDeepestChild((ViewGroup)lastChild);
        }
        return lastChild;
    }

    private static interface ChildAttachListener {
        public void onAttached();
    }

    public static interface ViewAttachListener {
        public void onAttached();

        public void onDetached(boolean var1);

        public void onViewDetachAfterStop();
    }

    private static enum ReportedState {
        VIEW_DETACHED,
        ACTIVITY_STOPPED,
        ATTACHED;

    }
}

