/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.internal;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.List;
import java.util.Map;

@TargetApi(value=21)
public class LegacyTransitionUtils {
    public static void findNamedViews(@NonNull Map<String, View> namedViews, View view) {
        if (view.getVisibility() == 0) {
            String transitionName = view.getTransitionName();
            if (transitionName != null) {
                namedViews.put(transitionName, view);
            }
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                int childCount = viewGroup.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    View child = viewGroup.getChildAt(i);
                    LegacyTransitionUtils.findNamedViews(namedViews, child);
                }
            }
        }
    }

    @Nullable
    public static View findNamedView(@NonNull View view, @NonNull String transitionName) {
        if (transitionName.equals(view.getTransitionName())) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View viewWithTransitionName = LegacyTransitionUtils.findNamedView(viewGroup.getChildAt(i), transitionName);
                if (viewWithTransitionName == null) continue;
                return viewWithTransitionName;
            }
        }
        return null;
    }

    public static void setEpicenter(@NonNull Transition transition, @Nullable View view) {
        if (view != null) {
            final Rect epicenter = new Rect();
            LegacyTransitionUtils.getBoundsOnScreen(view, epicenter);
            transition.setEpicenterCallback(new Transition.EpicenterCallback(){

                public Rect onGetEpicenter(Transition transition) {
                    return epicenter;
                }
            });
        }
    }

    public static void getBoundsOnScreen(@NonNull View view, @NonNull Rect epicenter) {
        int[] loc = new int[2];
        view.getLocationOnScreen(loc);
        epicenter.set(loc[0], loc[1], loc[0] + view.getWidth(), loc[1] + view.getHeight());
    }

    public static void setTargets(@NonNull Transition transition, @NonNull View nonExistentView, @NonNull List<View> sharedViews) {
        List views = transition.getTargets();
        views.clear();
        int count = sharedViews.size();
        for (int i = 0; i < count; ++i) {
            View view = sharedViews.get(i);
            LegacyTransitionUtils.bfsAddViewChildren(views, view);
        }
        views.add(nonExistentView);
        sharedViews.add(nonExistentView);
        LegacyTransitionUtils.addTargets(transition, sharedViews);
    }

    public static void addTargets(@Nullable Transition transition, @NonNull List<View> views) {
        block4: {
            List targets;
            block3: {
                if (transition == null) {
                    return;
                }
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    LegacyTransitionUtils.addTargets(child, views);
                }
                break block4;
            }
            if (LegacyTransitionUtils.hasSimpleTarget(transition) || !LegacyTransitionUtils.isNullOrEmpty(targets = transition.getTargets())) break block4;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition.addTarget(views.get(i));
            }
        }
    }

    public static void replaceTargets(@NonNull Transition transition, @NonNull List<View> oldTargets, @Nullable List<View> newTargets) {
        block4: {
            int i;
            List targets;
            block3: {
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i2 = 0; i2 < numTransitions; ++i2) {
                    Transition child = set.getTransitionAt(i2);
                    LegacyTransitionUtils.replaceTargets(child, oldTargets, newTargets);
                }
                break block4;
            }
            if (LegacyTransitionUtils.hasSimpleTarget(transition) || (targets = transition.getTargets()) == null || targets.size() != oldTargets.size() || !targets.containsAll(oldTargets)) break block4;
            int targetCount = newTargets == null ? 0 : newTargets.size();
            for (i = 0; i < targetCount; ++i) {
                transition.addTarget(newTargets.get(i));
            }
            for (i = oldTargets.size() - 1; i >= 0; --i) {
                transition.removeTarget(oldTargets.get(i));
            }
        }
    }

    private static void bfsAddViewChildren(@NonNull List<View> views, @NonNull View startView) {
        int startIndex = views.size();
        if (LegacyTransitionUtils.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        views.add(startView);
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (LegacyTransitionUtils.containedBeforeIndex(views, child, startIndex)) continue;
                views.add(child);
            }
        }
    }

    private static boolean containedBeforeIndex(@NonNull List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSimpleTarget(@NonNull Transition transition) {
        return !LegacyTransitionUtils.isNullOrEmpty(transition.getTargetIds()) || !LegacyTransitionUtils.isNullOrEmpty(transition.getTargetNames()) || !LegacyTransitionUtils.isNullOrEmpty(transition.getTargetTypes());
    }

    private static boolean isNullOrEmpty(@Nullable List list) {
        return list == null || list.isEmpty();
    }

    @NonNull
    public static TransitionSet mergeTransitions(int ordering, Transition ... transitions) {
        TransitionSet transitionSet = new TransitionSet();
        for (Transition transition : transitions) {
            if (transition == null) continue;
            transitionSet.addTransition(transition);
        }
        transitionSet.setOrdering(ordering);
        return transitionSet;
    }
}

