/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.changehandler;

import android.annotation.TargetApi;
import android.app.SharedElementCallback;
import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.util.ArrayMap;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.changehandler.TransitionChangeHandler;
import com.bluelinelabs.conductor.internal.TransitionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@TargetApi(value=21)
public abstract class SharedElementTransitionChangeHandler
extends TransitionChangeHandler {
    @NonNull
    final ArrayMap<String, String> sharedElementNames = new ArrayMap();
    @NonNull
    final List<String> waitForTransitionNames = new ArrayList<String>();
    @NonNull
    final List<ViewParentPair> removedViews = new ArrayList<ViewParentPair>();
    @Nullable
    Transition exitTransition;
    @Nullable
    Transition enterTransition;
    @Nullable
    Transition sharedElementTransition;
    @Nullable
    private SharedElementCallback exitTransitionCallback;
    @Nullable
    private SharedElementCallback enterTransitionCallback;

    @Override
    @NonNull
    protected final Transition getTransition(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, boolean isPush) {
        this.exitTransition = this.getExitTransition(container, from, to, isPush);
        this.enterTransition = this.getEnterTransition(container, from, to, isPush);
        this.sharedElementTransition = this.getSharedElementTransition(container, from, to, isPush);
        this.exitTransitionCallback = this.getExitTransitionCallback(container, from, to, isPush);
        this.enterTransitionCallback = this.getEnterTransitionCallback(container, from, to, isPush);
        if (this.enterTransition == null && this.sharedElementTransition == null && this.exitTransition == null) {
            throw new IllegalStateException("SharedElementTransitionChangeHandler must have at least one transaction.");
        }
        return this.mergeTransitions(isPush);
    }

    @Override
    public void prepareForTransition(final @NonNull ViewGroup container, final @Nullable View from, final @Nullable View to, final @NonNull Transition transition, final boolean isPush, final @NonNull TransitionChangeHandler.OnTransitionPreparedListener onTransitionPreparedListener) {
        TransitionChangeHandler.OnTransitionPreparedListener listener = new TransitionChangeHandler.OnTransitionPreparedListener(){

            @Override
            public void onPrepared() {
                SharedElementTransitionChangeHandler.this.configureTransition(container, from, to, transition, isPush);
                onTransitionPreparedListener.onPrepared();
            }
        };
        this.configureSharedElements(container, from, to, isPush);
        if (to != null && to.getParent() == null && this.waitForTransitionNames.size() > 0) {
            this.waitOnAllTransitionNames(to, listener);
            container.addView(to);
        } else {
            listener.onPrepared();
        }
    }

    @Override
    public final void executePropertyChanges(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, @Nullable Transition transition, boolean isPush) {
        if (to != null && this.removedViews.size() > 0) {
            to.setVisibility(0);
            for (ViewParentPair removedView : this.removedViews) {
                removedView.parent.addView(removedView.view);
            }
            this.removedViews.clear();
        }
        super.executePropertyChanges(container, from, to, transition, isPush);
    }

    @Override
    public void onAbortPush(@NonNull ControllerChangeHandler newHandler, @Nullable Controller newTop) {
        super.onAbortPush(newHandler, newTop);
        this.removedViews.clear();
    }

    void configureTransition(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, @NonNull Transition transition, boolean isPush) {
        List<View> exitingViews;
        View nonExistentView = new View(container.getContext());
        ArrayList<View> fromSharedElements = new ArrayList<View>();
        ArrayList<View> toSharedElements = new ArrayList<View>();
        this.configureSharedElements(container, nonExistentView, to, from, isPush, fromSharedElements, toSharedElements);
        List<View> list = exitingViews = this.exitTransition != null ? this.configureEnteringExitingViews(this.exitTransition, from, fromSharedElements, nonExistentView) : null;
        if (exitingViews == null || exitingViews.isEmpty()) {
            this.exitTransition = null;
        }
        if (this.enterTransition != null) {
            this.enterTransition.addTarget(nonExistentView);
        }
        ArrayList<View> enteringViews = new ArrayList<View>();
        this.scheduleRemoveTargets(transition, this.enterTransition, enteringViews, this.exitTransition, exitingViews, this.sharedElementTransition, toSharedElements);
        this.scheduleTargetChange(container, to, nonExistentView, toSharedElements, enteringViews, exitingViews);
        this.setNameOverrides((View)container, toSharedElements);
        this.scheduleNameReset(container, toSharedElements);
    }

    private void waitOnAllTransitionNames(final @NonNull View to, final @NonNull TransitionChangeHandler.OnTransitionPreparedListener onTransitionPreparedListener) {
        ViewTreeObserver.OnPreDrawListener onPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){
            boolean addedSubviewListeners;

            public boolean onPreDraw() {
                ArrayList<View> foundViews = new ArrayList<View>();
                boolean allViewsFound = true;
                for (String transitionName : SharedElementTransitionChangeHandler.this.waitForTransitionNames) {
                    View namedView = TransitionUtils.findNamedView(to, transitionName);
                    if (namedView != null) {
                        foundViews.add(TransitionUtils.findNamedView(to, transitionName));
                        continue;
                    }
                    allViewsFound = false;
                    break;
                }
                if (allViewsFound && !this.addedSubviewListeners) {
                    this.addedSubviewListeners = true;
                    SharedElementTransitionChangeHandler.this.waitOnChildTransitionNames(to, foundViews, this, onTransitionPreparedListener);
                }
                return false;
            }
        };
        to.getViewTreeObserver().addOnPreDrawListener(onPreDrawListener);
    }

    void waitOnChildTransitionNames(final @NonNull View to, @NonNull List<View> foundViews, final @NonNull ViewTreeObserver.OnPreDrawListener parentPreDrawListener, final @NonNull TransitionChangeHandler.OnTransitionPreparedListener onTransitionPreparedListener) {
        for (final View view : foundViews) {
            OneShotPreDrawListener.add(true, view, new Runnable(){

                @Override
                public void run() {
                    SharedElementTransitionChangeHandler.this.waitForTransitionNames.remove(view.getTransitionName());
                    SharedElementTransitionChangeHandler.this.removedViews.add(new ViewParentPair(view, (ViewGroup)view.getParent()));
                    ((ViewGroup)view.getParent()).removeView(view);
                    if (SharedElementTransitionChangeHandler.this.waitForTransitionNames.size() == 0) {
                        to.getViewTreeObserver().removeOnPreDrawListener(parentPreDrawListener);
                        to.setVisibility(4);
                        onTransitionPreparedListener.onPrepared();
                    }
                }
            });
        }
    }

    private void scheduleTargetChange(@NonNull ViewGroup container, final @Nullable View to, final @NonNull View nonExistentView, final @NonNull List<View> toSharedElements, final @NonNull List<View> enteringViews, final @Nullable List<View> exitingViews) {
        OneShotPreDrawListener.add(true, (View)container, new Runnable(){

            @Override
            public void run() {
                if (SharedElementTransitionChangeHandler.this.enterTransition != null) {
                    SharedElementTransitionChangeHandler.this.enterTransition.removeTarget(nonExistentView);
                    List<View> views = SharedElementTransitionChangeHandler.this.configureEnteringExitingViews(SharedElementTransitionChangeHandler.this.enterTransition, to, toSharedElements, nonExistentView);
                    enteringViews.addAll(views);
                }
                if (exitingViews != null) {
                    if (SharedElementTransitionChangeHandler.this.exitTransition != null) {
                        ArrayList<View> tempExiting = new ArrayList<View>();
                        tempExiting.add(nonExistentView);
                        TransitionUtils.replaceTargets(SharedElementTransitionChangeHandler.this.exitTransition, exitingViews, tempExiting);
                    }
                    exitingViews.clear();
                    exitingViews.add(nonExistentView);
                }
            }
        });
    }

    private Transition mergeTransitions(boolean isPush) {
        boolean overlap;
        boolean bl = overlap = this.enterTransition == null || this.exitTransition == null || this.allowTransitionOverlap(isPush);
        if (overlap) {
            return TransitionUtils.mergeTransitions(0, this.exitTransition, this.enterTransition, this.sharedElementTransition);
        }
        TransitionSet staggered = TransitionUtils.mergeTransitions(1, this.exitTransition, this.enterTransition);
        return TransitionUtils.mergeTransitions(0, new Transition[]{staggered, this.sharedElementTransition});
    }

    @NonNull
    List<View> configureEnteringExitingViews(@NonNull Transition transition, @Nullable View view, @NonNull List<View> sharedElements, @NonNull View nonExistentView) {
        ArrayList<View> viewList = new ArrayList<View>();
        if (view != null) {
            this.captureTransitioningViews(viewList, view);
        }
        viewList.removeAll(sharedElements);
        if (!viewList.isEmpty()) {
            viewList.add(nonExistentView);
            TransitionUtils.addTargets(transition, viewList);
        }
        return viewList;
    }

    private void configureSharedElements(@NonNull ViewGroup container, final @NonNull View nonExistentView, final @Nullable View to, @Nullable View from, final boolean isPush, final @NonNull List<View> fromSharedElements, final @NonNull List<View> toSharedElements) {
        Rect toEpicenter;
        if (to == null || from == null) {
            return;
        }
        ArrayMap<String, View> capturedFromSharedElements = this.captureFromSharedElements(from);
        if (this.sharedElementNames.isEmpty()) {
            this.sharedElementTransition = null;
        } else if (capturedFromSharedElements != null) {
            fromSharedElements.addAll(capturedFromSharedElements.values());
        }
        if (this.enterTransition == null && this.exitTransition == null && this.sharedElementTransition == null) {
            return;
        }
        this.callSharedElementStartEnd(capturedFromSharedElements, true);
        if (this.sharedElementTransition != null) {
            toEpicenter = new Rect();
            TransitionUtils.setTargets(this.sharedElementTransition, nonExistentView, fromSharedElements);
            this.setFromEpicenter(capturedFromSharedElements);
            if (this.enterTransition != null) {
                this.enterTransition.setEpicenterCallback(new Transition.EpicenterCallback(){

                    public Rect onGetEpicenter(Transition transition) {
                        if (toEpicenter.isEmpty()) {
                            return null;
                        }
                        return toEpicenter;
                    }
                });
            }
        } else {
            toEpicenter = null;
        }
        OneShotPreDrawListener.add(true, (View)container, new Runnable(){

            @Override
            public void run() {
                ArrayMap<String, View> capturedToSharedElements = SharedElementTransitionChangeHandler.this.captureToSharedElements(to, isPush);
                if (capturedToSharedElements != null) {
                    toSharedElements.addAll(capturedToSharedElements.values());
                    toSharedElements.add(nonExistentView);
                }
                SharedElementTransitionChangeHandler.this.callSharedElementStartEnd(capturedToSharedElements, false);
                if (SharedElementTransitionChangeHandler.this.sharedElementTransition != null) {
                    SharedElementTransitionChangeHandler.this.sharedElementTransition.getTargets().clear();
                    SharedElementTransitionChangeHandler.this.sharedElementTransition.getTargets().addAll(toSharedElements);
                    TransitionUtils.replaceTargets(SharedElementTransitionChangeHandler.this.sharedElementTransition, fromSharedElements, toSharedElements);
                    View toEpicenterView = SharedElementTransitionChangeHandler.this.getToEpicenterView(capturedToSharedElements);
                    if (toEpicenterView != null && toEpicenter != null) {
                        TransitionUtils.getBoundsOnScreen(toEpicenterView, toEpicenter);
                    }
                }
            }
        });
    }

    @Nullable
    View getToEpicenterView(@Nullable ArrayMap<String, View> toSharedElements) {
        if (this.enterTransition != null && this.sharedElementNames.size() > 0 && toSharedElements != null) {
            return (View)toSharedElements.get(this.sharedElementNames.valueAt(0));
        }
        return null;
    }

    private void setFromEpicenter(@Nullable ArrayMap<String, View> fromSharedElements) {
        if (this.sharedElementNames.size() > 0 && fromSharedElements != null) {
            View fromEpicenterView = (View)fromSharedElements.get(this.sharedElementNames.keyAt(0));
            if (this.sharedElementTransition != null) {
                TransitionUtils.setEpicenter(this.sharedElementTransition, fromEpicenterView);
            }
            if (this.exitTransition != null) {
                TransitionUtils.setEpicenter(this.exitTransition, fromEpicenterView);
            }
        }
    }

    @Nullable
    ArrayMap<String, View> captureToSharedElements(@Nullable View to, boolean isPush) {
        if (this.sharedElementNames.isEmpty() || this.sharedElementTransition == null || to == null) {
            this.sharedElementNames.clear();
            return null;
        }
        ArrayMap toSharedElements = new ArrayMap();
        TransitionUtils.findNamedViews((Map<String, View>)toSharedElements, to);
        for (ViewParentPair removedView : this.removedViews) {
            toSharedElements.put((Object)removedView.view.getTransitionName(), (Object)removedView.view);
        }
        ArrayList names = new ArrayList(this.sharedElementNames.values());
        toSharedElements.retainAll(names);
        if (this.enterTransitionCallback != null) {
            this.enterTransitionCallback.onMapSharedElements(names, (Map)toSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String key;
                String name = (String)names.get(i);
                View view = (View)toSharedElements.get((Object)name);
                if (view == null) {
                    key = this.findKeyForValue(this.sharedElementNames, name);
                    if (key == null) continue;
                    this.sharedElementNames.remove((Object)key);
                    continue;
                }
                if (name.equals(view.getTransitionName()) || (key = this.findKeyForValue(this.sharedElementNames, name)) == null) continue;
                this.sharedElementNames.put((Object)key, (Object)view.getTransitionName());
            }
        } else {
            for (int i = this.sharedElementNames.size() - 1; i >= 0; --i) {
                String targetName = (String)this.sharedElementNames.valueAt(i);
                if (toSharedElements.containsKey((Object)targetName)) continue;
                this.sharedElementNames.removeAt(i);
            }
        }
        return toSharedElements;
    }

    @Nullable
    String findKeyForValue(@NonNull ArrayMap<String, String> map, @NonNull String value) {
        int numElements = map.size();
        for (int i = 0; i < numElements; ++i) {
            if (!value.equals(map.valueAt(i))) continue;
            return (String)map.keyAt(i);
        }
        return null;
    }

    @Nullable
    private ArrayMap<String, View> captureFromSharedElements(@NonNull View from) {
        if (this.sharedElementNames.isEmpty() || this.sharedElementTransition == null) {
            this.sharedElementNames.clear();
            return null;
        }
        ArrayMap fromSharedElements = new ArrayMap();
        TransitionUtils.findNamedViews((Map<String, View>)fromSharedElements, from);
        ArrayList names = new ArrayList(this.sharedElementNames.keySet());
        fromSharedElements.retainAll(names);
        if (this.exitTransitionCallback != null) {
            this.exitTransitionCallback.onMapSharedElements(names, (Map)fromSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String name = (String)names.get(i);
                View view = (View)fromSharedElements.get((Object)name);
                if (view == null) {
                    this.sharedElementNames.remove((Object)name);
                    continue;
                }
                if (name.equals(view.getTransitionName())) continue;
                String targetValue = (String)this.sharedElementNames.remove((Object)name);
                this.sharedElementNames.put((Object)view.getTransitionName(), (Object)targetValue);
            }
        } else {
            this.sharedElementNames.retainAll((Collection)fromSharedElements.keySet());
        }
        return fromSharedElements;
    }

    void callSharedElementStartEnd(@Nullable ArrayMap<String, View> sharedElements, boolean isStart) {
        if (this.enterTransitionCallback != null) {
            int count = sharedElements == null ? 0 : sharedElements.size();
            ArrayList<Object> views = new ArrayList<Object>(count);
            ArrayList<Object> names = new ArrayList<Object>(count);
            for (int i = 0; i < count; ++i) {
                names.add(sharedElements.keyAt(i));
                views.add(sharedElements.valueAt(i));
            }
            if (isStart) {
                this.enterTransitionCallback.onSharedElementStart(names, views, null);
            } else {
                this.enterTransitionCallback.onSharedElementEnd(names, views, null);
            }
        }
    }

    private void captureTransitioningViews(@NonNull List<View> transitioningViews, @NonNull View view) {
        if (view.getVisibility() == 0) {
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                if (viewGroup.isTransitionGroup()) {
                    transitioningViews.add((View)viewGroup);
                } else {
                    int count = viewGroup.getChildCount();
                    for (int i = 0; i < count; ++i) {
                        View child = viewGroup.getChildAt(i);
                        this.captureTransitioningViews(transitioningViews, child);
                    }
                }
            } else {
                transitioningViews.add(view);
            }
        }
    }

    private void scheduleRemoveTargets(@NonNull Transition overallTransition, final @Nullable Transition enterTransition, final @Nullable List<View> enteringViews, final @Nullable Transition exitTransition, final @Nullable List<View> exitingViews, final @Nullable Transition sharedElementTransition, final @Nullable List<View> toSharedElements) {
        overallTransition.addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition) {
                if (enterTransition != null && enteringViews != null) {
                    TransitionUtils.replaceTargets(enterTransition, enteringViews, null);
                }
                if (exitTransition != null && exitingViews != null) {
                    TransitionUtils.replaceTargets(exitTransition, exitingViews, null);
                }
                if (sharedElementTransition != null && toSharedElements != null) {
                    TransitionUtils.replaceTargets(sharedElementTransition, toSharedElements, null);
                }
            }

            public void onTransitionEnd(Transition transition) {
            }

            public void onTransitionCancel(Transition transition) {
            }

            public void onTransitionPause(Transition transition) {
            }

            public void onTransitionResume(Transition transition) {
            }
        });
    }

    private void setNameOverrides(@NonNull View container, final @NonNull List<View> toSharedElements) {
        OneShotPreDrawListener.add(true, container, new Runnable(){

            @Override
            public void run() {
                int numSharedElements = toSharedElements.size();
                for (int i = 0; i < numSharedElements; ++i) {
                    View view = (View)toSharedElements.get(i);
                    String name = view.getTransitionName();
                    if (name == null) continue;
                    String inName = SharedElementTransitionChangeHandler.this.findKeyForValue(SharedElementTransitionChangeHandler.this.sharedElementNames, name);
                    view.setTransitionName(inName);
                }
            }
        });
    }

    private void scheduleNameReset(@NonNull ViewGroup container, final @NonNull List<View> toSharedElements) {
        OneShotPreDrawListener.add(true, (View)container, new Runnable(){

            @Override
            public void run() {
                int numSharedElements = toSharedElements.size();
                for (int i = 0; i < numSharedElements; ++i) {
                    View view = (View)toSharedElements.get(i);
                    String name = view.getTransitionName();
                    String inName = (String)SharedElementTransitionChangeHandler.this.sharedElementNames.get((Object)name);
                    view.setTransitionName(inName);
                }
            }
        });
    }

    public abstract void configureSharedElements(@NonNull ViewGroup var1, @Nullable View var2, @Nullable View var3, boolean var4);

    @Nullable
    public abstract Transition getExitTransition(@NonNull ViewGroup var1, @Nullable View var2, @Nullable View var3, boolean var4);

    @Nullable
    public abstract Transition getSharedElementTransition(@NonNull ViewGroup var1, @Nullable View var2, @Nullable View var3, boolean var4);

    @Nullable
    public abstract Transition getEnterTransition(@NonNull ViewGroup var1, @Nullable View var2, @Nullable View var3, boolean var4);

    @Nullable
    public SharedElementCallback getExitTransitionCallback(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, boolean isPush) {
        return null;
    }

    @Nullable
    public SharedElementCallback getEnterTransitionCallback(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, boolean isPush) {
        return null;
    }

    public boolean allowTransitionOverlap(boolean isPush) {
        return true;
    }

    protected final void addSharedElement(@NonNull String name) {
        this.sharedElementNames.put((Object)name, (Object)name);
    }

    protected final void addSharedElement(@NonNull String fromName, @NonNull String toName) {
        this.sharedElementNames.put((Object)fromName, (Object)toName);
    }

    protected final void addSharedElement(@NonNull View sharedElement, @NonNull String toName) {
        String transitionName = sharedElement.getTransitionName();
        if (transitionName == null) {
            throw new IllegalArgumentException("Unique transitionNames are required for all sharedElements");
        }
        this.sharedElementNames.put((Object)transitionName, (Object)toName);
    }

    protected final void waitOnSharedElementNamed(@NonNull String name) {
        if (!this.sharedElementNames.values().contains(name)) {
            throw new IllegalStateException("Can't wait on a shared element that hasn't been registered using addSharedElement");
        }
        this.waitForTransitionNames.add(name);
    }

    private static class ViewParentPair {
        @NonNull
        final View view;
        @NonNull
        final ViewGroup parent;

        ViewParentPair(@NonNull View view, ViewGroup parent) {
            this.view = view;
            this.parent = parent;
        }
    }

    private static class OneShotPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        private final View view;
        private ViewTreeObserver viewTreeObserver;
        private final Runnable runnable;
        private final boolean preDrawReturnValue;

        private OneShotPreDrawListener(boolean preDrawReturnValue, @NonNull View view, @NonNull Runnable runnable) {
            this.preDrawReturnValue = preDrawReturnValue;
            this.view = view;
            this.viewTreeObserver = view.getViewTreeObserver();
            this.runnable = runnable;
        }

        @NonNull
        public static OneShotPreDrawListener add(boolean preDrawReturnValue, @NonNull View view, @NonNull Runnable runnable) {
            OneShotPreDrawListener listener = new OneShotPreDrawListener(preDrawReturnValue, view, runnable);
            view.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)listener);
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener);
            return listener;
        }

        public boolean onPreDraw() {
            this.removeListener();
            this.runnable.run();
            return this.preDrawReturnValue;
        }

        private void removeListener() {
            if (this.viewTreeObserver.isAlive()) {
                this.viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            } else {
                this.view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            }
            this.view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onViewAttachedToWindow(View v) {
            this.viewTreeObserver = v.getViewTreeObserver();
        }

        public void onViewDetachedFromWindow(View v) {
            this.removeListener();
        }
    }
}

