/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.RouterTransaction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

class Backstack
implements Iterable<RouterTransaction> {
    private static final String KEY_ENTRIES = "Backstack.entries";
    private final Deque<RouterTransaction> backstack = new ArrayDeque<RouterTransaction>();

    Backstack() {
    }

    boolean isEmpty() {
        return this.backstack.isEmpty();
    }

    int size() {
        return this.backstack.size();
    }

    @Nullable
    RouterTransaction root() {
        return this.backstack.size() > 0 ? this.backstack.getLast() : null;
    }

    @Override
    @NonNull
    public Iterator<RouterTransaction> iterator() {
        return this.backstack.iterator();
    }

    @NonNull
    Iterator<RouterTransaction> reverseIterator() {
        return this.backstack.descendingIterator();
    }

    @NonNull
    List<RouterTransaction> popTo(@NonNull RouterTransaction transaction) {
        ArrayList<RouterTransaction> popped = new ArrayList<RouterTransaction>();
        if (this.backstack.contains(transaction)) {
            while (this.backstack.peek() != transaction) {
                RouterTransaction poppedTransaction = this.pop();
                popped.add(poppedTransaction);
            }
        } else {
            throw new RuntimeException("Tried to pop to a transaction that was not on the back stack");
        }
        return popped;
    }

    @NonNull
    RouterTransaction pop() {
        RouterTransaction popped = this.backstack.pop();
        popped.controller.destroy();
        return popped;
    }

    @Nullable
    RouterTransaction peek() {
        return this.backstack.peek();
    }

    void push(@NonNull RouterTransaction transaction) {
        this.backstack.push(transaction);
    }

    @NonNull
    List<RouterTransaction> popAll() {
        ArrayList<RouterTransaction> list = new ArrayList<RouterTransaction>();
        while (!this.isEmpty()) {
            list.add(this.pop());
        }
        return list;
    }

    void setBackstack(@NonNull List<RouterTransaction> backstack) {
        this.backstack.clear();
        for (RouterTransaction transaction : backstack) {
            this.backstack.push(transaction);
        }
    }

    boolean contains(@NonNull Controller controller) {
        for (RouterTransaction transaction : this.backstack) {
            if (controller != transaction.controller) continue;
            return true;
        }
        return false;
    }

    void saveInstanceState(@NonNull Bundle outState) {
        ArrayList<Bundle> entryBundles = new ArrayList<Bundle>(this.backstack.size());
        for (RouterTransaction entry : this.backstack) {
            entryBundles.add(entry.saveInstanceState());
        }
        outState.putParcelableArrayList(KEY_ENTRIES, entryBundles);
    }

    void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        ArrayList entryBundles = savedInstanceState.getParcelableArrayList(KEY_ENTRIES);
        if (entryBundles != null) {
            Collections.reverse(entryBundles);
            for (Bundle transactionBundle : entryBundles) {
                this.backstack.push(new RouterTransaction(transactionBundle));
            }
        }
    }
}

