/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.internal.TransactionIndexer;

public class RouterTransaction {
    private static int INVALID_INDEX = -1;
    private static final String KEY_VIEW_CONTROLLER_BUNDLE = "RouterTransaction.controller.bundle";
    private static final String KEY_PUSH_TRANSITION = "RouterTransaction.pushControllerChangeHandler";
    private static final String KEY_POP_TRANSITION = "RouterTransaction.popControllerChangeHandler";
    private static final String KEY_TAG = "RouterTransaction.tag";
    private static final String KEY_INDEX = "RouterTransaction.transactionIndex";
    private static final String KEY_ATTACHED_TO_ROUTER = "RouterTransaction.attachedToRouter";
    @NonNull
    final Controller controller;
    private String tag;
    private ControllerChangeHandler pushControllerChangeHandler;
    private ControllerChangeHandler popControllerChangeHandler;
    private boolean attachedToRouter;
    int transactionIndex = INVALID_INDEX;

    @NonNull
    public static RouterTransaction with(@NonNull Controller controller) {
        return new RouterTransaction(controller);
    }

    private RouterTransaction(@NonNull Controller controller) {
        this.controller = controller;
    }

    RouterTransaction(@NonNull Bundle bundle) {
        this.controller = Controller.newInstance(bundle.getBundle(KEY_VIEW_CONTROLLER_BUNDLE));
        this.pushControllerChangeHandler = ControllerChangeHandler.fromBundle(bundle.getBundle(KEY_PUSH_TRANSITION));
        this.popControllerChangeHandler = ControllerChangeHandler.fromBundle(bundle.getBundle(KEY_POP_TRANSITION));
        this.tag = bundle.getString(KEY_TAG);
        this.transactionIndex = bundle.getInt(KEY_INDEX);
        this.attachedToRouter = bundle.getBoolean(KEY_ATTACHED_TO_ROUTER);
    }

    void onAttachedToRouter() {
        this.attachedToRouter = true;
    }

    @NonNull
    public Controller controller() {
        return this.controller;
    }

    @Nullable
    public String tag() {
        return this.tag;
    }

    @NonNull
    public RouterTransaction tag(@Nullable String tag) {
        if (!this.attachedToRouter) {
            this.tag = tag;
            return this;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + "s can not be modified after being added to a Router.");
    }

    @Nullable
    public ControllerChangeHandler pushChangeHandler() {
        ControllerChangeHandler handler = this.controller.getOverriddenPushHandler();
        if (handler == null) {
            handler = this.pushControllerChangeHandler;
        }
        return handler;
    }

    @NonNull
    public RouterTransaction pushChangeHandler(@Nullable ControllerChangeHandler handler) {
        if (!this.attachedToRouter) {
            this.pushControllerChangeHandler = handler;
            return this;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + "s can not be modified after being added to a Router.");
    }

    @Nullable
    public ControllerChangeHandler popChangeHandler() {
        ControllerChangeHandler handler = this.controller.getOverriddenPopHandler();
        if (handler == null) {
            handler = this.popControllerChangeHandler;
        }
        return handler;
    }

    @NonNull
    public RouterTransaction popChangeHandler(@Nullable ControllerChangeHandler handler) {
        if (!this.attachedToRouter) {
            this.popControllerChangeHandler = handler;
            return this;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + "s can not be modified after being added to a Router.");
    }

    void ensureValidIndex(@NonNull TransactionIndexer indexer) {
        if (this.transactionIndex == INVALID_INDEX) {
            this.transactionIndex = indexer.nextIndex();
        }
    }

    @NonNull
    public Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putBundle(KEY_VIEW_CONTROLLER_BUNDLE, this.controller.saveInstanceState());
        if (this.pushControllerChangeHandler != null) {
            bundle.putBundle(KEY_PUSH_TRANSITION, this.pushControllerChangeHandler.toBundle());
        }
        if (this.popControllerChangeHandler != null) {
            bundle.putBundle(KEY_POP_TRANSITION, this.popControllerChangeHandler.toBundle());
        }
        bundle.putString(KEY_TAG, this.tag);
        bundle.putInt(KEY_INDEX, this.transactionIndex);
        bundle.putBoolean(KEY_ATTACHED_TO_ROUTER, this.attachedToRouter);
        return bundle;
    }
}

