/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.changehandler;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;

public abstract class AnimatorChangeHandler
extends ControllerChangeHandler {
    private static final String KEY_DURATION = "AnimatorChangeHandler.duration";
    private static final String KEY_REMOVES_FROM_ON_PUSH = "AnimatorChangeHandler.removesFromViewOnPush";
    public static final long DEFAULT_ANIMATION_DURATION = -1L;
    private long animationDuration;
    private boolean removesFromViewOnPush;
    private boolean canceled;
    private boolean needsImmediateCompletion;
    private boolean completed;
    private Animator animator;
    private OnAnimationReadyOrAbortedListener onAnimationReadyOrAbortedListener;

    public AnimatorChangeHandler() {
        this(-1L, true);
    }

    public AnimatorChangeHandler(boolean removesFromViewOnPush) {
        this(-1L, removesFromViewOnPush);
    }

    public AnimatorChangeHandler(long duration) {
        this(duration, true);
    }

    public AnimatorChangeHandler(long duration, boolean removesFromViewOnPush) {
        this.animationDuration = duration;
        this.removesFromViewOnPush = removesFromViewOnPush;
    }

    @Override
    public void saveToBundle(@NonNull Bundle bundle) {
        super.saveToBundle(bundle);
        bundle.putLong(KEY_DURATION, this.animationDuration);
        bundle.putBoolean(KEY_REMOVES_FROM_ON_PUSH, this.removesFromViewOnPush);
    }

    @Override
    public void restoreFromBundle(@NonNull Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.animationDuration = bundle.getLong(KEY_DURATION);
        this.removesFromViewOnPush = bundle.getBoolean(KEY_REMOVES_FROM_ON_PUSH);
    }

    @Override
    public void onAbortPush(@NonNull ControllerChangeHandler newHandler, @Nullable Controller newTop) {
        super.onAbortPush(newHandler, newTop);
        this.canceled = true;
        if (this.animator != null) {
            this.animator.cancel();
        } else if (this.onAnimationReadyOrAbortedListener != null) {
            this.onAnimationReadyOrAbortedListener.onReadyOrAborted();
        }
    }

    @Override
    public void completeImmediately() {
        super.completeImmediately();
        this.needsImmediateCompletion = true;
        if (this.animator != null) {
            this.animator.end();
        } else if (this.onAnimationReadyOrAbortedListener != null) {
            this.onAnimationReadyOrAbortedListener.onReadyOrAborted();
        }
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    @Override
    public boolean removesFromViewOnPush() {
        return this.removesFromViewOnPush;
    }

    @NonNull
    protected abstract Animator getAnimator(@NonNull ViewGroup var1, @Nullable View var2, @Nullable View var3, boolean var4, boolean var5);

    protected abstract void resetFromView(@NonNull View var1);

    @Override
    public final void performChange(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, boolean isPush, @NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
        boolean addingToView;
        boolean readyToAnimate = true;
        boolean bl = addingToView = to != null && to.getParent() == null;
        if (addingToView) {
            if (isPush || from == null) {
                container.addView(to);
            } else if (to.getParent() == null) {
                container.addView(to, container.indexOfChild(from));
            }
            if (to.getWidth() <= 0 && to.getHeight() <= 0) {
                readyToAnimate = false;
                this.onAnimationReadyOrAbortedListener = new OnAnimationReadyOrAbortedListener(container, from, to, isPush, true, changeListener);
                to.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.onAnimationReadyOrAbortedListener);
            }
        }
        if (readyToAnimate) {
            this.performAnimation(container, from, to, isPush, addingToView, changeListener);
        }
    }

    private void complete(@NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener, @Nullable Animator.AnimatorListener animatorListener) {
        if (!this.completed) {
            this.completed = true;
            changeListener.onChangeCompleted();
        }
        if (this.animator != null) {
            if (animatorListener != null) {
                this.animator.removeListener(animatorListener);
            }
            this.animator.cancel();
            this.animator = null;
        }
        this.onAnimationReadyOrAbortedListener = null;
    }

    private void performAnimation(final @NonNull ViewGroup container, final @Nullable View from, @Nullable View to, final boolean isPush, boolean toAddedToContainer, final @NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
        if (this.canceled) {
            this.complete(changeListener, null);
            return;
        }
        if (this.needsImmediateCompletion) {
            if (from != null && (!isPush || this.removesFromViewOnPush)) {
                container.removeView(from);
            }
            this.complete(changeListener, null);
            if (isPush && from != null) {
                this.resetFromView(from);
            }
            return;
        }
        this.animator = this.getAnimator(container, from, to, isPush, toAddedToContainer);
        if (this.animationDuration > 0L) {
            this.animator.setDuration(this.animationDuration);
        }
        this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                if (from != null && (!isPush || AnimatorChangeHandler.this.removesFromViewOnPush) && AnimatorChangeHandler.this.needsImmediateCompletion) {
                    container.removeView(from);
                }
                AnimatorChangeHandler.this.complete(changeListener, (Animator.AnimatorListener)this);
            }

            public void onAnimationEnd(Animator animation) {
                if (!AnimatorChangeHandler.this.canceled && AnimatorChangeHandler.this.animator != null) {
                    if (from != null && (!isPush || AnimatorChangeHandler.this.removesFromViewOnPush)) {
                        container.removeView(from);
                    }
                    AnimatorChangeHandler.this.complete(changeListener, (Animator.AnimatorListener)this);
                    if (isPush && from != null) {
                        AnimatorChangeHandler.this.resetFromView(from);
                    }
                }
            }
        });
        this.animator.start();
    }

    private class OnAnimationReadyOrAbortedListener
    implements ViewTreeObserver.OnPreDrawListener {
        @NonNull
        final ViewGroup container;
        @Nullable
        final View from;
        @Nullable
        final View to;
        final boolean isPush;
        final boolean addingToView;
        @NonNull
        final ControllerChangeHandler.ControllerChangeCompletedListener changeListener;
        private boolean hasRun;

        OnAnimationReadyOrAbortedListener(@Nullable ViewGroup container, @Nullable View from, View to, boolean isPush, @NonNull boolean addingToView, ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
            this.container = container;
            this.from = from;
            this.to = to;
            this.isPush = isPush;
            this.addingToView = addingToView;
            this.changeListener = changeListener;
        }

        public boolean onPreDraw() {
            this.onReadyOrAborted();
            return true;
        }

        void onReadyOrAborted() {
            if (!this.hasRun) {
                ViewTreeObserver observer;
                this.hasRun = true;
                if (this.to != null && (observer = this.to.getViewTreeObserver()).isAlive()) {
                    observer.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                }
                AnimatorChangeHandler.this.performAnimation(this.container, this.from, this.to, this.isPush, this.addingToView, this.changeListener);
            }
        }
    }
}

