/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.internal.LifecycleHandler;
import com.bluelinelabs.conductor.internal.TransactionIndexer;
import java.util.List;

public class ActivityHostedRouter
extends Router {
    private LifecycleHandler lifecycleHandler;
    private final TransactionIndexer transactionIndexer = new TransactionIndexer();

    public final void setHost(@NonNull LifecycleHandler lifecycleHandler, @NonNull ViewGroup container) {
        if (this.lifecycleHandler != lifecycleHandler || this.container != container) {
            if (this.container != null && this.container instanceof ControllerChangeHandler.ControllerChangeListener) {
                this.removeChangeListener((ControllerChangeHandler.ControllerChangeListener)this.container);
            }
            if (container instanceof ControllerChangeHandler.ControllerChangeListener) {
                this.addChangeListener((ControllerChangeHandler.ControllerChangeListener)container);
            }
            this.lifecycleHandler = lifecycleHandler;
            this.container = container;
            this.watchContainerAttach();
        }
    }

    @Override
    public void saveInstanceState(@NonNull Bundle outState) {
        super.saveInstanceState(outState);
        this.transactionIndexer.saveInstanceState(outState);
    }

    @Override
    public void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.restoreInstanceState(savedInstanceState);
        this.transactionIndexer.restoreInstanceState(savedInstanceState);
    }

    @Override
    @Nullable
    public Activity getActivity() {
        return this.lifecycleHandler != null ? this.lifecycleHandler.getLifecycleActivity() : null;
    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {
        super.onActivityDestroyed(activity);
        this.lifecycleHandler = null;
    }

    @Override
    public final void invalidateOptionsMenu() {
        if (this.lifecycleHandler != null && this.lifecycleHandler.getFragmentManager() != null) {
            this.lifecycleHandler.getFragmentManager().invalidateOptionsMenu();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        this.lifecycleHandler.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    void startActivity(@NonNull Intent intent) {
        this.lifecycleHandler.startActivity(intent);
    }

    @Override
    void startActivityForResult(@NonNull String instanceId, @NonNull Intent intent, int requestCode) {
        this.lifecycleHandler.startActivityForResult(instanceId, intent, requestCode);
    }

    @Override
    void startActivityForResult(@NonNull String instanceId, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        this.lifecycleHandler.startActivityForResult(instanceId, intent, requestCode, options);
    }

    @Override
    void startIntentSenderForResult(@NonNull String instanceId, @NonNull IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        this.lifecycleHandler.startIntentSenderForResult(instanceId, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
    }

    @Override
    void registerForActivityResult(@NonNull String instanceId, int requestCode) {
        this.lifecycleHandler.registerForActivityResult(instanceId, requestCode);
    }

    @Override
    void unregisterForActivityResults(@NonNull String instanceId) {
        this.lifecycleHandler.unregisterForActivityResults(instanceId);
    }

    @Override
    void requestPermissions(@NonNull String instanceId, @NonNull String[] permissions, int requestCode) {
        this.lifecycleHandler.requestPermissions(instanceId, permissions, requestCode);
    }

    @Override
    boolean hasHost() {
        return this.lifecycleHandler != null;
    }

    @Override
    @NonNull
    List<Router> getSiblingRouters() {
        return this.lifecycleHandler.getRouters();
    }

    @Override
    @NonNull
    Router getRootRouter() {
        return this;
    }

    @Override
    @Nullable
    TransactionIndexer getTransactionIndexer() {
        return this.transactionIndexer;
    }

    @Override
    public void onContextAvailable() {
        super.onContextAvailable();
    }
}

