/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeType;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.ClassUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ControllerChangeHandler {
    private static final String KEY_CLASS_NAME = "ControllerChangeHandler.className";
    private static final String KEY_SAVED_STATE = "ControllerChangeHandler.savedState";
    private static final Map<String, ControllerChangeHandler> inProgressPushHandlers = new HashMap<String, ControllerChangeHandler>();
    private boolean forceRemoveViewOnPush;
    private boolean hasBeenUsed;

    public abstract void performChange(@NonNull ViewGroup var1, @Nullable View var2, @Nullable View var3, boolean var4, @NonNull ControllerChangeCompletedListener var5);

    public ControllerChangeHandler() {
        this.ensureDefaultConstructor();
    }

    public void saveToBundle(@NonNull Bundle bundle) {
    }

    public void restoreFromBundle(@NonNull Bundle bundle) {
    }

    public void onAbortPush(@NonNull ControllerChangeHandler newHandler, @Nullable Controller newTop) {
    }

    public void completeImmediately() {
    }

    @NonNull
    public ControllerChangeHandler copy() {
        return ControllerChangeHandler.fromBundle(this.toBundle());
    }

    public boolean isReusable() {
        return false;
    }

    @NonNull
    final Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_CLASS_NAME, this.getClass().getName());
        Bundle savedState = new Bundle();
        this.saveToBundle(savedState);
        bundle.putBundle(KEY_SAVED_STATE, savedState);
        return bundle;
    }

    private void ensureDefaultConstructor() {
        try {
            this.getClass().getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getClass() + " does not have a default constructor.");
        }
    }

    @Nullable
    public static ControllerChangeHandler fromBundle(@Nullable Bundle bundle) {
        if (bundle != null) {
            String className = bundle.getString(KEY_CLASS_NAME);
            ControllerChangeHandler changeHandler = (ControllerChangeHandler)ClassUtils.newInstance(className);
            changeHandler.restoreFromBundle(bundle.getBundle(KEY_SAVED_STATE));
            return changeHandler;
        }
        return null;
    }

    static boolean completePushImmediately(@NonNull String controllerInstanceId) {
        ControllerChangeHandler changeHandler = inProgressPushHandlers.get(controllerInstanceId);
        if (changeHandler != null) {
            changeHandler.completeImmediately();
            inProgressPushHandlers.remove(controllerInstanceId);
            return true;
        }
        return false;
    }

    static void abortPush(@NonNull Controller toAbort, @Nullable Controller newController, @NonNull ControllerChangeHandler newChangeHandler) {
        ControllerChangeHandler handlerForPush = inProgressPushHandlers.get(toAbort.getInstanceId());
        if (handlerForPush != null) {
            handlerForPush.onAbortPush(newChangeHandler, newController);
            inProgressPushHandlers.remove(toAbort.getInstanceId());
        }
    }

    static void executeChange(final @Nullable Controller to, final @Nullable Controller from, final boolean isPush, final @Nullable ViewGroup container, @Nullable ControllerChangeHandler inHandler, final @NonNull List<ControllerChangeListener> listeners) {
        if (isPush && to != null && to.isDestroyed()) {
            throw new IllegalStateException("Trying to push a controller that has already been destroyed. (" + to.getClass().getSimpleName() + ")");
        }
        if (container != null) {
            View fromView;
            View toView;
            ControllerChangeType fromChangeType;
            final ControllerChangeHandler handler = inHandler == null ? new SimpleSwapChangeHandler() : (inHandler.hasBeenUsed && !inHandler.isReusable() ? inHandler.copy() : inHandler);
            handler.hasBeenUsed = true;
            if (isPush && to != null) {
                inProgressPushHandlers.put(to.getInstanceId(), handler);
                if (from != null) {
                    ControllerChangeHandler.completePushImmediately(from.getInstanceId());
                }
            } else if (!isPush && from != null) {
                ControllerChangeHandler.abortPush(from, to, handler);
            }
            for (ControllerChangeListener listener : listeners) {
                listener.onChangeStarted(to, from, isPush, container, handler);
            }
            final ControllerChangeType toChangeType = isPush ? ControllerChangeType.PUSH_ENTER : ControllerChangeType.POP_ENTER;
            ControllerChangeType controllerChangeType = fromChangeType = isPush ? ControllerChangeType.PUSH_EXIT : ControllerChangeType.POP_EXIT;
            if (to != null) {
                toView = to.inflate(container);
                to.changeStarted(handler, toChangeType);
            } else {
                toView = null;
            }
            if (from != null) {
                fromView = from.getView();
                from.changeStarted(handler, fromChangeType);
            } else {
                fromView = null;
            }
            handler.performChange(container, fromView, toView, isPush, new ControllerChangeCompletedListener(){

                @Override
                public void onChangeCompleted() {
                    ViewParent fromParent;
                    if (from != null) {
                        from.changeEnded(handler, fromChangeType);
                    }
                    if (to != null) {
                        inProgressPushHandlers.remove(to.getInstanceId());
                        to.changeEnded(handler, toChangeType);
                    }
                    for (ControllerChangeListener listener : listeners) {
                        listener.onChangeCompleted(to, from, isPush, container, handler);
                    }
                    if (handler.forceRemoveViewOnPush && fromView != null && (fromParent = fromView.getParent()) != null && fromParent instanceof ViewGroup) {
                        ((ViewGroup)fromParent).removeView(fromView);
                    }
                }
            });
        }
    }

    public boolean removesFromViewOnPush() {
        return true;
    }

    public void setForceRemoveViewOnPush(boolean force) {
        this.forceRemoveViewOnPush = force;
    }

    public static interface ControllerChangeCompletedListener {
        public void onChangeCompleted();
    }

    public static interface ControllerChangeListener {
        public void onChangeStarted(@Nullable Controller var1, @Nullable Controller var2, boolean var3, @NonNull ViewGroup var4, @NonNull ControllerChangeHandler var5);

        public void onChangeCompleted(@Nullable Controller var1, @Nullable Controller var2, boolean var3, @NonNull ViewGroup var4, @NonNull ControllerChangeHandler var5);
    }
}

