/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.internal;

import android.view.View;
import android.view.ViewGroup;

public class ViewAttachHandler {
    private ViewAttachListener attachListener;
    private View.OnAttachStateChangeListener rootOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){
        boolean rootAttached = false;
        boolean childrenAttached = false;

        public void onViewAttachedToWindow(final View v) {
            if (this.rootAttached) {
                return;
            }
            this.rootAttached = true;
            ViewAttachHandler.this.listenForDeepestChildAttach(v, new ChildAttachListener(){

                @Override
                public void onAttached() {
                    childrenAttached = true;
                    ViewAttachHandler.this.attachListener.onAttached(v);
                }
            });
        }

        public void onViewDetachedFromWindow(View v) {
            this.rootAttached = false;
            if (this.childrenAttached) {
                this.childrenAttached = false;
                ViewAttachHandler.this.attachListener.onDetached(v);
            }
        }
    };
    private View.OnAttachStateChangeListener childOnAttachStateChangeListener;

    public ViewAttachHandler(ViewAttachListener attachListener) {
        this.attachListener = attachListener;
    }

    public void listenForAttach(View view) {
        view.addOnAttachStateChangeListener(this.rootOnAttachStateChangeListener);
    }

    public void unregisterAttachListener(View view) {
        view.removeOnAttachStateChangeListener(this.rootOnAttachStateChangeListener);
        if (this.childOnAttachStateChangeListener != null && view instanceof ViewGroup) {
            this.findDeepestChild((ViewGroup)view).removeOnAttachStateChangeListener(this.childOnAttachStateChangeListener);
        }
    }

    void listenForDeepestChildAttach(View view, final ChildAttachListener attachListener) {
        if (!(view instanceof ViewGroup)) {
            attachListener.onAttached();
            return;
        }
        ViewGroup viewGroup = (ViewGroup)view;
        if (viewGroup.getChildCount() == 0) {
            attachListener.onAttached();
            return;
        }
        this.childOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){
            boolean attached = false;

            public void onViewAttachedToWindow(View v) {
                if (!this.attached) {
                    this.attached = true;
                    attachListener.onAttached();
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewAttachHandler.this.childOnAttachStateChangeListener = null;
                }
            }

            public void onViewDetachedFromWindow(View v) {
            }
        };
        this.findDeepestChild(viewGroup).addOnAttachStateChangeListener(this.childOnAttachStateChangeListener);
    }

    private View findDeepestChild(ViewGroup viewGroup) {
        if (viewGroup.getChildCount() == 0) {
            return viewGroup;
        }
        View lastChild = viewGroup.getChildAt(viewGroup.getChildCount() - 1);
        if (lastChild instanceof ViewGroup) {
            return this.findDeepestChild((ViewGroup)lastChild);
        }
        return lastChild;
    }

    private static interface ChildAttachListener {
        public void onAttached();
    }

    public static interface ViewAttachListener {
        public void onAttached(View var1);

        public void onDetached(View var1);
    }
}

