/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.changehandler;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;

public class SimpleSwapChangeHandler
extends ControllerChangeHandler
implements View.OnAttachStateChangeListener {
    private static final String KEY_REMOVES_FROM_ON_PUSH = "SimpleSwapChangeHandler.removesFromViewOnPush";
    private boolean removesFromViewOnPush;
    private boolean canceled;
    private ViewGroup container;
    private ControllerChangeHandler.ControllerChangeCompletedListener changeListener;

    public SimpleSwapChangeHandler() {
        this(true);
    }

    public SimpleSwapChangeHandler(boolean removesFromViewOnPush) {
        this.removesFromViewOnPush = removesFromViewOnPush;
    }

    @Override
    public void saveToBundle(@NonNull Bundle bundle) {
        super.saveToBundle(bundle);
        bundle.putBoolean(KEY_REMOVES_FROM_ON_PUSH, this.removesFromViewOnPush);
    }

    @Override
    public void restoreFromBundle(@NonNull Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.removesFromViewOnPush = bundle.getBoolean(KEY_REMOVES_FROM_ON_PUSH);
    }

    @Override
    public void onAbortPush(@NonNull ControllerChangeHandler newHandler, @Nullable Controller newTop) {
        super.onAbortPush(newHandler, newTop);
        this.canceled = true;
    }

    @Override
    public void completeImmediately() {
        if (this.changeListener != null) {
            this.changeListener.onChangeCompleted();
            this.changeListener = null;
            this.container.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.container = null;
        }
    }

    @Override
    public void performChange(@NonNull ViewGroup container, @Nullable View from, @Nullable View to, boolean isPush, @NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
        if (!this.canceled) {
            if (from != null && (!isPush || this.removesFromViewOnPush)) {
                container.removeView(from);
            }
            if (to != null && to.getParent() == null) {
                container.addView(to);
            }
        }
        if (container.getWindowToken() != null) {
            changeListener.onChangeCompleted();
        } else {
            this.changeListener = changeListener;
            this.container = container;
            container.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }

    @Override
    public boolean removesFromViewOnPush() {
        return this.removesFromViewOnPush;
    }

    public void onViewAttachedToWindow(@NonNull View v) {
        v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        if (this.changeListener != null) {
            this.changeListener.onChangeCompleted();
            this.changeListener = null;
            this.container = null;
        }
    }

    public void onViewDetachedFromWindow(@NonNull View v) {
    }
}

