/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Backstack;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.RouterTransaction;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.NoOpControllerChangeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class Router {
    private static final String KEY_BACKSTACK = "Router.backstack";
    private static final String KEY_POPS_LAST_VIEW = "Router.popsLastView";
    protected final Backstack backstack = new Backstack();
    private OnControllerPushedListener onControllerPushedListener;
    private final List<ControllerChangeHandler.ControllerChangeListener> changeListeners = new ArrayList<ControllerChangeHandler.ControllerChangeListener>();
    final List<Controller> destroyingControllers = new ArrayList<Controller>();
    private boolean popsLastView = false;
    ViewGroup container;

    @Nullable
    public abstract Activity getActivity();

    public abstract void onActivityResult(int var1, int var2, @Nullable Intent var3);

    public void onRequestPermissionsResult(@NonNull String instanceId, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.requestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @UiThread
    public boolean handleBack() {
        if (!this.backstack.isEmpty()) {
            if (this.backstack.peek().controller.handleBack()) {
                return true;
            }
            if (this.popCurrentController()) {
                return true;
            }
        }
        return false;
    }

    @UiThread
    public boolean popCurrentController() {
        RouterTransaction transaction = this.backstack.peek();
        if (transaction == null) {
            throw new IllegalStateException("Trying to pop the current controller when there are none on the backstack.");
        }
        return this.popController(transaction.controller);
    }

    @UiThread
    public boolean popController(@NonNull Controller controller) {
        boolean poppingTopController;
        RouterTransaction topController = this.backstack.peek();
        boolean bl = poppingTopController = topController != null && topController.controller == controller;
        if (poppingTopController) {
            this.trackDestroyingController(this.backstack.pop());
        } else {
            for (RouterTransaction transaction : this.backstack) {
                if (transaction.controller != controller) continue;
                this.backstack.remove(transaction);
                break;
            }
        }
        if (poppingTopController) {
            this.performControllerChange(this.backstack.peek(), topController, false);
        }
        if (this.popsLastView) {
            return topController != null;
        }
        return !this.backstack.isEmpty();
    }

    @UiThread
    public void pushController(@NonNull RouterTransaction transaction) {
        RouterTransaction from = this.backstack.peek();
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, from, true);
    }

    @UiThread
    public void replaceTopController(@NonNull RouterTransaction transaction) {
        RouterTransaction topTransaction = this.backstack.peek();
        if (!this.backstack.isEmpty()) {
            this.trackDestroyingController(this.backstack.pop());
        }
        ControllerChangeHandler handler = transaction.pushChangeHandler();
        if (topTransaction != null) {
            boolean newHandlerRemovesViews;
            boolean oldHandlerRemovedViews = topTransaction.pushChangeHandler() == null || topTransaction.pushChangeHandler().removesFromViewOnPush();
            boolean bl = newHandlerRemovesViews = handler == null || handler.removesFromViewOnPush();
            if (!oldHandlerRemovedViews && newHandlerRemovesViews) {
                for (RouterTransaction visibleTransaction : this.getVisibleTransactions(this.backstack.iterator())) {
                    this.performControllerChange(null, visibleTransaction.controller, true, handler != null ? handler.copy() : new SimpleSwapChangeHandler());
                }
            }
        }
        this.pushToBackstack(transaction);
        if (handler != null) {
            handler.setForceRemoveViewOnPush(true);
        }
        this.performControllerChange(transaction.pushChangeHandler(handler), topTransaction, true);
    }

    void destroy() {
        this.popsLastView = true;
        List<RouterTransaction> poppedControllers = this.backstack.popAll();
        if (poppedControllers.size() > 0) {
            this.trackDestroyingControllers(poppedControllers);
            this.performControllerChange(null, poppedControllers.get((int)0).controller, false, poppedControllers.get(0).popChangeHandler());
        }
    }

    public int getContainerId() {
        return this.container != null ? this.container.getId() : 0;
    }

    @NonNull
    public Router setPopsLastView(boolean popsLastView) {
        this.popsLastView = popsLastView;
        return this;
    }

    @UiThread
    public boolean popToRoot() {
        return this.popToRoot(null);
    }

    @UiThread
    public boolean popToRoot(@Nullable ControllerChangeHandler changeHandler) {
        if (this.backstack.size() > 1) {
            this.popToTransaction(this.backstack.root(), changeHandler);
            return true;
        }
        return false;
    }

    @UiThread
    public boolean popToTag(@NonNull String tag) {
        return this.popToTag(tag, null);
    }

    @UiThread
    public boolean popToTag(@NonNull String tag, @Nullable ControllerChangeHandler changeHandler) {
        for (RouterTransaction transaction : this.backstack) {
            if (!tag.equals(transaction.tag())) continue;
            this.popToTransaction(transaction, changeHandler);
            return true;
        }
        return false;
    }

    @UiThread
    public void setRoot(@NonNull RouterTransaction transaction) {
        ControllerChangeHandler newHandler = transaction.pushChangeHandler() != null ? transaction.pushChangeHandler() : new SimpleSwapChangeHandler();
        List<RouterTransaction> visibleTransactions = this.getVisibleTransactions(this.backstack.iterator());
        RouterTransaction rootTransaction = visibleTransactions.size() > 0 ? visibleTransactions.get(0) : null;
        this.removeAllExceptVisibleAndUnowned();
        this.trackDestroyingControllers(this.backstack.popAll());
        this.pushToBackstack(transaction);
        for (int i = visibleTransactions.size() - 1; i > 0; --i) {
            if (visibleTransactions.get((int)i).controller.getView() == null) {
                ControllerChangeHandler.abortPush(visibleTransactions.get((int)i).controller, transaction.controller, newHandler);
                continue;
            }
            this.performControllerChange(null, visibleTransactions.get((int)i).controller, true, newHandler);
        }
        if (rootTransaction != null && rootTransaction.controller.getView() == null) {
            ControllerChangeHandler.abortPush(rootTransaction.controller, transaction.controller, newHandler);
        }
        this.performControllerChange(transaction, rootTransaction, true);
    }

    @Nullable
    public Controller getControllerWithInstanceId(@NonNull String instanceId) {
        for (RouterTransaction transaction : this.backstack) {
            Controller controllerWithId = transaction.controller.findController(instanceId);
            if (controllerWithId == null) continue;
            return controllerWithId;
        }
        return null;
    }

    @Nullable
    public Controller getControllerWithTag(@NonNull String tag) {
        for (RouterTransaction transaction : this.backstack) {
            if (!tag.equals(transaction.tag())) continue;
            return transaction.controller;
        }
        return null;
    }

    public int getBackstackSize() {
        return this.backstack.size();
    }

    @NonNull
    public List<RouterTransaction> getBackstack() {
        ArrayList<RouterTransaction> list = new ArrayList<RouterTransaction>();
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            list.add(backstackIterator.next());
        }
        return list;
    }

    @UiThread
    public void setBackstack(@NonNull List<RouterTransaction> newBackstack, @Nullable ControllerChangeHandler changeHandler) {
        List<RouterTransaction> oldVisibleTransactions = this.getVisibleTransactions(this.backstack.iterator());
        this.removeAllExceptVisibleAndUnowned();
        if (newBackstack.size() > 0) {
            boolean visibleTransactionsChanged;
            ArrayList<RouterTransaction> reverseNewBackstack = new ArrayList<RouterTransaction>(newBackstack);
            Collections.reverse(reverseNewBackstack);
            List<RouterTransaction> newVisibleTransactions = this.getVisibleTransactions(reverseNewBackstack.iterator());
            boolean bl = visibleTransactionsChanged = newVisibleTransactions.size() != oldVisibleTransactions.size();
            if (!visibleTransactionsChanged) {
                for (int i = 0; i < oldVisibleTransactions.size(); ++i) {
                    if (oldVisibleTransactions.get((int)i).controller == newVisibleTransactions.get((int)i).controller) continue;
                    visibleTransactionsChanged = true;
                    break;
                }
            }
            if (visibleTransactionsChanged) {
                RouterTransaction transaction;
                int i;
                ControllerChangeHandler handler = changeHandler != null ? changeHandler : new SimpleSwapChangeHandler();
                Controller rootController = oldVisibleTransactions.size() > 0 ? oldVisibleTransactions.get((int)0).controller : null;
                this.performControllerChange(newVisibleTransactions.get((int)0).controller, rootController, true, handler.copy());
                for (i = oldVisibleTransactions.size() - 1; i > 0; --i) {
                    transaction = oldVisibleTransactions.get(i);
                    ControllerChangeHandler localHandler = handler.copy();
                    localHandler.setForceRemoveViewOnPush(true);
                    this.performControllerChange(null, transaction.controller, true, localHandler);
                }
                for (i = 1; i < newVisibleTransactions.size(); ++i) {
                    transaction = newVisibleTransactions.get(i);
                    handler = transaction.pushChangeHandler() != null ? transaction.pushChangeHandler().copy() : new SimpleSwapChangeHandler();
                    this.performControllerChange(transaction.controller, newVisibleTransactions.get((int)(i - 1)).controller, true, handler);
                }
            }
        }
        for (RouterTransaction transaction : this.backstack) {
            transaction.onAttachedToRouter();
        }
        this.backstack.setBackstack(newBackstack);
        if (this.onControllerPushedListener != null) {
            for (RouterTransaction transaction : newBackstack) {
                this.onControllerPushedListener.onControllerPushed(transaction.controller);
            }
        }
    }

    public boolean hasRootController() {
        return this.getBackstackSize() > 0;
    }

    public void addChangeListener(@NonNull ControllerChangeHandler.ControllerChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(@NonNull ControllerChangeHandler.ControllerChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @UiThread
    public void rebindIfNeeded() {
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            RouterTransaction transaction = backstackIterator.next();
            if (!transaction.controller.getNeedsAttach()) continue;
            this.performControllerChange(transaction.controller, null, true, new SimpleSwapChangeHandler(false));
        }
    }

    public final void onActivityResult(@NonNull String instanceId, int requestCode, int resultCode, @Nullable Intent data) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.onActivityResult(requestCode, resultCode, data);
        }
    }

    public final void onActivityStarted(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityStarted(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityStarted(activity);
            }
        }
    }

    public final void onActivityResumed(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityResumed(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityResumed(activity);
            }
        }
    }

    public final void onActivityPaused(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityPaused(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityPaused(activity);
            }
        }
    }

    public final void onActivityStopped(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityStopped(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityStopped(activity);
            }
        }
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.prepareForContainerRemoval();
        this.changeListeners.clear();
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityDestroyed(activity.isChangingConfigurations());
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityDestroyed(activity);
            }
        }
        for (int index = this.destroyingControllers.size() - 1; index >= 0; --index) {
            Controller controller = this.destroyingControllers.get(index);
            controller.activityDestroyed(activity.isChangingConfigurations());
            for (Router childRouter : controller.getChildRouters()) {
                childRouter.onActivityDestroyed(activity);
            }
        }
        this.container = null;
    }

    public void prepareForHostDetach() {
        for (RouterTransaction transaction : this.backstack) {
            if (ControllerChangeHandler.completePushImmediately(transaction.controller.getInstanceId())) {
                transaction.controller.setNeedsAttach();
            }
            transaction.controller.prepareForHostDetach();
        }
    }

    public void saveInstanceState(@NonNull Bundle outState) {
        this.prepareForHostDetach();
        Bundle backstackState = new Bundle();
        this.backstack.saveInstanceState(backstackState);
        outState.putParcelable(KEY_BACKSTACK, (Parcelable)backstackState);
        outState.putBoolean(KEY_POPS_LAST_VIEW, this.popsLastView);
    }

    public void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        Bundle backstackBundle = (Bundle)savedInstanceState.getParcelable(KEY_BACKSTACK);
        this.backstack.restoreInstanceState(backstackBundle);
        this.popsLastView = savedInstanceState.getBoolean(KEY_POPS_LAST_VIEW);
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            this.setControllerRouter(backstackIterator.next().controller);
        }
    }

    public final void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.createOptionsMenu(menu, inflater);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onCreateOptionsMenu(menu, inflater);
            }
        }
    }

    public final void onPrepareOptionsMenu(@NonNull Menu menu) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.prepareOptionsMenu(menu);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onPrepareOptionsMenu(menu);
            }
        }
    }

    public final boolean onOptionsItemSelected(@NonNull MenuItem item) {
        for (RouterTransaction transaction : this.backstack) {
            if (transaction.controller.optionsItemSelected(item)) {
                return true;
            }
            for (Router childRouter : transaction.controller.getChildRouters()) {
                if (!childRouter.onOptionsItemSelected(item)) continue;
                return true;
            }
        }
        return false;
    }

    private void popToTransaction(@NonNull RouterTransaction transaction, @Nullable ControllerChangeHandler changeHandler) {
        RouterTransaction topTransaction = this.backstack.peek();
        List<RouterTransaction> poppedTransactions = this.backstack.popTo(transaction);
        this.trackDestroyingControllers(poppedTransactions);
        if (poppedTransactions.size() > 0) {
            if (changeHandler == null) {
                changeHandler = topTransaction.popChangeHandler();
            }
            this.performControllerChange(this.backstack.peek().controller, topTransaction.controller, false, changeHandler);
        }
    }

    final void setOnControllerPushedListener(OnControllerPushedListener listener) {
        this.onControllerPushedListener = listener;
    }

    void prepareForContainerRemoval() {
        if (this.container != null) {
            this.container.setOnHierarchyChangeListener(null);
        }
    }

    @NonNull
    final List<Controller> getControllers() {
        ArrayList<Controller> controllers = new ArrayList<Controller>();
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            controllers.add(backstackIterator.next().controller);
        }
        return controllers;
    }

    @Nullable
    public final Boolean handleRequestedPermission(@NonNull String permission) {
        for (RouterTransaction transaction : this.backstack) {
            if (!transaction.controller.didRequestPermission(permission)) continue;
            return transaction.controller.shouldShowRequestPermissionRationale(permission);
        }
        return null;
    }

    private void performControllerChange(@Nullable RouterTransaction to, @Nullable RouterTransaction from, boolean isPush) {
        if (isPush && to != null) {
            to.onAttachedToRouter();
        }
        ControllerChangeHandler changeHandler = isPush ? to.pushChangeHandler() : (from != null ? from.popChangeHandler() : new SimpleSwapChangeHandler());
        Controller toController = to != null ? to.controller : null;
        Controller fromController = from != null ? from.controller : null;
        this.performControllerChange(toController, fromController, isPush, changeHandler);
    }

    private void performControllerChange(@Nullable Controller to, @Nullable Controller from, boolean isPush, @Nullable ControllerChangeHandler changeHandler) {
        if (to != null) {
            this.setControllerRouter(to);
        } else if (this.backstack.size() == 0 && !this.popsLastView) {
            changeHandler = new NoOpControllerChangeHandler();
        }
        ControllerChangeHandler.executeChange(to, from, isPush, this.container, changeHandler, this.changeListeners);
    }

    private void pushToBackstack(@NonNull RouterTransaction entry) {
        this.backstack.push(entry);
        if (this.onControllerPushedListener != null) {
            this.onControllerPushedListener.onControllerPushed(entry.controller);
        }
    }

    private void trackDestroyingController(@NonNull RouterTransaction transaction) {
        if (!transaction.controller.isDestroyed()) {
            this.destroyingControllers.add(transaction.controller);
            transaction.controller.addLifecycleListener(new Controller.LifecycleListener(){

                @Override
                public void postDestroy(@NonNull Controller controller) {
                    Router.this.destroyingControllers.remove(controller);
                }
            });
        }
    }

    private void trackDestroyingControllers(@NonNull List<RouterTransaction> transactions) {
        for (RouterTransaction transaction : transactions) {
            this.trackDestroyingController(transaction);
        }
    }

    private void removeAllExceptVisibleAndUnowned() {
        ArrayList<View> views = new ArrayList<View>();
        for (RouterTransaction transaction : this.getVisibleTransactions(this.backstack.iterator())) {
            if (transaction.controller.getView() == null) continue;
            views.add(transaction.controller.getView());
        }
        for (Router router : this.getSiblingRouters()) {
            if (router.container != this.container) continue;
            this.addRouterViewsToList(router, views);
        }
        int childCount = this.container.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.container.getChildAt(i);
            if (views.contains(child)) continue;
            this.container.removeView(child);
        }
    }

    private void addRouterViewsToList(@NonNull Router router, @NonNull List<View> list) {
        for (Controller controller : router.getControllers()) {
            if (controller.getView() != null) {
                list.add(controller.getView());
            }
            for (Router child : controller.getChildRouters()) {
                this.addRouterViewsToList(child, list);
            }
        }
    }

    private List<RouterTransaction> getVisibleTransactions(@NonNull Iterator<RouterTransaction> backstackIterator) {
        ArrayList<RouterTransaction> transactions = new ArrayList<RouterTransaction>();
        while (backstackIterator.hasNext()) {
            RouterTransaction transaction = backstackIterator.next();
            transactions.add(transaction);
            if (transaction.pushChangeHandler() != null && !transaction.pushChangeHandler().removesFromViewOnPush()) continue;
            break;
        }
        Collections.reverse(transactions);
        return transactions;
    }

    void setControllerRouter(@NonNull Controller controller) {
        controller.setRouter(this);
    }

    abstract void invalidateOptionsMenu();

    abstract void startActivity(@NonNull Intent var1);

    abstract void startActivityForResult(@NonNull String var1, @NonNull Intent var2, int var3);

    abstract void startActivityForResult(@NonNull String var1, @NonNull Intent var2, int var3, @Nullable Bundle var4);

    abstract void registerForActivityResult(@NonNull String var1, int var2);

    abstract void unregisterForActivityResults(@NonNull String var1);

    abstract void requestPermissions(@NonNull String var1, @NonNull String[] var2, int var3);

    abstract boolean hasHost();

    @NonNull
    abstract List<Router> getSiblingRouters();

    @NonNull
    abstract Router getRootRouter();

    static interface OnControllerPushedListener {
        public void onControllerPushed(Controller var1);
    }
}

