/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Backstack;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.RouterTransaction;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.NoOpControllerChangeHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Router {
    private static final String KEY_BACKSTACK = "Router.backstack";
    private static final String KEY_POPS_LAST_VIEW = "Router.popsLastView";
    protected final Backstack backStack = new Backstack();
    private final List<ControllerChangeHandler.ControllerChangeListener> changeListeners = new ArrayList<ControllerChangeHandler.ControllerChangeListener>();
    private final List<Controller> destroyingControllers = new ArrayList<Controller>();
    private boolean popsLastView = false;
    ViewGroup container;

    public abstract Activity getActivity();

    public abstract void onActivityResult(int var1, int var2, Intent var3);

    public void onRequestPermissionsResult(String instanceId, int requestCode, String[] permissions, int[] grantResults) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.requestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public boolean handleBack() {
        if (!this.backStack.isEmpty()) {
            if (this.backStack.peek().controller.handleBack()) {
                return true;
            }
            if (this.popCurrentController()) {
                return true;
            }
        }
        return false;
    }

    public boolean popCurrentController() {
        return this.popController(this.backStack.peek().controller);
    }

    public boolean popController(Controller controller) {
        boolean poppingTopController;
        RouterTransaction topController = this.backStack.peek();
        boolean bl = poppingTopController = topController != null && topController.controller == controller;
        if (poppingTopController) {
            this.trackDestroyingController(this.backStack.pop());
        } else {
            for (RouterTransaction transaction : this.backStack) {
                if (transaction.controller != controller) continue;
                this.backStack.remove(transaction);
                break;
            }
        }
        if (poppingTopController) {
            this.performControllerChange(this.backStack.peek(), topController, false);
        }
        if (this.popsLastView) {
            return topController != null;
        }
        return !this.backStack.isEmpty();
    }

    public void pushController(@NonNull RouterTransaction transaction) {
        RouterTransaction from = this.backStack.peek();
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, from, true);
    }

    public void replaceTopController(@NonNull RouterTransaction transaction) {
        RouterTransaction topTransaction = this.backStack.peek();
        if (!this.backStack.isEmpty()) {
            this.trackDestroyingController(this.backStack.pop());
        }
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, topTransaction, true);
    }

    void destroy() {
        this.popsLastView = true;
        List<RouterTransaction> poppedControllers = this.backStack.popAll();
        if (poppedControllers.size() > 0) {
            this.trackDestroyingControllers(poppedControllers);
            this.performControllerChange(null, poppedControllers.get((int)0).controller, false, poppedControllers.get(0).popChangeHandler());
        }
    }

    public Router setPopsLastView(boolean popsLastView) {
        this.popsLastView = popsLastView;
        return this;
    }

    public boolean popToRoot() {
        return this.popToRoot(null);
    }

    public boolean popToRoot(ControllerChangeHandler changeHandler) {
        if (this.backStack.size() > 1) {
            this.popToTransaction(this.backStack.root(), changeHandler);
            return true;
        }
        return false;
    }

    public boolean popToTag(@NonNull String tag) {
        return this.popToTag(tag, null);
    }

    public boolean popToTag(@NonNull String tag, ControllerChangeHandler changeHandler) {
        for (RouterTransaction transaction : this.backStack) {
            if (!tag.equals(transaction.tag())) continue;
            this.popToTransaction(transaction, changeHandler);
            return true;
        }
        return false;
    }

    public void setRoot(@NonNull RouterTransaction transaction) {
        RouterTransaction currentTop = this.backStack.peek();
        this.removeAllExceptTopAndUnowned();
        this.trackDestroyingControllers(this.backStack.popAll());
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, currentTop, true);
    }

    public Controller getControllerWithInstanceId(String instanceId) {
        for (RouterTransaction transaction : this.backStack) {
            Controller controllerWithId = transaction.controller.findController(instanceId);
            if (controllerWithId == null) continue;
            return controllerWithId;
        }
        return null;
    }

    public Controller getControllerWithTag(String tag) {
        for (RouterTransaction transaction : this.backStack) {
            if (!tag.equals(transaction.tag())) continue;
            return transaction.controller;
        }
        return null;
    }

    public int getBackstackSize() {
        return this.backStack.size();
    }

    public List<RouterTransaction> getBackstack() {
        ArrayList<RouterTransaction> list = new ArrayList<RouterTransaction>();
        Iterator<RouterTransaction> backstackIterator = this.backStack.reverseIterator();
        while (backstackIterator.hasNext()) {
            list.add(backstackIterator.next());
        }
        return list;
    }

    public void setBackstack(@NonNull List<RouterTransaction> backstack, ControllerChangeHandler changeHandler) {
        Controller newTop;
        RouterTransaction oldTopTransaction = this.backStack.peek();
        Controller oldTop = oldTopTransaction != null ? oldTopTransaction.controller : null;
        this.removeAllExceptTopAndUnowned();
        if (backstack.size() > 0 && (newTop = backstack.get((int)(backstack.size() - 1)).controller) != oldTop) {
            ControllerChangeHandler handler = changeHandler != null ? changeHandler : new SimpleSwapChangeHandler();
            this.performControllerChange(newTop, oldTop, true, handler);
        }
        for (RouterTransaction transaction : backstack) {
            transaction.onAttachedToRouter();
        }
        this.backStack.setBackstack(backstack);
    }

    public boolean hasRootController() {
        return this.getBackstackSize() > 0;
    }

    public void addChangeListener(ControllerChangeHandler.ControllerChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(ControllerChangeHandler.ControllerChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public void rebindIfNeeded() {
        Iterator<RouterTransaction> backstackIterator = this.backStack.reverseIterator();
        while (backstackIterator.hasNext()) {
            RouterTransaction transaction = backstackIterator.next();
            if (!transaction.controller.getNeedsAttach()) continue;
            this.performControllerChange(transaction.controller, null, true, new SimpleSwapChangeHandler(false));
        }
    }

    public final void onActivityResult(String instanceId, int requestCode, int resultCode, Intent data) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.onActivityResult(requestCode, resultCode, data);
        }
    }

    public final void onActivityStarted(Activity activity) {
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.activityStarted(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityStarted(activity);
            }
        }
    }

    public final void onActivityResumed(Activity activity) {
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.activityResumed(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityResumed(activity);
            }
        }
    }

    public final void onActivityPaused(Activity activity) {
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.activityPaused(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityPaused(activity);
            }
        }
    }

    public final void onActivityStopped(Activity activity) {
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.activityStopped(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityStopped(activity);
            }
        }
    }

    public void onActivityDestroyed(Activity activity) {
        this.prepareForContainerRemoval();
        this.changeListeners.clear();
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.activityDestroyed(activity.isChangingConfigurations());
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityDestroyed(activity);
            }
        }
        for (int index = this.destroyingControllers.size() - 1; index >= 0; --index) {
            Controller controller = this.destroyingControllers.get(index);
            controller.activityDestroyed(activity.isChangingConfigurations());
            for (Router childRouter : controller.getChildRouters()) {
                childRouter.onActivityDestroyed(activity);
            }
        }
        this.container = null;
    }

    public void prepareForHostDetach() {
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.prepareForHostDetach();
        }
    }

    public void saveInstanceState(Bundle outState) {
        this.prepareForHostDetach();
        Bundle backstackState = new Bundle();
        this.backStack.saveInstanceState(backstackState);
        outState.putParcelable(KEY_BACKSTACK, (Parcelable)backstackState);
        outState.putBoolean(KEY_POPS_LAST_VIEW, this.popsLastView);
    }

    public void restoreInstanceState(Bundle savedInstanceState) {
        Bundle backstackBundle = (Bundle)savedInstanceState.getParcelable(KEY_BACKSTACK);
        this.backStack.restoreInstanceState(backstackBundle);
        this.popsLastView = savedInstanceState.getBoolean(KEY_POPS_LAST_VIEW);
        Iterator<RouterTransaction> backstackIterator = this.backStack.reverseIterator();
        while (backstackIterator.hasNext()) {
            this.setControllerRouter(backstackIterator.next().controller);
        }
    }

    public final void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.createOptionsMenu(menu, inflater);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onCreateOptionsMenu(menu, inflater);
            }
        }
    }

    public final void onPrepareOptionsMenu(Menu menu) {
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.prepareOptionsMenu(menu);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onPrepareOptionsMenu(menu);
            }
        }
    }

    public final boolean onOptionsItemSelected(MenuItem item) {
        for (RouterTransaction transaction : this.backStack) {
            if (transaction.controller.optionsItemSelected(item)) {
                return true;
            }
            for (Router childRouter : transaction.controller.getChildRouters()) {
                if (!childRouter.onOptionsItemSelected(item)) continue;
                return true;
            }
        }
        return false;
    }

    private void popToTransaction(@NonNull RouterTransaction transaction, ControllerChangeHandler changeHandler) {
        RouterTransaction topTransaction = this.backStack.peek();
        List<RouterTransaction> poppedTransactions = this.backStack.popTo(transaction);
        this.trackDestroyingControllers(poppedTransactions);
        if (poppedTransactions.size() > 0) {
            if (changeHandler == null) {
                changeHandler = topTransaction.popChangeHandler();
            }
            this.performControllerChange(this.backStack.peek().controller, topTransaction.controller, false, changeHandler);
        }
    }

    void prepareForContainerRemoval() {
        if (this.container != null) {
            this.container.setOnHierarchyChangeListener(null);
        }
    }

    final List<Controller> getControllers() {
        ArrayList<Controller> controllers = new ArrayList<Controller>();
        Iterator<RouterTransaction> backstackIterator = this.backStack.reverseIterator();
        while (backstackIterator.hasNext()) {
            controllers.add(backstackIterator.next().controller);
        }
        return controllers;
    }

    public final Boolean handleRequestedPermission(@NonNull String permission) {
        for (RouterTransaction transaction : this.backStack) {
            if (!transaction.controller.didRequestPermission(permission)) continue;
            return transaction.controller.shouldShowRequestPermissionRationale(permission);
        }
        return null;
    }

    private void performControllerChange(RouterTransaction to, RouterTransaction from, boolean isPush) {
        if (isPush && to != null) {
            to.onAttachedToRouter();
        }
        ControllerChangeHandler changeHandler = isPush ? to.pushChangeHandler() : (from != null ? from.popChangeHandler() : new SimpleSwapChangeHandler());
        Controller toController = to != null ? to.controller : null;
        Controller fromController = from != null ? from.controller : null;
        this.performControllerChange(toController, fromController, isPush, changeHandler);
    }

    private void performControllerChange(Controller to, Controller from, boolean isPush, @NonNull ControllerChangeHandler changeHandler) {
        if (to != null) {
            this.setControllerRouter(to);
        } else if (this.backStack.size() == 0 && !this.popsLastView) {
            changeHandler = new NoOpControllerChangeHandler();
        }
        ControllerChangeHandler.executeChange(to, from, isPush, this.container, changeHandler, this.changeListeners);
    }

    void pushToBackstack(@NonNull RouterTransaction entry) {
        this.backStack.push(entry);
    }

    private void trackDestroyingController(RouterTransaction transaction) {
        if (!transaction.controller.isDestroyed()) {
            this.destroyingControllers.add(transaction.controller);
            transaction.controller.addLifecycleListener(new Controller.LifecycleListener(){

                @Override
                public void postDestroy(@NonNull Controller controller) {
                    Router.this.destroyingControllers.remove(controller);
                }
            });
        }
    }

    private void trackDestroyingControllers(List<RouterTransaction> transactions) {
        for (RouterTransaction transaction : transactions) {
            this.trackDestroyingController(transaction);
        }
    }

    private void removeAllExceptTopAndUnowned() {
        View topView;
        ArrayList<View> views = new ArrayList<View>();
        RouterTransaction topTransaction = this.backStack.peek();
        View view = topView = topTransaction != null ? topTransaction.controller.getView() : null;
        if (topView != null) {
            views.add(topView);
        }
        for (Router router : this.getSiblingRouters()) {
            if (router.container != this.container) continue;
            this.addRouterViewsToList(router, views);
        }
        int childCount = this.container.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.container.getChildAt(i);
            if (views.contains(child)) continue;
            this.container.removeView(child);
        }
    }

    private void addRouterViewsToList(Router router, List<View> list) {
        for (Controller controller : router.getControllers()) {
            if (controller.getView() != null) {
                list.add(controller.getView());
            }
            for (Router child : controller.getChildRouters()) {
                this.addRouterViewsToList(child, list);
            }
        }
    }

    void setControllerRouter(Controller controller) {
        controller.setRouter(this);
    }

    abstract void invalidateOptionsMenu();

    abstract void startActivity(Intent var1);

    abstract void startActivityForResult(String var1, Intent var2, int var3);

    abstract void startActivityForResult(String var1, Intent var2, int var3, Bundle var4);

    abstract void registerForActivityResult(String var1, int var2);

    abstract void unregisterForActivityResults(String var1);

    abstract void requestPermissions(String var1, String[] var2, int var3);

    abstract boolean hasHost();

    abstract List<Router> getSiblingRouters();
}

