/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;

public class RouterTransaction {
    private static final String KEY_VIEW_CONTROLLER_BUNDLE = "RouterTransaction.controller.bundle";
    private static final String KEY_PUSH_TRANSITION = "RouterTransaction.pushControllerChangeHandler";
    private static final String KEY_POP_TRANSITION = "RouterTransaction.popControllerChangeHandler";
    private static final String KEY_TAG = "RouterTransaction.tag";
    private static final String KEY_ATTACHED_TO_ROUTER = "RouterTransaction.attachedToRouter";
    @NonNull
    final Controller controller;
    private String tag;
    private ControllerChangeHandler mPushControllerChangeHandler;
    private ControllerChangeHandler mPopControllerChangeHandler;
    private boolean mAttachedToRouter;

    public static RouterTransaction with(@NonNull Controller controller) {
        return new RouterTransaction(controller);
    }

    private RouterTransaction(@NonNull Controller controller) {
        this.controller = controller;
    }

    RouterTransaction(@NonNull Bundle bundle) {
        this.controller = Controller.newInstance(bundle.getBundle(KEY_VIEW_CONTROLLER_BUNDLE));
        this.mPushControllerChangeHandler = ControllerChangeHandler.fromBundle(bundle.getBundle(KEY_PUSH_TRANSITION));
        this.mPopControllerChangeHandler = ControllerChangeHandler.fromBundle(bundle.getBundle(KEY_POP_TRANSITION));
        this.tag = bundle.getString(KEY_TAG);
        this.mAttachedToRouter = bundle.getBoolean(KEY_ATTACHED_TO_ROUTER);
    }

    void onAttachedToRouter() {
        this.mAttachedToRouter = true;
    }

    String tag() {
        return this.tag;
    }

    public RouterTransaction tag(String tag) {
        if (!this.mAttachedToRouter) {
            this.tag = tag;
            return this;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + "s can not be modified after being added to a Router.");
    }

    ControllerChangeHandler pushChangeHandler() {
        ControllerChangeHandler handler = this.controller.getOverriddenPushHandler();
        if (handler == null) {
            handler = this.mPushControllerChangeHandler;
        }
        return handler;
    }

    public RouterTransaction pushChangeHandler(ControllerChangeHandler handler) {
        if (!this.mAttachedToRouter) {
            this.mPushControllerChangeHandler = handler;
            return this;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + "s can not be modified after being added to a Router.");
    }

    ControllerChangeHandler popChangeHandler() {
        ControllerChangeHandler handler = this.controller.getOverriddenPopHandler();
        if (handler == null) {
            handler = this.mPopControllerChangeHandler;
        }
        return handler;
    }

    public RouterTransaction popChangeHandler(ControllerChangeHandler handler) {
        if (!this.mAttachedToRouter) {
            this.mPopControllerChangeHandler = handler;
            return this;
        }
        throw new RuntimeException(this.getClass().getSimpleName() + "s can not be modified after being added to a Router.");
    }

    public Bundle saveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putBundle(KEY_VIEW_CONTROLLER_BUNDLE, this.controller.saveInstanceState());
        if (this.mPushControllerChangeHandler != null) {
            bundle.putBundle(KEY_PUSH_TRANSITION, this.mPushControllerChangeHandler.toBundle());
        }
        if (this.mPopControllerChangeHandler != null) {
            bundle.putBundle(KEY_POP_TRANSITION, this.mPopControllerChangeHandler.toBundle());
        }
        bundle.putString(KEY_TAG, this.tag);
        bundle.putBoolean(KEY_ATTACHED_TO_ROUTER, this.mAttachedToRouter);
        return bundle;
    }
}

