/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import com.bluelinelabs.conductor.RouterTransaction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

class Backstack
implements Iterable<RouterTransaction> {
    private static final String KEY_ENTRIES = "Backstack.entries";
    private final Deque<RouterTransaction> mBackStack = new ArrayDeque<RouterTransaction>();

    Backstack() {
    }

    public boolean isEmpty() {
        return this.mBackStack.isEmpty();
    }

    public int size() {
        return this.mBackStack.size();
    }

    public RouterTransaction root() {
        return this.mBackStack.size() > 0 ? this.mBackStack.getLast() : null;
    }

    @Override
    public Iterator<RouterTransaction> iterator() {
        return this.mBackStack.iterator();
    }

    public Iterator<RouterTransaction> reverseIterator() {
        return this.mBackStack.descendingIterator();
    }

    public List<RouterTransaction> popTo(RouterTransaction transaction) {
        ArrayList<RouterTransaction> popped = new ArrayList<RouterTransaction>();
        if (this.mBackStack.contains(transaction)) {
            while (this.mBackStack.peek() != transaction) {
                RouterTransaction poppedTransaction = this.pop();
                popped.add(poppedTransaction);
            }
        } else {
            throw new RuntimeException("Tried to pop to a transaction that was not on the back stack");
        }
        return popped;
    }

    public RouterTransaction pop() {
        RouterTransaction popped = this.mBackStack.pop();
        popped.controller.destroy();
        return popped;
    }

    public RouterTransaction peek() {
        return this.mBackStack.peek();
    }

    public void remove(RouterTransaction transaction) {
        this.mBackStack.removeFirstOccurrence(transaction);
    }

    public void push(RouterTransaction transaction) {
        this.mBackStack.push(transaction);
    }

    public List<RouterTransaction> popAll() {
        ArrayList<RouterTransaction> list = new ArrayList<RouterTransaction>();
        while (!this.isEmpty()) {
            list.add(this.pop());
        }
        return list;
    }

    public void setBackstack(List<RouterTransaction> backstack) {
        for (RouterTransaction existingTransaction : this.mBackStack) {
            boolean contains = false;
            for (RouterTransaction newTransaction : backstack) {
                if (existingTransaction.controller != newTransaction.controller) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            existingTransaction.controller.destroy();
        }
        this.mBackStack.clear();
        for (RouterTransaction transaction : backstack) {
            this.mBackStack.push(transaction);
        }
    }

    public void saveInstanceState(Bundle outState) {
        ArrayList<Bundle> entryBundles = new ArrayList<Bundle>(this.mBackStack.size());
        for (RouterTransaction entry : this.mBackStack) {
            entryBundles.add(entry.saveInstanceState());
        }
        outState.putParcelableArrayList(KEY_ENTRIES, entryBundles);
    }

    public void restoreInstanceState(Bundle savedInstanceState) {
        ArrayList entryBundles = savedInstanceState.getParcelableArrayList(KEY_ENTRIES);
        if (entryBundles != null) {
            Collections.reverse(entryBundles);
            for (Bundle transactionBundle : entryBundles) {
                this.mBackStack.push(new RouterTransaction(transactionBundle));
            }
        }
    }
}

