/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.ControllerHostedRouter;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.RouterTransaction;
import com.bluelinelabs.conductor.internal.ClassUtils;
import com.bluelinelabs.conductor.internal.RouterRequiringFunc;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public abstract class Controller {
    private static final String KEY_CLASS_NAME = "Controller.className";
    private static final String KEY_VIEW_STATE = "Controller.viewState";
    private static final String KEY_CHILD_ROUTERS = "Controller.childRouters";
    private static final String KEY_SAVED_STATE = "Controller.savedState";
    private static final String KEY_INSTANCE_ID = "Controller.instanceId";
    private static final String KEY_TARGET_INSTANCE_ID = "Controller.target.instanceId";
    private static final String KEY_ARGS = "Controller.args";
    private static final String KEY_NEEDS_ATTACH = "Controller.needsAttach";
    private static final String KEY_REQUESTED_PERMISSIONS = "Controller.requestedPermissions";
    private static final String KEY_OVERRIDDEN_PUSH_HANDLER = "Controller.overriddenPushHandler";
    private static final String KEY_OVERRIDDEN_POP_HANDLER = "Controller.overriddenPopHandler";
    private static final String KEY_VIEW_STATE_HIERARCHY = "Controller.viewState.hierarchy";
    private static final String KEY_VIEW_STATE_BUNDLE = "Controller.viewState.bundle";
    private final Bundle mArgs;
    private Bundle mViewState;
    private Bundle mSavedInstanceState;
    private boolean mIsBeingDestroyed;
    private boolean mDestroyed;
    private boolean mAttached;
    private boolean mHasOptionsMenu;
    private boolean mOptionsMenuHidden;
    private boolean mViewIsAttached;
    private boolean mViewWasDetached;
    private Router mRouter;
    private View mView;
    private Controller mParentController;
    private String mInstanceId;
    private String mTargetInstanceId;
    private boolean mNeedsAttach;
    private boolean mHasSavedViewState;
    private boolean mIsDetachFrozen;
    private ControllerChangeHandler mOverriddenPushHandler;
    private ControllerChangeHandler mOverriddenPopHandler;
    private RetainViewMode mRetainViewMode = RetainViewMode.RELEASE_DETACH;
    private View.OnAttachStateChangeListener mOnAttachStateChangeListener;
    private final List<ControllerHostedRouter> mChildRouters = new ArrayList<ControllerHostedRouter>();
    private final List<LifecycleListener> mLifecycleListeners = new ArrayList<LifecycleListener>();
    private final ArrayList<String> mRequestedPermissions = new ArrayList();
    private final ArrayList<RouterRequiringFunc> mOnRouterSetListeners = new ArrayList();
    private final Deque<Controller> mChildBackstack = new ArrayDeque<Controller>();

    static Controller newInstance(Bundle bundle) {
        Controller controller;
        String className = bundle.getString(KEY_CLASS_NAME);
        Constructor[] constructors = ClassUtils.classForName(className, false).getConstructors();
        Constructor bundleConstructor = Controller.getBundleConstructor(constructors);
        try {
            controller = bundleConstructor != null ? (Controller)bundleConstructor.newInstance(bundle.getBundle(KEY_ARGS)) : (Controller)Controller.getDefaultConstructor(constructors).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while creating a new instance of " + className + ". " + e.getMessage());
        }
        controller.restoreInstanceState(bundle);
        return controller;
    }

    protected Controller() {
        this(null);
    }

    protected Controller(Bundle args) {
        this.mArgs = args;
        this.mInstanceId = UUID.randomUUID().toString();
        this.ensureRequiredConstructor();
    }

    @NonNull
    protected abstract View onCreateView(@NonNull LayoutInflater var1, @NonNull ViewGroup var2);

    public final Router getRouter() {
        return this.mRouter;
    }

    public Bundle getArgs() {
        return this.mArgs;
    }

    public final Router getChildRouter(@NonNull ViewGroup container, String tag) {
        int containerId = container.getId();
        ControllerHostedRouter childRouter = null;
        for (ControllerHostedRouter router : this.mChildRouters) {
            if (router.getHostId() != containerId || !TextUtils.equals((CharSequence)tag, (CharSequence)router.getTag())) continue;
            childRouter = router;
            break;
        }
        if (childRouter == null) {
            childRouter = new ControllerHostedRouter(container.getId(), tag);
            this.monitorChildRouter(childRouter);
            childRouter.setHost(this, container);
            this.mChildRouters.add(childRouter);
        } else if (!childRouter.hasHost()) {
            childRouter.setHost(this, container);
            childRouter.rebindIfNeeded();
        }
        return childRouter;
    }

    public final void removeChildRouter(@NonNull Router childRouter) {
        if (childRouter instanceof ControllerHostedRouter && this.mChildRouters.remove(childRouter)) {
            childRouter.destroy();
        }
    }

    public final boolean isDestroyed() {
        return this.mDestroyed;
    }

    public final boolean isBeingDestroyed() {
        return this.mIsBeingDestroyed;
    }

    public final boolean isAttached() {
        return this.mAttached;
    }

    public final View getView() {
        return this.mView;
    }

    public final Activity getActivity() {
        return this.mRouter.getActivity();
    }

    public final Resources getResources() {
        Activity activity = this.getActivity();
        return activity != null ? activity.getResources() : null;
    }

    public final Context getApplicationContext() {
        Activity activity = this.getActivity();
        return activity != null ? activity.getApplicationContext() : null;
    }

    public final Controller getParentController() {
        return this.mParentController;
    }

    public final String getInstanceId() {
        return this.mInstanceId;
    }

    final Controller findController(String instanceId) {
        if (this.mInstanceId.equals(instanceId)) {
            return this;
        }
        for (Router router : this.mChildRouters) {
            Controller matchingChild = router.getControllerWithInstanceId(instanceId);
            if (matchingChild == null) continue;
            return matchingChild;
        }
        return null;
    }

    public final List<Router> getChildRouters() {
        ArrayList<Router> routers = new ArrayList<Router>();
        for (Router router : this.mChildRouters) {
            routers.add(router);
        }
        return routers;
    }

    public void setTargetController(Controller target) {
        if (this.mTargetInstanceId != null) {
            throw new RuntimeException("Target controller already set. A controller's target may only be set once.");
        }
        this.mTargetInstanceId = target != null ? target.getInstanceId() : null;
    }

    public final Controller getTargetController() {
        return this.mTargetInstanceId != null ? this.mRouter.getControllerWithInstanceId(this.mTargetInstanceId) : null;
    }

    protected void onDestroyView(View view) {
    }

    protected void onChangeStarted(@NonNull ControllerChangeHandler changeHandler, @NonNull RouterTransaction.ControllerChangeType changeType) {
    }

    protected void onChangeEnded(@NonNull ControllerChangeHandler changeHandler, @NonNull RouterTransaction.ControllerChangeType changeType) {
    }

    protected void onAttach(@NonNull View view) {
    }

    protected void onDetach(@NonNull View view) {
    }

    protected void onDestroy() {
    }

    protected void onActivityStarted(Activity activity) {
    }

    protected void onActivityResumed(Activity activity) {
    }

    protected void onActivityPaused(Activity activity) {
    }

    protected void onActivityStopped(Activity activity) {
    }

    protected void onSaveViewState(@NonNull View view, @NonNull Bundle outState) {
    }

    protected void onRestoreViewState(@NonNull View view, @NonNull Bundle savedViewState) {
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
    }

    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
    }

    public final void startActivity(final Intent intent) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.startActivity(intent);
            }
        });
    }

    public final void startActivityForResult(final Intent intent, final int requestCode) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.startActivityForResult(Controller.this.mInstanceId, intent, requestCode);
            }
        });
    }

    public final void startActivityForResult(final Intent intent, final int requestCode, final Bundle options) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.startActivityForResult(Controller.this.mInstanceId, intent, requestCode, options);
            }
        });
    }

    public final void registerForActivityResult(final int requestCode) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.registerForActivityResult(Controller.this.mInstanceId, requestCode);
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    @TargetApi(value=23)
    public final void requestPermissions(final @NonNull String[] permissions, final int requestCode) {
        this.mRequestedPermissions.addAll(Arrays.asList(permissions));
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.mRouter.requestPermissions(Controller.this.mInstanceId, permissions, requestCode);
            }
        });
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
    }

    public boolean handleBack() {
        Iterator<Controller> childIterator = this.mChildBackstack.descendingIterator();
        while (childIterator.hasNext()) {
            Controller childController = childIterator.next();
            if (!childController.isAttached() || !childController.getRouter().handleBack()) continue;
            return true;
        }
        return false;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        if (!this.mLifecycleListeners.contains(lifecycleListener)) {
            this.mLifecycleListeners.add(lifecycleListener);
        }
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.mLifecycleListeners.remove(lifecycleListener);
    }

    public RetainViewMode getRetainViewMode() {
        return this.mRetainViewMode;
    }

    public void setRetainViewMode(RetainViewMode retainViewMode) {
        this.mRetainViewMode = retainViewMode;
        if (this.mRetainViewMode == RetainViewMode.RELEASE_DETACH && !this.mAttached) {
            this.removeViewReference();
        }
    }

    public final ControllerChangeHandler getOverriddenPushHandler() {
        return this.mOverriddenPushHandler;
    }

    public void overridePushHandler(ControllerChangeHandler overriddenPushHandler) {
        this.mOverriddenPushHandler = overriddenPushHandler;
    }

    public ControllerChangeHandler getOverriddenPopHandler() {
        return this.mOverriddenPopHandler;
    }

    public void overridePopHandler(ControllerChangeHandler overriddenPopHandler) {
        this.mOverriddenPopHandler = overriddenPopHandler;
    }

    public final void setHasOptionsMenu(boolean hasOptionsMenu) {
        boolean invalidate = this.mAttached && !this.mOptionsMenuHidden && this.mHasOptionsMenu != hasOptionsMenu;
        this.mHasOptionsMenu = hasOptionsMenu;
        if (invalidate) {
            this.mRouter.invalidateOptionsMenu();
        }
    }

    public final void setOptionsMenuHidden(boolean optionsMenuHidden) {
        boolean invalidate = this.mAttached && this.mHasOptionsMenu && this.mOptionsMenuHidden != optionsMenuHidden;
        this.mOptionsMenuHidden = optionsMenuHidden;
        if (invalidate) {
            this.mRouter.invalidateOptionsMenu();
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
    }

    public void onPrepareOptionsMenu(Menu menu) {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    final void prepareForHostDetach() {
        this.mNeedsAttach = this.mNeedsAttach || this.mAttached;
    }

    final boolean getNeedsAttach() {
        return this.mNeedsAttach;
    }

    final boolean didRequestPermission(@NonNull String permission) {
        return this.mRequestedPermissions.contains(permission);
    }

    final void requestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.mRequestedPermissions.removeAll(Arrays.asList(permissions));
        this.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    final void setRouter(@NonNull Router router) {
        if (this.mRouter != router) {
            this.mRouter = router;
            this.performOnRestoreInstanceState();
            for (RouterRequiringFunc listener : this.mOnRouterSetListeners) {
                listener.execute();
            }
            this.mOnRouterSetListeners.clear();
        } else {
            this.performOnRestoreInstanceState();
        }
    }

    final void executeWithRouter(@NonNull RouterRequiringFunc listener) {
        if (this.mRouter != null) {
            listener.execute();
        } else {
            this.mOnRouterSetListeners.add(listener);
        }
    }

    final void activityStarted(Activity activity) {
        this.onActivityStarted(activity);
    }

    final void activityResumed(Activity activity) {
        if (!this.mAttached && this.mView != null && this.mViewIsAttached) {
            this.attach(this.mView);
        }
        this.onActivityResumed(activity);
    }

    final void activityPaused(Activity activity) {
        this.onActivityPaused(activity);
    }

    final void activityStopped(Activity activity) {
        this.onActivityStopped(activity);
    }

    final void activityDestroyed(boolean isChangingConfigurations) {
        if (isChangingConfigurations) {
            this.detach(this.mView, true);
        } else {
            this.destroy(true);
        }
    }

    private void attach(@NonNull View view) {
        this.mHasSavedViewState = false;
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.preAttach(this, view);
        }
        this.mAttached = true;
        this.mNeedsAttach = false;
        this.onAttach(view);
        if (this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
            this.mRouter.invalidateOptionsMenu();
        }
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.postAttach(this, view);
        }
    }

    private void detach(@NonNull View view, boolean forceViewRefRemoval) {
        boolean removeViewRef;
        for (ControllerHostedRouter router : this.mChildRouters) {
            router.prepareForHostDetach();
        }
        boolean bl = removeViewRef = forceViewRefRemoval || this.mRetainViewMode == RetainViewMode.RELEASE_DETACH || this.mIsBeingDestroyed;
        if (this.mAttached) {
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.preDetach(this, view);
            }
            this.mAttached = false;
            this.onDetach(view);
            if (this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
                this.mRouter.invalidateOptionsMenu();
            }
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.postDetach(this, view);
            }
        }
        if (removeViewRef) {
            this.removeViewReference();
        }
    }

    private void removeViewReference() {
        if (this.mView != null) {
            if (!this.mIsBeingDestroyed && !this.mHasSavedViewState) {
                this.saveViewState(this.mView);
            }
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.preDestroyView(this, this.mView);
            }
            this.onDestroyView(this.mView);
            this.mView.removeOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
            this.mViewIsAttached = false;
            this.mView = null;
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.postDestroyView(this);
            }
            for (ControllerHostedRouter childRouter : this.mChildRouters) {
                childRouter.removeHost();
            }
        }
        if (this.mIsBeingDestroyed) {
            this.performDestroy();
        }
    }

    final View inflate(@NonNull ViewGroup parent) {
        if (this.mView != null && this.mView.getParent() != null && this.mView.getParent() != parent) {
            this.detach(this.mView, true);
            this.removeViewReference();
        }
        if (this.mView == null) {
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.preCreateView(this);
            }
            this.mView = this.onCreateView(LayoutInflater.from((Context)parent.getContext()), parent);
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.postCreateView(this, this.mView);
            }
            this.restoreViewState(this.mView);
            this.mOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    if (v == Controller.this.mView) {
                        Controller.this.mViewIsAttached = true;
                        Controller.this.mViewWasDetached = false;
                    }
                    Controller.this.attach(v);
                }

                public void onViewDetachedFromWindow(View v) {
                    Controller.this.mViewIsAttached = false;
                    Controller.this.mViewWasDetached = true;
                    if (!Controller.this.mIsDetachFrozen) {
                        Controller.this.detach(v, false);
                    }
                }
            };
            this.mView.addOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        }
        return this.mView;
    }

    final void performDestroy() {
        if (!this.mDestroyed) {
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.preDestroy(this);
            }
            this.mDestroyed = true;
            if (this.mRouter != null) {
                this.mRouter.unregisterForActivityResults(this.mInstanceId);
            }
            this.onDestroy();
            this.mParentController = null;
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.postDestroy(this);
            }
        }
    }

    final void destroy() {
        this.destroy(false);
    }

    final void destroy(boolean removeViews) {
        this.mIsBeingDestroyed = true;
        for (ControllerHostedRouter childRouter : this.mChildRouters) {
            childRouter.destroy();
        }
        if (!this.mAttached) {
            this.removeViewReference();
        } else if (removeViews) {
            this.detach(this.mView, false);
        }
    }

    final void saveViewState(@NonNull View view) {
        this.mHasSavedViewState = true;
        this.mViewState = new Bundle();
        SparseArray hierarchyState = new SparseArray();
        view.saveHierarchyState(hierarchyState);
        this.mViewState.putSparseParcelableArray(KEY_VIEW_STATE_HIERARCHY, hierarchyState);
        Bundle stateBundle = new Bundle();
        this.onSaveViewState(view, stateBundle);
        this.mViewState.putBundle(KEY_VIEW_STATE_BUNDLE, stateBundle);
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onSaveViewState(this, this.mViewState);
        }
    }

    final void restoreViewState(@NonNull View view) {
        if (this.mViewState != null) {
            view.restoreHierarchyState(this.mViewState.getSparseParcelableArray(KEY_VIEW_STATE_HIERARCHY));
            this.onRestoreViewState(view, this.mViewState.getBundle(KEY_VIEW_STATE_BUNDLE));
            for (ControllerHostedRouter childRouter : this.mChildRouters) {
                View containerView;
                if (childRouter.hasHost() || (containerView = view.findViewById(childRouter.getHostId())) == null || !(containerView instanceof ViewGroup)) continue;
                childRouter.setHost(this, (ViewGroup)containerView);
                childRouter.rebindIfNeeded();
            }
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.onRestoreViewState(this, this.mViewState);
            }
        }
    }

    final Bundle saveInstanceState() {
        if (!this.mHasSavedViewState && this.mView != null) {
            this.saveViewState(this.mView);
        }
        Bundle outState = new Bundle();
        outState.putString(KEY_CLASS_NAME, this.getClass().getName());
        outState.putBundle(KEY_VIEW_STATE, this.mViewState);
        outState.putBundle(KEY_ARGS, this.mArgs);
        outState.putString(KEY_INSTANCE_ID, this.mInstanceId);
        outState.putString(KEY_TARGET_INSTANCE_ID, this.mTargetInstanceId);
        outState.putStringArrayList(KEY_REQUESTED_PERMISSIONS, this.mRequestedPermissions);
        outState.putBoolean(KEY_NEEDS_ATTACH, this.mNeedsAttach || this.mAttached);
        if (this.mOverriddenPushHandler != null) {
            outState.putBundle(KEY_OVERRIDDEN_PUSH_HANDLER, this.mOverriddenPushHandler.toBundle());
        }
        if (this.mOverriddenPopHandler != null) {
            outState.putBundle(KEY_OVERRIDDEN_POP_HANDLER, this.mOverriddenPopHandler.toBundle());
        }
        ArrayList<Bundle> childBundles = new ArrayList<Bundle>();
        for (ControllerHostedRouter childRouter : this.mChildRouters) {
            Bundle routerBundle = new Bundle();
            childRouter.saveInstanceState(routerBundle);
            childBundles.add(routerBundle);
        }
        outState.putParcelableArrayList(KEY_CHILD_ROUTERS, childBundles);
        Bundle savedState = new Bundle();
        this.onSaveInstanceState(savedState);
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onSaveInstanceState(this, savedState);
        }
        outState.putBundle(KEY_SAVED_STATE, savedState);
        return outState;
    }

    private void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.mViewState = savedInstanceState.getBundle(KEY_VIEW_STATE);
        this.mInstanceId = savedInstanceState.getString(KEY_INSTANCE_ID);
        this.mTargetInstanceId = savedInstanceState.getString(KEY_TARGET_INSTANCE_ID);
        this.mRequestedPermissions.addAll(savedInstanceState.getStringArrayList(KEY_REQUESTED_PERMISSIONS));
        this.mOverriddenPushHandler = ControllerChangeHandler.fromBundle(savedInstanceState.getBundle(KEY_OVERRIDDEN_PUSH_HANDLER));
        this.mOverriddenPopHandler = ControllerChangeHandler.fromBundle(savedInstanceState.getBundle(KEY_OVERRIDDEN_POP_HANDLER));
        this.mNeedsAttach = savedInstanceState.getBoolean(KEY_NEEDS_ATTACH);
        ArrayList childBundles = savedInstanceState.getParcelableArrayList(KEY_CHILD_ROUTERS);
        for (Bundle childBundle : childBundles) {
            ControllerHostedRouter childRouter = new ControllerHostedRouter();
            childRouter.restoreInstanceState(childBundle);
            this.monitorChildRouter(childRouter);
            this.mChildRouters.add(childRouter);
        }
        this.mSavedInstanceState = savedInstanceState.getBundle(KEY_SAVED_STATE);
        this.performOnRestoreInstanceState();
    }

    private void performOnRestoreInstanceState() {
        if (this.mSavedInstanceState != null && this.mRouter != null) {
            this.onRestoreInstanceState(this.mSavedInstanceState);
            for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
                lifecycleListener.onRestoreInstanceState(this, this.mSavedInstanceState);
            }
            this.mSavedInstanceState = null;
        }
    }

    final void changeStarted(ControllerChangeHandler changeHandler, RouterTransaction.ControllerChangeType changeType) {
        if (!changeType.isEnter) {
            for (ControllerHostedRouter router : this.mChildRouters) {
                router.setDetachFrozen(true);
            }
        }
        this.onChangeStarted(changeHandler, changeType);
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onChangeStart(this, changeHandler, changeType);
        }
    }

    final void changeEnded(ControllerChangeHandler changeHandler, RouterTransaction.ControllerChangeType changeType) {
        if (!changeType.isEnter) {
            for (ControllerHostedRouter router : this.mChildRouters) {
                router.setDetachFrozen(false);
            }
        }
        this.onChangeEnded(changeHandler, changeType);
        for (LifecycleListener lifecycleListener : this.mLifecycleListeners) {
            lifecycleListener.onChangeEnd(this, changeHandler, changeType);
        }
    }

    final void setDetachFrozen(boolean frozen) {
        if (this.mIsDetachFrozen != frozen) {
            this.mIsDetachFrozen = frozen;
            if (!frozen && this.mView != null && this.mViewWasDetached) {
                this.detach(this.mView, false);
            }
        }
    }

    final void createOptionsMenu(Menu menu, MenuInflater inflater) {
        if (this.mAttached && this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
            this.onCreateOptionsMenu(menu, inflater);
        }
    }

    final void prepareOptionsMenu(Menu menu) {
        if (this.mAttached && this.mHasOptionsMenu && !this.mOptionsMenuHidden) {
            this.onPrepareOptionsMenu(menu);
        }
    }

    final boolean optionsItemSelected(MenuItem item) {
        return this.mAttached && this.mHasOptionsMenu && !this.mOptionsMenuHidden && this.onOptionsItemSelected(item);
    }

    private void monitorChildRouter(ControllerHostedRouter childRouter) {
        childRouter.addChangeListener(new ControllerChangeHandler.ControllerChangeListener(){

            @Override
            public void onChangeStarted(Controller to, Controller from, boolean isPush, ViewGroup container, ControllerChangeHandler handler) {
                if (isPush) {
                    Controller.this.onChildControllerPushed(to);
                }
            }

            @Override
            public void onChangeCompleted(Controller to, Controller from, boolean isPush, ViewGroup container, ControllerChangeHandler handler) {
            }
        });
    }

    private void onChildControllerPushed(Controller controller) {
        this.mChildBackstack.add(controller);
        controller.addLifecycleListener(new LifecycleListener(){

            @Override
            public void postDestroy(@NonNull Controller controller) {
                Controller.this.mChildBackstack.remove(controller);
            }
        });
    }

    final void setParentController(Controller controller) {
        this.mParentController = controller;
    }

    private void ensureRequiredConstructor() {
        Constructor[] constructors = this.getClass().getConstructors();
        if (Controller.getBundleConstructor(constructors) == null && Controller.getDefaultConstructor(constructors) == null) {
            throw new RuntimeException(this.getClass() + " does not have a constructor that takes a Bundle argument or a default constructor. Controllers must have one of these in order to restore their states.");
        }
    }

    private static Constructor getDefaultConstructor(Constructor[] constructors) {
        for (Constructor constructor : constructors) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private static Constructor getBundleConstructor(Constructor[] constructors) {
        for (Constructor constructor : constructors) {
            if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != Bundle.class) continue;
            return constructor;
        }
        return null;
    }

    public static abstract class LifecycleListener {
        public void onChangeStart(@NonNull Controller controller, @NonNull ControllerChangeHandler changeHandler, @NonNull RouterTransaction.ControllerChangeType changeType) {
        }

        public void onChangeEnd(@NonNull Controller controller, @NonNull ControllerChangeHandler changeHandler, @NonNull RouterTransaction.ControllerChangeType changeType) {
        }

        public void preCreateView(@NonNull Controller controller) {
        }

        public void postCreateView(@NonNull Controller controller, @NonNull View view) {
        }

        public void preAttach(@NonNull Controller controller, @NonNull View view) {
        }

        public void postAttach(@NonNull Controller controller, @NonNull View view) {
        }

        public void preDetach(@NonNull Controller controller, @NonNull View view) {
        }

        public void postDetach(@NonNull Controller controller, @NonNull View view) {
        }

        public void preDestroyView(@NonNull Controller controller, @NonNull View view) {
        }

        public void postDestroyView(@NonNull Controller controller) {
        }

        public void preDestroy(@NonNull Controller controller) {
        }

        public void postDestroy(@NonNull Controller controller) {
        }

        public void onSaveInstanceState(@NonNull Controller controller, @NonNull Bundle outState) {
        }

        public void onRestoreInstanceState(@NonNull Controller controller, @NonNull Bundle savedInstanceState) {
        }

        public void onSaveViewState(@NonNull Controller controller, @NonNull Bundle outState) {
        }

        public void onRestoreViewState(@NonNull Controller controller, @NonNull Bundle savedViewState) {
        }
    }

    public static enum RetainViewMode {
        RELEASE_DETACH,
        RETAIN_DETACH;

    }
}

