/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.internal.StringSparseArrayParceler;
import java.util.HashMap;
import java.util.Map;

public class LifecycleHandler
extends Fragment
implements Application.ActivityLifecycleCallbacks {
    private static final String FRAGMENT_TAG = "LifecycleHandler";
    private static final String KEY_PERMISSION_REQUEST_CODES = "LifecycleHandler.permissionRequests";
    private static final String KEY_ACTIVITY_REQUEST_CODES = "LifecycleHandler.activityRequests";
    private Activity mActivity;
    private boolean mHasRegisteredCallbacks;
    private SparseArray<String> mPermissionRequestMap = new SparseArray();
    private SparseArray<String> mActivityRequestMap = new SparseArray();
    private final Map<Integer, Router> mRouterMap = new HashMap<Integer, Router>();

    public LifecycleHandler() {
        this.setRetainInstance(true);
        this.setHasOptionsMenu(true);
    }

    private static LifecycleHandler findInActivity(Activity activity) {
        LifecycleHandler lifecycleHandler = (LifecycleHandler)activity.getFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (lifecycleHandler != null) {
            lifecycleHandler.registerActivityListener(activity);
        }
        return lifecycleHandler;
    }

    public static LifecycleHandler install(Activity activity) {
        LifecycleHandler lifecycleHandler = LifecycleHandler.findInActivity(activity);
        if (lifecycleHandler == null) {
            lifecycleHandler = new LifecycleHandler();
            activity.getFragmentManager().beginTransaction().add((Fragment)lifecycleHandler, FRAGMENT_TAG).commit();
        }
        lifecycleHandler.registerActivityListener(activity);
        return lifecycleHandler;
    }

    public Router getRouter(ViewGroup container, Bundle savedInstanceState) {
        Router router = this.mRouterMap.get(LifecycleHandler.getRouterHashKey(container));
        if (router == null) {
            router = new Router();
            if (savedInstanceState != null) {
                router.onRestoreInstanceState(savedInstanceState);
            }
            this.mRouterMap.put(LifecycleHandler.getRouterHashKey(container), router);
        }
        router.setHost(this, container);
        return router;
    }

    public Activity getLifecycleActivity() {
        return this.mActivity;
    }

    private static int getRouterHashKey(ViewGroup viewGroup) {
        return viewGroup.getId();
    }

    private void registerActivityListener(Activity activity) {
        this.mActivity = activity;
        if (!this.mHasRegisteredCallbacks) {
            this.mHasRegisteredCallbacks = true;
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            StringSparseArrayParceler permissionParcel = (StringSparseArrayParceler)savedInstanceState.getParcelable(KEY_PERMISSION_REQUEST_CODES);
            this.mPermissionRequestMap = permissionParcel != null ? permissionParcel.getStringSparseArray() : null;
            StringSparseArrayParceler activityParcel = (StringSparseArrayParceler)savedInstanceState.getParcelable(KEY_ACTIVITY_REQUEST_CODES);
            this.mActivityRequestMap = activityParcel != null ? activityParcel.getStringSparseArray() : null;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(KEY_PERMISSION_REQUEST_CODES, (Parcelable)new StringSparseArrayParceler(this.mPermissionRequestMap));
        outState.putParcelable(KEY_ACTIVITY_REQUEST_CODES, (Parcelable)new StringSparseArrayParceler(this.mActivityRequestMap));
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mActivity != null) {
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            for (Router router : this.mRouterMap.values()) {
                router.onActivityDestroyed(this.mActivity);
            }
            this.mActivity = null;
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        String instanceId = (String)this.mActivityRequestMap.get(requestCode);
        if (instanceId != null) {
            for (Router router : this.mRouterMap.values()) {
                router.onActivityResult(instanceId, requestCode, resultCode, data);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        String instanceId = (String)this.mPermissionRequestMap.get(requestCode);
        if (instanceId != null) {
            for (Router router : this.mRouterMap.values()) {
                router.onRequestPermissionsResult(instanceId, requestCode, permissions, grantResults);
            }
        }
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        for (Router router : this.mRouterMap.values()) {
            Boolean handled = router.handleRequestedPermission(permission);
            if (handled == null) continue;
            return handled;
        }
        return super.shouldShowRequestPermissionRationale(permission);
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        for (Router router : this.mRouterMap.values()) {
            router.onCreateOptionsMenu(menu, inflater);
        }
    }

    public void onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        for (Router router : this.mRouterMap.values()) {
            router.onPrepareOptionsMenu(menu);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        for (Router router : this.mRouterMap.values()) {
            if (!router.onOptionsItemSelected(item)) continue;
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void registerForActivityRequest(String instanceId, int requestCode) {
        this.mActivityRequestMap.put(requestCode, (Object)instanceId);
    }

    public void unregisterForActivityRequests(String instanceId) {
        for (int i = this.mActivityRequestMap.size() - 1; i >= 0; --i) {
            if (!instanceId.equals(this.mActivityRequestMap.get(this.mActivityRequestMap.keyAt(i)))) continue;
            this.mActivityRequestMap.removeAt(i);
        }
    }

    public void startActivityForResult(String instanceId, Intent intent, int requestCode) {
        this.registerForActivityRequest(instanceId, requestCode);
        this.startActivityForResult(intent, requestCode);
    }

    public void startActivityForResult(String instanceId, Intent intent, int requestCode, Bundle options) {
        this.registerForActivityRequest(instanceId, requestCode);
        this.startActivityForResult(intent, requestCode, options);
    }

    @TargetApi(value=23)
    public void requestPermissions(String instanceId, String[] permissions, int requestCode) {
        this.mPermissionRequestMap.put(requestCode, (Object)instanceId);
        this.requestPermissions(permissions, requestCode);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.mActivity == null && LifecycleHandler.findInActivity(activity) == this) {
            this.mActivity = activity;
        }
    }

    public void onActivityStarted(Activity activity) {
        if (this.mActivity == activity) {
            for (Router router : this.mRouterMap.values()) {
                router.onActivityStarted(activity);
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        if (this.mActivity == activity) {
            for (Router router : this.mRouterMap.values()) {
                router.onActivityResumed(activity);
            }
        }
    }

    public void onActivityPaused(Activity activity) {
        if (this.mActivity == activity) {
            for (Router router : this.mRouterMap.values()) {
                router.onActivityPaused(activity);
            }
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.mActivity == activity) {
            for (Router router : this.mRouterMap.values()) {
                router.onActivityStopped(activity);
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (this.mActivity == activity) {
            for (Router router : this.mRouterMap.values()) {
                router.onActivitySaveInstanceState(activity, outState);
            }
        }
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

