/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerTransaction;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.ClassUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class ControllerChangeHandler {
    private static final String KEY_CLASS_NAME = "ControllerChangeHandler.className";
    private static final String KEY_SAVED_STATE = "ControllerChangeHandler.savedState";

    public abstract void performChange(@NonNull ViewGroup var1, View var2, View var3, boolean var4, @NonNull ControllerChangeCompletedListener var5);

    public ControllerChangeHandler() {
        this.ensureDefaultConstructor();
    }

    public void saveToBundle(@NonNull Bundle bundle) {
    }

    public void restoreFromBundle(@NonNull Bundle bundle) {
    }

    final Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_CLASS_NAME, this.getClass().getCanonicalName());
        Bundle savedState = new Bundle();
        this.saveToBundle(savedState);
        bundle.putBundle(KEY_SAVED_STATE, savedState);
        return bundle;
    }

    private void ensureDefaultConstructor() {
        try {
            this.getClass().getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getClass() + " does not have a default constructor.");
        }
    }

    public static ControllerChangeHandler fromBundle(@Nullable Bundle bundle) {
        if (bundle != null) {
            String className = bundle.getString(KEY_CLASS_NAME);
            ControllerChangeHandler changeHandler = (ControllerChangeHandler)ClassUtils.newInstance(className);
            changeHandler.restoreFromBundle(bundle.getBundle(KEY_SAVED_STATE));
            return changeHandler;
        }
        return null;
    }

    public static void executeChange(Controller to, Controller from, boolean isPush, ViewGroup container, ControllerChangeHandler inHandler) {
        ControllerChangeHandler.executeChange(to, from, isPush, container, inHandler, new ArrayList<ControllerChangeListener>());
    }

    public static void executeChange(final Controller to, final Controller from, final boolean isPush, final ViewGroup container, final ControllerChangeHandler inHandler, final @NonNull List<ControllerChangeListener> listeners) {
        if (container != null) {
            View fromView;
            View toView;
            ControllerChangeHandler handler;
            for (ControllerChangeListener listener : listeners) {
                listener.onChangeStarted(to, from, isPush, container, inHandler);
            }
            final ControllerTransaction.ControllerChangeType toChangeType = isPush ? ControllerTransaction.ControllerChangeType.PUSH_ENTER : ControllerTransaction.ControllerChangeType.POP_ENTER;
            final ControllerTransaction.ControllerChangeType fromChangeType = isPush ? ControllerTransaction.ControllerChangeType.PUSH_EXIT : ControllerTransaction.ControllerChangeType.POP_EXIT;
            ControllerChangeHandler controllerChangeHandler = handler = inHandler != null ? inHandler : new SimpleSwapChangeHandler();
            if (to != null) {
                toView = to.inflate(container);
                to.changeStarted(handler, toChangeType);
            } else {
                toView = null;
            }
            if (from != null) {
                fromView = from.getView();
                from.changeStarted(handler, fromChangeType);
            } else {
                fromView = null;
            }
            handler.performChange(container, fromView, toView, isPush, new ControllerChangeCompletedListener(){

                @Override
                public void onChangeCompleted() {
                    if (from != null) {
                        from.changeEnded(handler, fromChangeType);
                    }
                    if (to != null) {
                        to.changeEnded(handler, toChangeType);
                    }
                    for (ControllerChangeListener listener : listeners) {
                        listener.onChangeCompleted(to, from, isPush, container, inHandler);
                    }
                }
            });
        }
    }

    public static interface ControllerChangeCompletedListener {
        public void onChangeCompleted();
    }

    public static interface ControllerChangeListener {
        public void onChangeStarted(Controller var1, Controller var2, boolean var3, ViewGroup var4, ControllerChangeHandler var5);

        public void onChangeCompleted(Controller var1, Controller var2, boolean var3, ViewGroup var4, ControllerChangeHandler var5);
    }
}

