/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Backstack;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.ControllerTransaction;
import com.bluelinelabs.conductor.RouterTransaction;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.LifecycleHandler;
import com.bluelinelabs.conductor.internal.NoOpControllerChangeHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Router {
    private final Backstack mBackStack = new Backstack();
    private LifecycleHandler mLifecycleHandler;
    private ViewGroup mContainer;
    private final List<ControllerChangeHandler.ControllerChangeListener> mChangeListeners = new ArrayList<ControllerChangeHandler.ControllerChangeListener>();
    private final List<Controller> mDestroyingControllers = new ArrayList<Controller>();

    public Activity getActivity() {
        return this.mLifecycleHandler != null ? this.mLifecycleHandler.getLifecycleActivity() : null;
    }

    public void onActivityResult(String instanceId, int requestCode, int resultCode, Intent data) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onRequestPermissionsResult(String instanceId, int requestCode, String[] permissions, int[] grantResults) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.requestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public boolean handleBack() {
        if (!this.mBackStack.isEmpty()) {
            if (this.mBackStack.peek().controller.handleBack()) {
                return true;
            }
            if (this.popCurrentController()) {
                return true;
            }
        }
        return false;
    }

    public boolean popCurrentController() {
        return this.popController(this.mBackStack.peek().controller);
    }

    public boolean popController(Controller controller) {
        boolean poppingTopController;
        RouterTransaction topController = this.mBackStack.peek();
        boolean bl = poppingTopController = topController.controller == controller;
        if (poppingTopController) {
            this.trackDestroyingController(this.mBackStack.pop());
        } else {
            for (RouterTransaction transaction : this.mBackStack) {
                if (transaction.controller != controller) continue;
                this.mBackStack.remove(transaction);
                break;
            }
        }
        if (poppingTopController) {
            this.performControllerChange(this.mBackStack.peek(), topController, false);
        }
        return !this.mBackStack.isEmpty();
    }

    public void pushController(@NonNull RouterTransaction transaction) {
        RouterTransaction from = this.mBackStack.peek();
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, from, true);
    }

    public void replaceTopController(@NonNull RouterTransaction transaction) {
        RouterTransaction topTransaction = this.mBackStack.peek();
        if (!this.mBackStack.isEmpty()) {
            this.trackDestroyingController(this.mBackStack.pop());
        }
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, topTransaction, true);
    }

    public boolean popToRoot() {
        return this.popToRoot(null);
    }

    public boolean popToRoot(ControllerChangeHandler changeHandler) {
        if (this.mBackStack.size() > 1) {
            this.popToTransaction(this.mBackStack.root(), changeHandler);
            return true;
        }
        return false;
    }

    public boolean popToTag(@NonNull String tag) {
        return this.popToTag(tag, null);
    }

    public boolean popToTag(@NonNull String tag, ControllerChangeHandler changeHandler) {
        for (RouterTransaction transaction : this.mBackStack) {
            if (!tag.equals(transaction.tag)) continue;
            this.popToTransaction(transaction, changeHandler);
            return true;
        }
        return false;
    }

    public void setRoot(@NonNull Controller controller) {
        this.setRoot(controller, null, null);
    }

    public void setRoot(@NonNull Controller controller, String tag) {
        this.setRoot(controller, tag, null);
    }

    public void setRoot(@NonNull Controller controller, ControllerChangeHandler changeHandler) {
        this.setRoot(controller, null, changeHandler);
    }

    public void setRoot(@NonNull Controller controller, String tag, ControllerChangeHandler changeHandler) {
        RouterTransaction currentTop = this.mBackStack.peek();
        if (currentTop != null && currentTop.controller.getView() != null) {
            View fromView = currentTop.controller.getView();
            int childCount = this.mContainer.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.mContainer.getChildAt(i);
                if (child == fromView) continue;
                this.mContainer.removeView(child);
            }
        }
        this.trackDestroyingControllers(this.mBackStack.popAll());
        RouterTransaction transaction = ((RouterTransaction.Builder)((RouterTransaction.Builder)((RouterTransaction.Builder)RouterTransaction.builder(controller).tag(tag)).pushChangeHandler(changeHandler != null ? changeHandler : new SimpleSwapChangeHandler())).popChangeHandler(new SimpleSwapChangeHandler())).build();
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, currentTop, true);
    }

    public Controller getControllerWithInstanceId(String instanceId) {
        for (ControllerTransaction transaction : this.mBackStack) {
            if (transaction.controller.getInstanceId().equals(instanceId)) {
                return transaction.controller;
            }
            Controller childWithId = transaction.controller.getChildControllerWithInstanceId(instanceId);
            if (childWithId == null) continue;
            return childWithId;
        }
        return null;
    }

    public Controller getControllerWithTag(String tag) {
        for (ControllerTransaction transaction : this.mBackStack) {
            if (!tag.equals(transaction.tag)) continue;
            return transaction.controller;
        }
        return null;
    }

    public int getBackstackSize() {
        return this.mBackStack.size();
    }

    public boolean hasRootController() {
        return this.getBackstackSize() > 0;
    }

    public void addChangeListener(ControllerChangeHandler.ControllerChangeListener changeListener) {
        if (!this.mChangeListeners.contains(changeListener)) {
            this.mChangeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(ControllerChangeHandler.ControllerChangeListener changeListener) {
        this.mChangeListeners.remove(changeListener);
    }

    void rebindIfNeeded() {
        Iterator<RouterTransaction> backstackIterator = this.mBackStack.reverseIterator();
        while (backstackIterator.hasNext()) {
            RouterTransaction transaction = backstackIterator.next();
            if (!transaction.controller.getNeedsAttach()) continue;
            this.performControllerChange(transaction.controller, null, true, new SimpleSwapChangeHandler(false));
        }
    }

    public final void onActivityStarted(Activity activity) {
        for (RouterTransaction transaction : this.mBackStack) {
            transaction.controller.activityStarted(activity);
        }
    }

    public final void onActivityResumed(Activity activity) {
        for (RouterTransaction transaction : this.mBackStack) {
            transaction.controller.activityResumed(activity);
        }
    }

    public final void onActivityPaused(Activity activity) {
        for (RouterTransaction transaction : this.mBackStack) {
            transaction.controller.activityPaused(activity);
        }
    }

    public final void onActivityStopped(Activity activity) {
        for (RouterTransaction transaction : this.mBackStack) {
            transaction.controller.activityStopped(activity);
        }
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        for (RouterTransaction transaction : this.mBackStack) {
            transaction.controller.prepareForActivityPause();
        }
        this.mBackStack.detachAndSaveInstanceState(outState);
    }

    public final void onActivityDestroyed(Activity activity) {
        this.mContainer.setOnHierarchyChangeListener(null);
        this.mChangeListeners.clear();
        for (RouterTransaction transaction : this.mBackStack) {
            transaction.controller.activityDestroyed(activity.isChangingConfigurations());
        }
        for (Controller controller : this.mDestroyingControllers) {
            controller.activityDestroyed(activity.isChangingConfigurations());
        }
        this.mLifecycleHandler = null;
        this.mContainer = null;
    }

    public final void onRestoreInstanceState(Bundle savedInstanceState) {
        this.mBackStack.restoreInstanceState(savedInstanceState);
    }

    private void popToTransaction(@NonNull RouterTransaction transaction, ControllerChangeHandler changeHandler) {
        RouterTransaction topTransaction = this.mBackStack.peek();
        List<RouterTransaction> poppedTransactions = this.mBackStack.popTo(transaction);
        this.trackDestroyingControllers(poppedTransactions);
        if (poppedTransactions.size() > 0) {
            if (changeHandler == null) {
                changeHandler = topTransaction.getPopControllerChangeHandler();
            }
            this.performControllerChange(this.mBackStack.peek().controller, topTransaction.controller, false, changeHandler);
        }
    }

    public final void setHost(@NonNull LifecycleHandler lifecycleHandler, @NonNull ViewGroup container) {
        if (this.mLifecycleHandler != lifecycleHandler || this.mContainer != container) {
            if (this.mContainer != null && this.mContainer instanceof ControllerChangeHandler.ControllerChangeListener) {
                this.removeChangeListener((ControllerChangeHandler.ControllerChangeListener)this.mContainer);
            }
            if (container instanceof ControllerChangeHandler.ControllerChangeListener) {
                this.addChangeListener((ControllerChangeHandler.ControllerChangeListener)container);
            }
            this.mLifecycleHandler = lifecycleHandler;
            this.mContainer = container;
        }
    }

    final LifecycleHandler getLifecycleHandler() {
        return this.mLifecycleHandler;
    }

    public final Boolean handleRequestedPermission(@NonNull String permission) {
        for (ControllerTransaction transaction : this.mBackStack) {
            if (!transaction.controller.didRequestPermission(permission)) continue;
            return transaction.controller.shouldShowRequestPermissionRationale(permission);
        }
        return null;
    }

    private void performControllerChange(RouterTransaction to, RouterTransaction from, boolean isPush) {
        ControllerChangeHandler changeHandler = isPush ? to.getPushControllerChangeHandler() : (from != null ? from.getPopControllerChangeHandler() : new SimpleSwapChangeHandler());
        Controller toController = to != null ? to.controller : null;
        Controller fromController = from != null ? from.controller : null;
        this.performControllerChange(toController, fromController, isPush, changeHandler);
    }

    private void performControllerChange(Controller to, Controller from, boolean isPush, @NonNull ControllerChangeHandler changeHandler) {
        if (to != null) {
            to.setRouter(this);
        } else if (this.mBackStack.size() == 0) {
            changeHandler = new NoOpControllerChangeHandler();
        }
        if (this.mContainer != null) {
            ControllerChangeHandler.executeChange(to, from, isPush, this.mContainer, changeHandler, this.mChangeListeners);
        }
    }

    private void pushToBackstack(@NonNull RouterTransaction entry) {
        this.mBackStack.push(entry);
    }

    private void trackDestroyingController(RouterTransaction transaction) {
        if (!transaction.controller.isDestroyed()) {
            this.mDestroyingControllers.add(transaction.controller);
            transaction.controller.addLifecycleListener(new Controller.LifecycleListener(){

                @Override
                public void postDestroy(@NonNull Controller controller) {
                    Router.this.mDestroyingControllers.remove(controller);
                }
            });
        }
    }

    private void trackDestroyingControllers(List<RouterTransaction> transactions) {
        for (RouterTransaction transaction : transactions) {
            this.trackDestroyingController(transaction);
        }
    }
}

