/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.util;

import android.annotation.TargetApi;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

@TargetApi(value=21)
public class ViewUtils {
    public static View findViewWithTransitionName(@NonNull String name, @NonNull View view) {
        View namedView;
        if (name.equals(view.getTransitionName())) {
            return view;
        }
        if (view instanceof ViewGroup && (namedView = ViewUtils.findViewWithTransitionNameInGroup(name, (ViewGroup)view)) != null) {
            return namedView;
        }
        return null;
    }

    private static View findViewWithTransitionNameInGroup(@NonNull String name, @NonNull ViewGroup viewGroup) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View namedView = ViewUtils.findViewWithTransitionName(name, viewGroup.getChildAt(i));
            if (namedView == null) continue;
            return namedView;
        }
        return null;
    }
}

