/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.util;

import android.text.TextUtils;

public class ClassUtils {
    public static <T> Class<? extends T> classForName(String className) {
        return ClassUtils.classForName(className, true);
    }

    public static <T> Class<? extends T> classForName(String className, boolean allowEmptyName) {
        if (allowEmptyName && TextUtils.isEmpty((CharSequence)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while finding class for name " + className + ". " + e.getMessage());
        }
    }

    public static <T> T newInstance(String className) {
        try {
            Class<T> cls = ClassUtils.classForName(className);
            return cls != null ? (T)cls.newInstance() : null;
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while creating a new instance of " + className + ". " + e.getMessage());
        }
    }
}

