/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.rxlifecycle2;

import androidx.annotation.NonNull;
import com.bluelinelabs.conductor.rxlifecycle2.ControllerEvent;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.trello.rxlifecycle2.OutsideLifecycleException;
import com.trello.rxlifecycle2.RxLifecycle;
import io.reactivex.Observable;
import io.reactivex.functions.Function;

public class RxControllerLifecycle {
    private static final Function<ControllerEvent, ControllerEvent> CONTROLLER_LIFECYCLE = new Function<ControllerEvent, ControllerEvent>(){

        public ControllerEvent apply(ControllerEvent lastEvent) {
            switch (lastEvent) {
                case CREATE: {
                    return ControllerEvent.DESTROY;
                }
                case CONTEXT_AVAILABLE: {
                    return ControllerEvent.CONTEXT_UNAVAILABLE;
                }
                case ATTACH: {
                    return ControllerEvent.DETACH;
                }
                case CREATE_VIEW: {
                    return ControllerEvent.DESTROY_VIEW;
                }
                case DETACH: {
                    return ControllerEvent.DESTROY;
                }
            }
            throw new OutsideLifecycleException("Cannot bind to Controller lifecycle when outside of it.");
        }
    };

    public static <T> LifecycleTransformer<T> bindController(@NonNull Observable<ControllerEvent> lifecycle) {
        return RxLifecycle.bind(lifecycle, CONTROLLER_LIFECYCLE);
    }
}

