/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.mydailyjava.weaklockfree;

import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;

public class WeakConcurrentSet<V>
implements Runnable {
    final WeakConcurrentMap<V, Boolean> target;

    public WeakConcurrentSet(Cleaner cleaner) {
        switch (cleaner) {
            case INLINE: {
                this.target = new WeakConcurrentMap.WithInlinedExpunction<V, Boolean>();
                break;
            }
            case THREAD: 
            case MANUAL: {
                this.target = new WeakConcurrentMap(cleaner == Cleaner.THREAD);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void add(V value) {
        this.target.put((Boolean)value, Boolean.TRUE);
    }

    public boolean contains(V value) {
        return this.target.containsKey(value);
    }

    public boolean remove(V value) {
        return this.target.remove(value);
    }

    public void clear() {
        this.target.clear();
    }

    @Override
    public void run() {
        this.target.run();
    }

    public Thread getCleanerThread() {
        return this.target.getCleanerThread();
    }

    public static enum Cleaner {
        THREAD,
        INLINE,
        MANUAL;

    }
}

