/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.impl;

import com.blibli.oss.command.Command;
import com.blibli.oss.command.CommandExecutor;
import com.blibli.oss.command.exception.CommandValidationException;
import com.blibli.oss.command.helper.ErrorHelper;
import com.blibli.oss.command.plugin.CommandInterceptor;
import com.blibli.oss.command.plugin.InterceptorUtil;
import java.util.Collection;
import java.util.Set;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Mono;

public class CommandExecutorImpl
implements CommandExecutor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CommandExecutorImpl.class);
    private Validator validator;
    private ApplicationContext applicationContext;
    private Collection<CommandInterceptor> commandInterceptors;

    public CommandExecutorImpl(Validator validator) {
        this.validator = validator;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.commandInterceptors = InterceptorUtil.getCommandInterceptors(applicationContext);
    }

    @Override
    public <R, T> Mono<T> execute(Class<? extends Command<R, T>> commandClass, R request) {
        return this.validateRequest(request, commandClass).flatMap(validRequest -> this.doExecute(commandClass, validRequest));
    }

    private <R> Mono<R> validateRequest(R request, Class<? extends Command<?, ?>> clazz) {
        return Mono.fromCallable(() -> {
            if (this.isValidateRequest(clazz)) {
                log.info("Validate request {}", (Object)request.getClass().getName());
                this.validateAndThrownIfInvalid(request);
            }
            return request;
        });
    }

    private boolean isValidateRequest(Class<? extends Command<?, ?>> clazz) {
        Command bean = (Command)this.applicationContext.getBean(clazz);
        return bean.validateRequest();
    }

    private <R> void validateAndThrownIfInvalid(R request) throws CommandValidationException {
        Set constraintViolations = this.validator.validate(request, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            String validationMessage = ErrorHelper.from(constraintViolations).toString();
            log.warn("Invalid command request with validation message {}", (Object)validationMessage);
            throw new CommandValidationException(validationMessage, constraintViolations);
        }
    }

    private <R, T> Mono<T> doExecute(Class<? extends Command<R, T>> commandClass, R request) {
        Command command = (Command)this.applicationContext.getBean(commandClass);
        return InterceptorUtil.beforeExecute(this.commandInterceptors, command, request).switchIfEmpty(this.doExecuteCommand(request, command));
    }

    private <R, T> Mono<T> doExecuteCommand(R request, Command<R, T> command) {
        return command.execute(request).doOnSuccess(response -> InterceptorUtil.afterSuccessExecute(this.commandInterceptors, command, request, response).subscribe()).doOnError(throwable -> InterceptorUtil.afterFailedExecute(this.commandInterceptors, command, request, throwable).subscribe()).onErrorResume(throwable -> command.fallback((Throwable)throwable, request));
    }
}

