/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.cache.impl;

import com.blibli.oss.command.cache.CommandCache;
import com.blibli.oss.command.properties.CommandProperties;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CommandCacheImpl
implements CommandCache {
    private CommandProperties commandProperties;
    private ReactiveStringRedisTemplate reactiveStringRedisTemplate;

    public CommandCacheImpl(ReactiveStringRedisTemplate reactiveStringRedisTemplate, CommandProperties commandProperties) {
        this.reactiveStringRedisTemplate = reactiveStringRedisTemplate;
        this.commandProperties = commandProperties;
    }

    @Override
    public Mono<String> get(String key) {
        return this.reactiveStringRedisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public Mono<Boolean> cache(String key, String value) {
        return this.reactiveStringRedisTemplate.opsForValue().set((Object)key, (Object)value, this.commandProperties.getCache().getTimeoutDuration());
    }

    @Override
    public Mono<Long> evict(String ... keys) {
        return this.reactiveStringRedisTemplate.delete((Publisher)Flux.fromArray((Object[])keys));
    }
}

