/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.plugin;

import com.blibli.oss.command.Command;
import com.blibli.oss.command.plugin.CommandInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.OrderComparator;

public class InterceptorUtil {
    private static final Logger log = LoggerFactory.getLogger(InterceptorUtil.class);

    public static List<CommandInterceptor> getCommandInterceptors(ApplicationContext applicationContext) {
        List<CommandInterceptor> interceptors = Collections.emptyList();
        Map beans = applicationContext.getBeansOfType(CommandInterceptor.class);
        if (beans != null && !beans.isEmpty()) {
            interceptors = new ArrayList(beans.values());
        }
        OrderComparator.sort(interceptors);
        return interceptors;
    }

    public static <R, T> T beforeExecute(Collection<CommandInterceptor> commandInterceptors, Command<R, T> command, R request) {
        for (CommandInterceptor interceptor : commandInterceptors) {
            try {
                T result = interceptor.beforeExecute(command, request);
                if (result == null) continue;
                return result;
            }
            catch (Throwable throwable) {
                log.warn("Error beforeExecute() interceptor " + interceptor.getClass().getName(), throwable);
            }
        }
        return null;
    }

    public static <R, T> void afterSuccessExecute(Collection<CommandInterceptor> commandInterceptors, Command<R, T> command, R request, T response) {
        commandInterceptors.forEach(interceptor -> {
            try {
                interceptor.afterSuccessExecute(command, request, response);
            }
            catch (Throwable throwable) {
                log.warn("Error afterSuccessExecute() interceptor " + interceptor.getClass().getName(), throwable);
            }
        });
    }

    public static <R, T> void afterFailedExecute(Collection<CommandInterceptor> commandInterceptors, Command<R, T> command, R request, Throwable throwable) {
        commandInterceptors.forEach(interceptor -> {
            try {
                interceptor.afterFailedExecute(command, request, throwable);
            }
            catch (Throwable error) {
                log.warn("Error afterFailedExecute() interceptor " + interceptor.getClass().getName(), error);
            }
        });
    }
}

