/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.command.hystrix;

import com.blibli.oss.command.Command;
import com.blibli.oss.command.plugin.CommandInterceptor;
import com.blibli.oss.command.plugin.InterceptorUtil;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixObservableCommand;
import java.util.Collection;
import rx.Observable;
import rx.Single;

public class CommandHystrix<R, T>
extends HystrixObservableCommand<T> {
    protected Collection<CommandInterceptor> commandInterceptors;
    protected Command<R, T> command;
    protected R request;

    public CommandHystrix(Command<R, T> command, R request, String commandKey, String commandGroup, Collection<CommandInterceptor> commandInterceptors) {
        super(HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)commandGroup)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey)));
        this.command = command;
        this.request = request;
        this.commandInterceptors = commandInterceptors;
    }

    protected Observable<T> construct() {
        return this.command.execute(this.request).doOnSuccess(response -> InterceptorUtil.afterSuccessExecute(this.commandInterceptors, this.command, this.request, response)).toObservable();
    }

    protected Observable<T> resumeWithFallback() {
        return Single.just((Object)this.getExecutionException()).doOnSuccess(throwable -> InterceptorUtil.afterFailedExecute(this.commandInterceptors, this.command, this.request, throwable)).flatMap(throwable -> this.command.fallback((Throwable)throwable, this.request)).toObservable();
    }
}

