/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.backend.sleuth.webflux;

import brave.Span;
import brave.Tracer;
import java.util.Objects;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFilter;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public interface SleuthWebFilter
extends WebFilter,
Ordered {
    default public int getOrder() {
        return -2147483638;
    }

    default public Span getCurrentSpan(ServerWebExchange exchange) {
        Span span = this.getTracer().currentSpan();
        if (Objects.isNull(span)) {
            span = (Span)exchange.getAttribute(TraceWebFilter.class.getName() + ".TRACE");
        }
        return span;
    }

    default public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return Mono.fromCallable(() -> this.getCurrentSpan(exchange)).flatMap(span -> this.filter(exchange, chain, (Span)span));
    }

    public Tracer getTracer();

    public Mono<Void> filter(ServerWebExchange var1, WebFilterChain var2, Span var3);
}

