/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import org.springframework.data.domain.Sort;

public final class EntityViewSortUtil {
    private EntityViewSortUtil() {
    }

    private static String resolveViewAttributeSelectAlias(ManagedViewType<?> viewType, String attributePath) {
        StringBuilder aliasBuilder = new StringBuilder(viewType.getJavaType().getSimpleName());
        for (String pathElement : attributePath.split("\\.")) {
            if (viewType == null) {
                return null;
            }
            MethodAttribute attribute = viewType.getAttribute(pathElement);
            if (attribute == null) {
                return null;
            }
            aliasBuilder.append('_').append(pathElement);
            Type type = attribute instanceof SingularAttribute ? ((SingularAttribute)attribute).getType() : ((PluralAttribute)attribute).getElementType();
            viewType = type instanceof ManagedViewType ? (ManagedViewType)type : null;
        }
        return aliasBuilder.toString();
    }

    public static void applySort(EntityViewManager evm, Class<?> entityViewClass, FullQueryBuilder<?, ?> cb, Sort sort) {
        ManagedViewType viewType = evm.getMetamodel().managedViewOrError(entityViewClass);
        for (Sort.Order order : sort) {
            String entityViewAttributeAlias = EntityViewSortUtil.resolveViewAttributeSelectAlias(viewType, order.getProperty());
            if (entityViewAttributeAlias == null) {
                cb.orderBy(order.getProperty(), order.isAscending(), order.getNullHandling() == Sort.NullHandling.NULLS_FIRST);
                continue;
            }
            cb.orderBy(entityViewAttributeAlias, order.isAscending(), order.getNullHandling() == Sort.NullHandling.NULLS_FIRST);
        }
    }
}

