/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.integration.view.spring.impl;

import com.blazebit.persistence.integration.view.spring.impl.EntityViewComponentProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.TypeFilter;

public abstract class AbstractEntityViewConfigurationSource {
    private final Environment environment;

    public AbstractEntityViewConfigurationSource(Environment environment) {
        this.environment = environment;
    }

    public abstract Iterable<String> getBasePackages();

    protected abstract Iterable<TypeFilter> getExcludeFilters();

    protected abstract Iterable<TypeFilter> getIncludeFilters();

    public Collection<BeanDefinition> getCandidates(ResourceLoader resourceLoader) {
        EntityViewComponentProvider scanner = new EntityViewComponentProvider(this.getIncludeFilters());
        scanner.setResourceLoader(resourceLoader);
        scanner.setEnvironment(this.environment);
        for (TypeFilter filter : this.getExcludeFilters()) {
            scanner.addExcludeFilter(filter);
        }
        HashSet<BeanDefinition> result = new HashSet<BeanDefinition>();
        for (String basePackage : this.getBasePackages()) {
            Set candidate = scanner.findCandidateComponents(basePackage);
            result.addAll(candidate);
        }
        return result;
    }
}

