/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.processor;

import com.blazebit.persistence.view.processor.Context;
import com.blazebit.persistence.view.processor.EntityIdAttribute;
import com.blazebit.persistence.view.processor.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class EntityViewTypeUtils {
    private static final Map<String, Mutability> MUTABILITY;

    private EntityViewTypeUtils() {
    }

    private static void immutable(Map<String, Mutability> mutability, String fqcn) {
        mutability.put(fqcn, Mutability.IMMUTABLE);
    }

    private static void mutable(Map<String, Mutability> mutability, String fqcn) {
        mutability.put(fqcn, Mutability.MUTABLE);
    }

    private static void trackable(Map<String, Mutability> mutability, String fqcn) {
        mutability.put(fqcn, Mutability.DIRTY_TRACKABLE);
    }

    public static Mutability getMutability(String fqcn) {
        Mutability mutability = MUTABILITY.get(fqcn);
        return mutability == null ? Mutability.MUTABLE : mutability;
    }

    public static String getAttributeName(Element element) {
        String name = element.getSimpleName().toString();
        if (element.getKind() == ElementKind.METHOD) {
            if (name.startsWith("get")) {
                return EntityViewTypeUtils.firstToLower(3, name);
            }
            if (name.startsWith("is")) {
                return EntityViewTypeUtils.firstToLower(2, name);
            }
            return EntityViewTypeUtils.firstToLower(0, name);
        }
        return name;
    }

    public static String firstToLower(int skip, CharSequence s) {
        StringBuilder sb = new StringBuilder(s.length());
        sb.append(Character.toLowerCase(s.charAt(skip)));
        sb.append(s, skip + 1, s.length());
        return sb.toString();
    }

    public static SubviewInfo getSubviewInfo(TypeElement typeElement, Context context) {
        Element subviewIdElement = null;
        boolean hasEmptyConstructor = typeElement.getKind() == ElementKind.INTERFACE;
        for (Element element : context.getAllMembers(typeElement)) {
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                if (!((ExecutableElement)element).getParameters().isEmpty()) continue;
                hasEmptyConstructor = true;
                if (subviewIdElement == null) continue;
                break;
            }
            if (!TypeUtils.containsAnnotation(element, "com.blazebit.persistence.view.IdMapping")) continue;
            subviewIdElement = element;
            if (!hasEmptyConstructor) continue;
            break;
        }
        return new SubviewInfo(subviewIdElement, hasEmptyConstructor);
    }

    public static List<EntityIdAttribute> getEntityIdAttributes(String realType, Context context) {
        ArrayList<EntityIdAttribute> elements = new ArrayList<EntityIdAttribute>();
        TypeElement typeElement = context.getTypeElement(realType);
        for (Element element : typeElement.getEnclosedElements()) {
            if (!TypeUtils.containsAnnotation(element, "javax.persistence.Id", "javax.persistence.EmbeddedId")) continue;
            elements.add(new EntityIdAttribute(element));
        }
        return elements;
    }

    public static boolean isMutable(TypeElement subviewElement, Context context) {
        return TypeUtils.containsAnnotation(subviewElement, "com.blazebit.persistence.view.UpdatableEntityView", "com.blazebit.persistence.view.CreatableEntityView");
    }

    static {
        HashMap<String, Mutability> mutability = new HashMap<String, Mutability>();
        EntityViewTypeUtils.immutable(mutability, "java.lang.Boolean");
        EntityViewTypeUtils.immutable(mutability, "boolean");
        EntityViewTypeUtils.immutable(mutability, "java.lang.Byte");
        EntityViewTypeUtils.immutable(mutability, "byte");
        EntityViewTypeUtils.immutable(mutability, "java.lang.Short");
        EntityViewTypeUtils.immutable(mutability, "short");
        EntityViewTypeUtils.immutable(mutability, "java.lang.Character");
        EntityViewTypeUtils.immutable(mutability, "char");
        EntityViewTypeUtils.immutable(mutability, "java.lang.Integer");
        EntityViewTypeUtils.immutable(mutability, "int");
        EntityViewTypeUtils.immutable(mutability, "java.lang.Long");
        EntityViewTypeUtils.immutable(mutability, "long");
        EntityViewTypeUtils.immutable(mutability, "java.lang.Float");
        EntityViewTypeUtils.immutable(mutability, "float");
        EntityViewTypeUtils.immutable(mutability, "java.lang.Double");
        EntityViewTypeUtils.immutable(mutability, "double");
        EntityViewTypeUtils.immutable(mutability, "java.math.BigInteger");
        EntityViewTypeUtils.immutable(mutability, "java.math.BigDecimal");
        EntityViewTypeUtils.immutable(mutability, "java.lang.String");
        EntityViewTypeUtils.immutable(mutability, "java.io.InputStream");
        EntityViewTypeUtils.trackable(mutability, "java.sql.Blob");
        EntityViewTypeUtils.trackable(mutability, "java.sql.Clob");
        EntityViewTypeUtils.trackable(mutability, "java.sql.NClob");
        EntityViewTypeUtils.mutable(mutability, "java.lang.Byte[]");
        EntityViewTypeUtils.mutable(mutability, "byte[]");
        EntityViewTypeUtils.mutable(mutability, "java.lang.Character[]");
        EntityViewTypeUtils.mutable(mutability, "char[]");
        EntityViewTypeUtils.mutable(mutability, "java.util.Date");
        EntityViewTypeUtils.mutable(mutability, "java.sql.Date");
        EntityViewTypeUtils.mutable(mutability, "java.sql.Time");
        EntityViewTypeUtils.mutable(mutability, "java.sql.Timestamp");
        EntityViewTypeUtils.mutable(mutability, "java.util.TimeZone");
        EntityViewTypeUtils.mutable(mutability, "java.util.Calendar");
        EntityViewTypeUtils.mutable(mutability, "java.util.GregorianCalendar");
        EntityViewTypeUtils.immutable(mutability, "java.lang.Class");
        EntityViewTypeUtils.immutable(mutability, "java.util.Currency");
        EntityViewTypeUtils.immutable(mutability, "java.util.Locale");
        EntityViewTypeUtils.immutable(mutability, "java.util.UUID");
        EntityViewTypeUtils.immutable(mutability, "java.net.URL");
        EntityViewTypeUtils.immutable(mutability, "java.time.LocalDate");
        EntityViewTypeUtils.immutable(mutability, "java.time.LocalTime");
        EntityViewTypeUtils.immutable(mutability, "java.time.LocalDateTime");
        EntityViewTypeUtils.immutable(mutability, "java.time.OffsetTime");
        EntityViewTypeUtils.immutable(mutability, "java.time.OffsetDateTime");
        EntityViewTypeUtils.immutable(mutability, "java.time.ZonedDateTime");
        EntityViewTypeUtils.immutable(mutability, "java.time.Duration");
        EntityViewTypeUtils.immutable(mutability, "java.time.Instant");
        EntityViewTypeUtils.immutable(mutability, "java.time.MonthDay");
        EntityViewTypeUtils.immutable(mutability, "java.time.Year");
        EntityViewTypeUtils.immutable(mutability, "java.time.YearMonth");
        EntityViewTypeUtils.immutable(mutability, "java.time.Period");
        EntityViewTypeUtils.immutable(mutability, "java.time.ZoneId");
        EntityViewTypeUtils.immutable(mutability, "java.time.ZoneOffset");
        MUTABILITY = mutability;
    }

    public static enum Mutability {
        IMMUTABLE,
        DIRTY_TRACKABLE,
        MUTABLE;

    }

    public static class SubviewInfo {
        private final Element entityViewIdElement;
        private final boolean hasEmptyConstructor;

        public SubviewInfo(Element entityViewIdElement, boolean hasEmptyConstructor) {
            this.entityViewIdElement = entityViewIdElement;
            this.hasEmptyConstructor = hasEmptyConstructor;
        }

        public Element getEntityViewIdElement() {
            return this.entityViewIdElement;
        }

        public boolean hasEmptyConstructor() {
            return this.hasEmptyConstructor;
        }
    }
}

