/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.mapper;

import java.util.AbstractList;
import java.util.List;

public final class MultisetList
extends AbstractList<Object[]> {
    private final int index;
    private final List<Object[]> source;
    private final int[] sizes;
    private int size;
    private int lastIndex = -1;
    private int lastSizeOffset;
    private List<Object[]> lastList;

    public MultisetList(int index, List<Object[]> source) {
        this.index = index;
        this.source = source;
        this.sizes = new int[source.size()];
    }

    public void addSize(int index, int size) {
        this.size += size;
        this.sizes[index] = (index == 0 ? 0 : this.sizes[index - 1]) + size;
    }

    @Override
    public Object[] get(int index) {
        this.resolveTupleIndex(index);
        List<Object[]> list = this.lastList;
        if (list == null) {
            return null;
        }
        return list.get(index - this.lastSizeOffset);
    }

    @Override
    public Object[] set(int index, Object[] element) {
        this.resolveTupleIndex(index);
        List<Object[]> list = this.lastList;
        if (list == null) {
            return null;
        }
        return list.set(index - this.lastSizeOffset, element);
    }

    @Override
    public Object[] remove(int index) {
        int tupleIndex = this.resolveTupleIndex(index);
        List<Object[]> list = this.lastList;
        if (list == null) {
            return null;
        }
        if (tupleIndex == -1) {
            for (tupleIndex = 0; tupleIndex < this.sizes.length && (index >= this.sizes[tupleIndex] || ((List)this.source.get(tupleIndex)[this.index]).isEmpty()); ++tupleIndex) {
            }
        }
        Object[] old = list.remove(index - this.lastSizeOffset);
        int i = tupleIndex;
        while (i < this.sizes.length) {
            int n = i++;
            this.sizes[n] = this.sizes[n] - 1;
        }
        --this.size;
        this.lastIndex = -1;
        return old;
    }

    private int resolveTupleIndex(int index) {
        int tupleIndex;
        if (this.lastIndex + this.lastSizeOffset == index) {
            return -1;
        }
        int lastSizeOffset = 0;
        for (tupleIndex = 0; tupleIndex < this.sizes.length && (index >= this.sizes[tupleIndex] || ((List)this.source.get(tupleIndex)[this.index]).isEmpty()); ++tupleIndex) {
            lastSizeOffset = this.sizes[tupleIndex];
        }
        this.lastSizeOffset = lastSizeOffset;
        this.lastIndex = index - lastSizeOffset;
        this.lastList = (List)this.source.get(tupleIndex)[this.index];
        return tupleIndex;
    }

    @Override
    public int size() {
        return this.size;
    }
}

